/*
 * Decompiled with CFR 0.152.
 */
package Handlers;

import Zombies.GameArena;
import Zombies.Main;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockGrowEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockSpreadEvent;
import org.bukkit.event.block.LeavesDecayEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.entity.SlimeSplitEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.hanging.HangingBreakEvent;
import org.bukkit.event.hanging.HangingPlaceEvent;
import org.bukkit.event.player.PlayerArmorStandManipulateEvent;
import org.bukkit.event.player.PlayerBedEnterEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.vehicle.VehicleEntityCollisionEvent;
import org.bukkit.event.weather.WeatherChangeEvent;

public class WorldHandler
implements Listener {
    @EventHandler
    public void blockSpread(BlockSpreadEvent blockSpreadEvent) {
        if (Main.getInstance().getConfiguration().getBoolean("MultiArena.Enabled").booleanValue()) {
            return;
        }
        blockSpreadEvent.setCancelled(true);
    }

    @EventHandler
    public void playerInteract(PlayerInteractEvent playerInteractEvent) {
        Player player = playerInteractEvent.getPlayer();
        GameArena gameArena = Main.getInstance().getConfiguration().getGameArena(player);
        if (gameArena != null) {
            playerInteractEvent.setUseInteractedBlock(Event.Result.DENY);
        }
    }

    @EventHandler
    public void manipulateArmorStands(PlayerArmorStandManipulateEvent playerArmorStandManipulateEvent) {
        Player player = playerArmorStandManipulateEvent.getPlayer();
        GameArena gameArena = Main.getInstance().getConfiguration().getGameArena(player);
        if (gameArena != null) {
            playerArmorStandManipulateEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void hangingPlace(HangingPlaceEvent hangingPlaceEvent) {
        Player player = hangingPlaceEvent.getPlayer();
        GameArena gameArena = Main.getInstance().getConfiguration().getGameArena(player);
        if (gameArena != null) {
            hangingPlaceEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void hangingBreak(HangingBreakEvent hangingBreakEvent) {
        if (Main.getInstance().getConfiguration().getBoolean("MultiArena.Enabled").booleanValue()) {
            return;
        }
        hangingBreakEvent.setCancelled(true);
    }

    @EventHandler
    public void hangingBreakByEntity(HangingBreakByEntityEvent hangingBreakByEntityEvent) {
        if (Main.getInstance().getConfiguration().getBoolean("MultiArena.Enabled").booleanValue()) {
            return;
        }
        hangingBreakByEntityEvent.setCancelled(true);
    }

    @EventHandler
    public void entitySplit(SlimeSplitEvent slimeSplitEvent) {
        if (Main.getInstance().getConfiguration().getBoolean("MultiArena.Enabled").booleanValue()) {
            return;
        }
        slimeSplitEvent.setCancelled(true);
    }

    @EventHandler
    public void vehicleEntityCollosion(VehicleEntityCollisionEvent vehicleEntityCollisionEvent) {
        if (Main.getInstance().getConfiguration().getBoolean("MultiArena.Enabled").booleanValue()) {
            return;
        }
        vehicleEntityCollisionEvent.setCancelled(true);
    }

    @EventHandler
    public void changeWeather(WeatherChangeEvent weatherChangeEvent) {
        if (Main.getInstance().getConfiguration().getBoolean("MultiArena.Enabled").booleanValue()) {
            return;
        }
        weatherChangeEvent.setCancelled(true);
    }

    @EventHandler
    public void blockIgnite(BlockIgniteEvent blockIgniteEvent) {
        if (Main.getInstance().getConfiguration().getBoolean("MultiArena.Enabled").booleanValue()) {
            return;
        }
        blockIgniteEvent.setCancelled(true);
    }

    @EventHandler
    public void blockExplode(BlockExplodeEvent blockExplodeEvent) {
        if (Main.getInstance().getConfiguration().getBoolean("MultiArena.Enabled").booleanValue()) {
            return;
        }
        blockExplodeEvent.blockList().clear();
    }

    @EventHandler
    public void entityExplode(EntityExplodeEvent entityExplodeEvent) {
        if (Main.getInstance().getConfiguration().getBoolean("MultiArena.Enabled").booleanValue()) {
            if (entityExplodeEvent.getEntity().hasMetadata("Arena") || entityExplodeEvent.getEntity().hasMetadata("WeaponExplosion")) {
                entityExplodeEvent.blockList().clear();
            }
            return;
        }
        entityExplodeEvent.blockList().clear();
    }

    @EventHandler
    public void blockGrow(BlockGrowEvent blockGrowEvent) {
        if (Main.getInstance().getConfiguration().getBoolean("MultiArena.Enabled").booleanValue()) {
            return;
        }
        blockGrowEvent.setCancelled(true);
    }

    @EventHandler
    public void leavesDecay(LeavesDecayEvent leavesDecayEvent) {
        if (Main.getInstance().getConfiguration().getBoolean("MultiArena.Enabled").booleanValue()) {
            return;
        }
        leavesDecayEvent.setCancelled(true);
    }

    @EventHandler
    public void blockBurn(BlockBurnEvent blockBurnEvent) {
        if (Main.getInstance().getConfiguration().getBoolean("MultiArena.Enabled").booleanValue()) {
            return;
        }
        blockBurnEvent.setCancelled(true);
    }

    @EventHandler
    public void fadeBlocks(BlockFadeEvent blockFadeEvent) {
        if (Main.getInstance().getConfiguration().getBoolean("MultiArena.Enabled").booleanValue()) {
            return;
        }
        blockFadeEvent.setCancelled(true);
    }

    @EventHandler
    public void breakBlocks(BlockBreakEvent blockBreakEvent) {
        Player player = blockBreakEvent.getPlayer();
        GameArena gameArena = Main.getInstance().getConfiguration().getGameArena(player);
        if (gameArena != null) {
            blockBreakEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void placeBlocks(BlockPlaceEvent blockPlaceEvent) {
        Player player = blockPlaceEvent.getPlayer();
        GameArena gameArena = Main.getInstance().getConfiguration().getGameArena(player);
        if (gameArena != null) {
            blockPlaceEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void creatureSpawn(CreatureSpawnEvent creatureSpawnEvent) {
        if (Main.getInstance().getConfiguration().getBoolean("MultiArena.Enabled").booleanValue()) {
            return;
        }
        if (creatureSpawnEvent.getSpawnReason() == CreatureSpawnEvent.SpawnReason.CUSTOM) {
            return;
        }
        creatureSpawnEvent.setCancelled(true);
    }

    @EventHandler
    public void enterPortal(PlayerPortalEvent playerPortalEvent) {
        if (Main.getInstance().getConfiguration().getBoolean("MultiArena.Enabled").booleanValue()) {
            return;
        }
        playerPortalEvent.setCancelled(true);
    }

    @EventHandler
    public void playerBedEnter(PlayerBedEnterEvent playerBedEnterEvent) {
        Player player = playerBedEnterEvent.getPlayer();
        GameArena gameArena = Main.getInstance().getConfiguration().getGameArena(player);
        if (gameArena != null) {
            playerBedEnterEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void breakHanging(HangingBreakByEntityEvent hangingBreakByEntityEvent) {
        if (hangingBreakByEntityEvent.getRemover() instanceof Player) {
            Player player = (Player)hangingBreakByEntityEvent.getRemover();
            GameArena gameArena = Main.getInstance().getConfiguration().getGameArena(player);
            if (gameArena != null) {
                hangingBreakByEntityEvent.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void breakHanging(HangingBreakEvent hangingBreakEvent) {
        if (Main.getInstance().getConfiguration().getBoolean("MultiArena.Enabled").booleanValue()) {
            return;
        }
        hangingBreakEvent.setCancelled(true);
    }

    @EventHandler
    public void placeHanging(HangingPlaceEvent hangingPlaceEvent) {
        Player player = hangingPlaceEvent.getPlayer();
        GameArena gameArena = Main.getInstance().getConfiguration().getGameArena(player);
        if (gameArena != null) {
            hangingPlaceEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void foodLevelChange(FoodLevelChangeEvent foodLevelChangeEvent) {
        if (foodLevelChangeEvent.getEntity() instanceof Player) {
            Player player = (Player)foodLevelChangeEvent.getEntity();
            GameArena gameArena = Main.getInstance().getConfiguration().getGameArena(player);
            if (gameArena != null) {
                foodLevelChangeEvent.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void pickupItem(PlayerPickupItemEvent playerPickupItemEvent) {
        Player player = playerPickupItemEvent.getPlayer();
        GameArena gameArena = Main.getInstance().getConfiguration().getGameArena(player);
        if (gameArena != null) {
            playerPickupItemEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void dropItem(PlayerDropItemEvent playerDropItemEvent) {
        Player player = playerDropItemEvent.getPlayer();
        GameArena gameArena = Main.getInstance().getConfiguration().getGameArena(player);
        if (gameArena != null) {
            playerDropItemEvent.getItemDrop().remove();
            player.getInventory().setItem(player.getInventory().getHeldItemSlot(), playerDropItemEvent.getItemDrop().getItemStack());
        }
    }
}

