/*
 * Decompiled with CFR 0.152.
 */
package HologramAPI;

import Utils.Reflection;
import Zombies.Configuration;
import Zombies.GameArena;
import Zombies.Main;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class Hologram {
    private static Class<?> craftWorld;
    private static Class<?> entityClass;
    private static Class<?> nmsWorld;
    private static Class<?> armorStand;
    private static Class<?> entityLiving;
    private static Class<?> spawnPacket;
    private static Class<?> removePacket;
    private static Class<?> metaPacket;
    private static Class<?> dataWatcher;
    private static Class<?> packet;
    private static Method getHandle;
    private static Method getDataWatcher;
    private static Method getDataWatcherB;
    private static final int versionId;
    private Location location;
    private List<String> lines = new ArrayList<String>();
    private final List<Integer> ids = new ArrayList<Integer>();
    private final List<Object> entities = new ArrayList<Object>();
    private final Map<Object, String> oldObjects = new HashMap<Object, String>();
    private final double offset = 0.23;

    public Hologram(Location location) {
        this.location = location;
    }

    public Hologram(Location location, String ... stringArray) {
        this.location = location;
        this.addLine(stringArray);
    }

    public void addCleanLine(String ... stringArray) {
        this.lines.addAll(Arrays.asList(stringArray));
    }

    public void addLine(String ... stringArray) {
        this.lines.addAll(Arrays.asList(stringArray));
        this.update();
    }

    public List<String> getLines() {
        return this.lines;
    }

    public void setLines(List<String> list) {
        this.lines = list;
        this.update();
    }

    public void setCleanLines(String ... stringArray) {
        this.lines = Arrays.asList(stringArray);
    }

    public void setCleanLines(List<String> list) {
        this.lines = list;
    }

    public void setLines(String ... stringArray) {
        this.lines = Arrays.asList(stringArray);
        this.update();
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
        this.update();
    }

    public void teleport(Location location) {
        this.setLocation(location);
    }

    public void show(GameArena gameArena) {
        ArrayList<Player> arrayList = new ArrayList<Player>();
        arrayList.addAll(gameArena.getDisplayedPlayers());
        this.show(arrayList);
    }

    public void show(List<Player> list) {
        Location location = this.location.clone().add(0.0, (double)(this.lines.size() / 2) * 0.23, 0.0);
        for (String string : this.lines) {
            Object[] objectArray = this.getCreatePacket(location, Configuration.translateTextCodes(string));
            assert (objectArray != null);
            this.ids.add((Integer)objectArray[2]);
            for (Player player : list) {
                this.sendPacket(player, objectArray[1]);
                this.sendPacket(player, objectArray[0]);
            }
            location.subtract(0.0, 0.23, 0.0);
        }
    }

    public void show(Player player) {
        this.show(Collections.singletonList(player));
    }

    public void destroyFrom(Player player) {
        for (int n : this.ids) {
            Object object = this.getRemovePacket(n);
            this.sendPacket(player, object);
        }
    }

    public void destroyFrom(List<Player> list) {
        for (int n : this.ids) {
            Object object = this.getRemovePacket(n);
            for (Player player : list) {
                if (object == null) continue;
                this.sendPacket(player, object);
            }
        }
    }

    public void destroyFromAll(GameArena gameArena) {
        ArrayList<Player> arrayList = new ArrayList<Player>(gameArena.getDisplayedPlayers());
        this.destroyFrom(arrayList);
        this.destroy();
    }

    public void spawn() {
        Location location = this.location.clone().add(0.0, (double)(this.lines.size() / 2) * 0.23, 0.0).add(0.0, 0.23, 0.0);
        for (String string : this.lines) {
            this.spawnHologram(Configuration.translateTextCodes(string), location.subtract(0.0, 0.23, 0.0));
        }
    }

    private void spawnHologram(String string, Location location) {
        try {
            Object obj;
            Object obj2 = craftWorld.cast(location.getWorld());
            if (versionId > 13) {
                double d = location.getX();
                double d2 = location.getY();
                double d3 = location.getZ();
                Object object = craftWorld.getMethod("getHandle", new Class[0]).invoke(obj2, new Object[0]);
                obj = armorStand.getConstructor(nmsWorld, Double.TYPE, Double.TYPE, Double.TYPE).newInstance(object, d, d2, d3);
            } else {
                obj = armorStand.getConstructor(nmsWorld).newInstance(craftWorld.getMethod("getHandle", new Class[0]).invoke(obj2, new Object[0]));
            }
            this.configureHologram(obj, string, location);
            craftWorld.getMethod("addEntity", entityClass, CreatureSpawnEvent.SpawnReason.class).invoke(obj2, obj, CreatureSpawnEvent.SpawnReason.CUSTOM);
            this.entities.add(obj);
            this.oldObjects.put(obj, string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void destroy() {
        for (Object object : this.entities) {
            this.removeEntity(object);
        }
        this.entities.clear();
    }

    private void removeEntity(Object ... objectArray) {
        try {
            Object obj = craftWorld.cast(this.location.getWorld());
            for (Object object : objectArray) {
                if (versionId > 13) {
                    Entity entity = (Entity)entityClass.getDeclaredMethod("getBukkitEntity", new Class[0]).invoke(object, new Object[0]);
                    entity.remove();
                    continue;
                }
                nmsWorld.getMethod("removeEntity", entityClass).invoke(craftWorld.getMethod("getHandle", new Class[0]).invoke(obj, new Object[0]), object);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private Object[] getCreatePacket(Location location, String string) {
        try {
            Object obj;
            Object obj2 = craftWorld.cast(location.getWorld());
            if (versionId > 13) {
                double d = location.getX();
                double d2 = location.getY();
                double d3 = location.getZ();
                Object object = craftWorld.getMethod("getHandle", new Class[0]).invoke(obj2, new Object[0]);
                obj = armorStand.getConstructor(nmsWorld, Double.TYPE, Double.TYPE, Double.TYPE).newInstance(object, d, d2, d3);
            } else {
                obj = armorStand.getConstructor(nmsWorld).newInstance(craftWorld.getMethod("getHandle", new Class[0]).invoke(obj2, new Object[0]));
            }
            Object object = obj.getClass().getMethod("af", new Class[0]).invoke(obj, new Object[0]);
            this.configureHologram(obj, string, location);
            Object obj3 = metaPacket.getConstructor(Integer.TYPE, List.class).newInstance((Integer)object, getDataWatcherB.invoke(getDataWatcher.invoke(obj, new Object[0]), new Object[0]));
            return new Object[]{obj3, spawnPacket.getConstructor(entityClass).newInstance(obj), object};
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private Object getRemovePacket(int n) {
        try {
            return removePacket.getConstructor(int[].class).newInstance(new Object[]{new int[]{n}});
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void update() {
        try {
            if (!this.entities.isEmpty()) {
                for (int i = 0; i < this.entities.size(); ++i) {
                    Object object = this.entities.get(i);
                    if (i <= this.lines.size() - 1) continue;
                    this.removeEntity(object);
                }
                Location location = this.location.clone().add(0.0, (double)(this.lines.size() / 2) * 0.23, 0.0);
                for (int i = 0; i < this.lines.size(); ++i) {
                    String string = Configuration.translateTextCodes(this.lines.get(i));
                    if (i >= this.entities.size()) {
                        this.spawnHologram(string, location);
                    } else {
                        this.configureHologram(this.entities.get(i), string, location);
                    }
                    location.subtract(0.0, 0.23, 0.0);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void configureHologram(Object object, String string, Location location) {
        Method method = object.getClass().getMethod("a", Double.TYPE, Double.TYPE, Double.TYPE, Float.TYPE, Float.TYPE);
        if (versionId >= 16) {
            Class<?> clazz = Reflection.getMinecraftClass("net.minecraft.network.chat.IChatBaseComponent$ChatSerializer");
            Method method2 = object.getClass().getMethod("a", Reflection.getMinecraftClass("net.minecraft.network.chat.IChatBaseComponent"));
            Method method3 = object.getClass().getMethod("n", Boolean.TYPE);
            Method method4 = object.getClass().getMethod("e", Boolean.TYPE);
            Method method5 = object.getClass().getMethod("n", Boolean.TYPE);
            Method method6 = object.getClass().getMethod("j", Boolean.TYPE);
            Method method7 = object.getClass().getMethod("a", Boolean.TYPE);
            method2.invoke(object, clazz.getMethod("a", String.class).invoke(null, "{\"text\": \"" + string + '\"' + "}"));
            method3.invoke(object, true);
            method7.invoke(object, true);
            method6.invoke(object, true);
            method4.invoke(object, true);
            method5.invoke(object, true);
            Entity entity = (Entity)entityClass.getDeclaredMethod("getBukkitEntity", new Class[0]).invoke(object, new Object[0]);
            if (entity instanceof ArmorStand) {
                ArmorStand armorStand = (ArmorStand)entity;
                armorStand.setVisible(false);
                armorStand.setMarker(true);
                armorStand.setSmall(true);
                armorStand.setGravity(true);
                armorStand.setCustomNameVisible(true);
                armorStand.setCustomName(string);
            }
            method.invoke(object, location.getX(), location.getY(), location.getZ(), Float.valueOf(0.0f), Float.valueOf(0.0f));
        } else if (versionId >= 13) {
            Class<?> clazz = Reflection.getNMSClass("IChatBaseComponent$ChatSerializer");
            Method method8 = object.getClass().getMethod("setCustomName", Reflection.getNMSClass("IChatBaseComponent"));
            Method method9 = object.getClass().getMethod("setCustomNameVisible", Boolean.TYPE);
            Method method10 = object.getClass().getMethod("setNoGravity", Boolean.TYPE);
            Method method11 = object.getClass().getMethod("setInvisible", Boolean.TYPE);
            Method method12 = object.getClass().getMethod("setMarker", Boolean.TYPE);
            Method method13 = object.getClass().getMethod("setSmall", Boolean.TYPE);
            method8.invoke(object, clazz.getMethod("a", String.class).invoke(null, "{\"text\": \"" + string + '\"' + "}"));
            method9.invoke(object, true);
            method13.invoke(object, true);
            method12.invoke(object, true);
            method10.invoke(object, true);
            method11.invoke(object, true);
            method.invoke(object, location.getX(), location.getY(), location.getZ(), Float.valueOf(0.0f), Float.valueOf(0.0f));
        } else {
            if (versionId > 8) {
                Method method14 = object.getClass().getMethod("setCustomName", String.class);
                Method method15 = object.getClass().getMethod("setCustomNameVisible", Boolean.TYPE);
                Method method16 = versionId == 9 ? object.getClass().getMethod("setGravity", Boolean.TYPE) : object.getClass().getMethod("setNoGravity", Boolean.TYPE);
                Method method17 = object.getClass().getMethod("setInvisible", Boolean.TYPE);
                Method method18 = object.getClass().getMethod("setMarker", Boolean.TYPE);
                Method method19 = object.getClass().getMethod("setSmall", Boolean.TYPE);
                method14.invoke(object, string);
                method15.invoke(object, true);
                method19.invoke(object, true);
                method18.invoke(object, true);
                method16.invoke(object, true);
                method17.invoke(object, true);
            } else {
                Entity entity = (Entity)entityClass.getDeclaredMethod("getBukkitEntity", new Class[0]).invoke(object, new Object[0]);
                entity.setMetadata("Unknown", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)"Unknown"));
                if (entity instanceof ArmorStand) {
                    ArmorStand armorStand = (ArmorStand)entity;
                    armorStand.setVisible(false);
                    armorStand.setMarker(true);
                    armorStand.setSmall(true);
                    armorStand.setGravity(false);
                    armorStand.setCustomNameVisible(true);
                    armorStand.setCustomName(string);
                }
            }
            method.invoke(object, location.getX(), location.getY(), location.getZ(), Float.valueOf(0.0f), Float.valueOf(0.0f));
        }
    }

    public void changeTexts(String string, int n) {
        --n;
        for (Map.Entry<Object, String> entry : this.oldObjects.entrySet()) {
            Object object = entry.getKey();
            String string2 = entry.getValue();
            if (this.getLines().size() <= n || !this.getLines().get(n).equals(string2)) continue;
            try {
                Object object2;
                Object object3;
                if (versionId >= 19) {
                    object3 = (Entity)entityClass.getDeclaredMethod("getBukkitEntity", new Class[0]).invoke(object, new Object[0]);
                    if (!(object3 instanceof ArmorStand)) continue;
                    object2 = (ArmorStand)object3;
                    object2.setCustomName(string);
                    this.oldObjects.put(object, string);
                    continue;
                }
                if (versionId >= 16) {
                    object3 = Reflection.getMinecraftClass("net.minecraft.network.chat.IChatBaseComponent$ChatSerializer");
                    object2 = object.getClass().getMethod("a", Reflection.getMinecraftClass("net.minecraft.network.chat.IChatBaseComponent"));
                    ((Method)object2).invoke(object, ((Class)object3).getMethod("a", String.class).invoke(null, "{\"text\": \"" + string + '\"' + "}"));
                    this.oldObjects.put(object, string);
                    continue;
                }
                if (versionId >= 13) {
                    object3 = Reflection.getNMSClass("IChatBaseComponent$ChatSerializer");
                    object2 = object.getClass().getMethod("setCustomName", Reflection.getNMSClass("IChatBaseComponent"));
                    ((Method)object2).invoke(object, ((Class)object3).getMethod("a", String.class).invoke(null, "{\"text\": \"" + string + '\"' + "}"));
                    this.oldObjects.put(object, string);
                    continue;
                }
                object3 = object.getClass().getMethod("setCustomName", String.class);
                ((Method)object3).invoke(object, string);
                this.oldObjects.put(object, string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void sendPacket(Player player, Object object) {
        try {
            if (object == null) {
                return;
            }
            Object object2 = getHandle.invoke((Object)player, new Object[0]);
            Object object3 = Reflection.getValue(object2, "c");
            Method method = Reflection.getMethod(object3, "a", packet);
            assert (method != null);
            method.invoke(object3, object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        versionId = Integer.parseInt(Bukkit.getBukkitVersion().split("-")[0].replace(".", "#").split("#")[1]);
        try {
            Class<?> clazz = Reflection.getCraftClass("entity.CraftPlayer");
            craftWorld = Reflection.getCraftClass("CraftWorld");
            entityClass = Reflection.getMinecraftClass("net.minecraft.world.entity.Entity");
            nmsWorld = Reflection.getMinecraftClass("net.minecraft.world.level.World");
            armorStand = Reflection.getMinecraftClass("net.minecraft.world.entity.decoration.EntityArmorStand");
            entityLiving = Reflection.getMinecraftClass("net.minecraft.world.entity.EntityLiving");
            spawnPacket = Reflection.getMinecraftClass("net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity");
            removePacket = Reflection.getMinecraftClass("net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy");
            metaPacket = Reflection.getMinecraftClass("net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata");
            dataWatcher = Reflection.getMinecraftClass("net.minecraft.network.syncher.DataWatcher");
            packet = Reflection.getMinecraftClass("net.minecraft.network.protocol.Packet");
            getHandle = clazz.getDeclaredMethod("getHandle", new Class[0]);
            getDataWatcher = entityClass.getDeclaredMethod("aj", new Class[0]);
            getDataWatcherB = dataWatcher.getMethod("b", new Class[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

