/*
 * Decompiled with CFR 0.152.
 */
package HologramAPI;

import Utils.Reflection;
import Zombies.GameArena;
import Zombies.Main;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class ItemHologram {
    private static Class<?> craftWorld;
    private static Class<?> entityClass;
    private static Class<?> nmsWorld;
    private static Class<?> armorStand;
    private static Class<?> entityLiving;
    private static Class<?> entity;
    private static Class<?> spawnPacket;
    private static Class<?> removePacket;
    private static Class<?> mountPacket;
    private static Class<?> attachPacket;
    private static Class<?> metaPacket;
    private static Class<?> packet;
    private static Class<?> dataWatcher;
    private static Method getHandle;
    private static Method asNMSCopy;
    private static Method getDataWatcher;
    private static Method getDataWatcherB;
    private static Constructor<?> constructEntityItem;
    private static Constructor<?> constructEntity;
    private static Constructor<?> constructMetadata;
    private static Constructor<?> constructMount;
    private static Constructor<?> constructAttach;
    private static final int versionId;
    private Location location;
    private List<ItemStack> items = new ArrayList<ItemStack>();
    private final List<Integer> ids = new ArrayList<Integer>();
    private final List<Integer> itemIds = new ArrayList<Integer>();
    private final List<Object> entities = new ArrayList<Object>();
    private final List<Object> itemEntities = new ArrayList<Object>();
    private final double offset = 0.23;

    public ItemHologram(Location location) {
        this.location = location;
    }

    public ItemHologram(Location location, ItemStack ... itemStackArray) {
        this.location = location;
        this.addItem(itemStackArray);
    }

    public void addCleanItem(ItemStack ... itemStackArray) {
        this.items.addAll(Arrays.asList(itemStackArray));
    }

    public void addItem(ItemStack ... itemStackArray) {
        this.items.addAll(Arrays.asList(itemStackArray));
        this.update();
    }

    public List<ItemStack> getItems() {
        return this.items;
    }

    public void setItems(List<ItemStack> list) {
        this.items = list;
        this.update();
    }

    public void setCleanItems(ItemStack itemStack) {
        this.items = Arrays.asList(itemStack);
    }

    public void setCleanItems(List<ItemStack> list) {
        this.items = list;
    }

    public void setItems(ItemStack ... itemStackArray) {
        this.items = Arrays.asList(itemStackArray);
        this.update();
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
        this.update();
    }

    public void teleport(Location location) {
        this.setLocation(location);
    }

    public void show(GameArena gameArena) {
        ArrayList<Player> arrayList = new ArrayList<Player>();
        arrayList.addAll(gameArena.getDisplayedPlayers());
        this.show(arrayList);
    }

    public void show(List<Player> list) {
        Location location = this.location.clone().add(0.0, (double)(this.items.size() / 2) * 0.23, 0.0);
        for (ItemStack itemStack : this.items) {
            Object[] objectArray = this.getCreatePacket(location, itemStack);
            assert (objectArray != null);
            this.ids.add((Integer)objectArray[2]);
            this.itemIds.add((Integer)objectArray[4]);
            for (Player player : list) {
                this.sendPacket(player, objectArray[1]);
                this.sendPacket(player, objectArray[0]);
            }
            for (Player player : list) {
                this.sendPacket(player, objectArray[3]);
                this.sendPacket(player, objectArray[5]);
                this.sendPacket(player, objectArray[6]);
            }
            location.subtract(0.0, 0.23, 0.0);
        }
    }

    public void show(Player player) {
        this.show(Collections.singletonList(player));
    }

    public void destroyFrom(Player player) {
        Object object;
        for (int n : this.itemIds) {
            object = this.getRemovePacket(n);
            this.sendPacket(player, object);
        }
        for (int n : this.ids) {
            object = this.getRemovePacket(n);
            this.sendPacket(player, object);
        }
    }

    public void destroyFrom(List<Player> list) {
        Object object;
        for (int n : this.itemIds) {
            object = this.getRemovePacket(n);
            for (Player player : list) {
                if (object == null) continue;
                this.sendPacket(player, object);
            }
        }
        for (int n : this.ids) {
            object = this.getRemovePacket(n);
            for (Player player : list) {
                if (object == null) continue;
                this.sendPacket(player, object);
            }
        }
    }

    public void destroyFromAll(GameArena gameArena) {
        ArrayList<Player> arrayList = new ArrayList<Player>();
        arrayList.addAll(gameArena.getDisplayedPlayers());
        this.destroyFrom(arrayList);
        this.destroy();
    }

    public void spawn() {
        Location location = this.location.clone().add(0.0, (double)(this.items.size() / 2) * 0.23, 0.0).add(0.0, 0.23, 0.0);
        for (ItemStack itemStack : this.items) {
            this.spawnHologram(itemStack, location.subtract(0.0, 0.23, 0.0));
        }
    }

    private void spawnHologram(ItemStack itemStack, Location location) {
        try {
            Object obj = craftWorld.cast(location.getWorld());
            Object obj2 = versionId > 13 ? armorStand.getConstructor(nmsWorld, Double.TYPE, Double.TYPE, Double.TYPE).newInstance(craftWorld.getMethod("getHandle", new Class[0]).invoke(obj, new Object[0]), location.getX(), location.getY(), location.getZ()) : armorStand.getConstructor(nmsWorld).newInstance(craftWorld.getMethod("getHandle", new Class[0]).invoke(obj, new Object[0]));
            this.spawnItem(itemStack, location);
            this.configureHologram(obj2, location);
            craftWorld.getMethod("addEntity", entityClass, CreatureSpawnEvent.SpawnReason.class).invoke(obj, obj2, CreatureSpawnEvent.SpawnReason.CUSTOM);
            this.entities.add(obj2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private Object spawnItem(ItemStack itemStack, Location location) {
        try {
            Object obj = craftWorld.cast(location.getWorld());
            Object object = craftWorld.getMethod("getHandle", new Class[0]).invoke(obj, new Object[0]);
            Object object2 = asNMSCopy.invoke(null, itemStack);
            Object obj2 = constructEntityItem.newInstance(object, location.getX(), location.getY(), location.getZ(), object2);
            this.itemEntities.add(obj2);
            return obj2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void destroy() {
        for (Object object : this.itemEntities) {
            this.removeEntity(object);
        }
        for (Object object : this.entities) {
            this.removeEntity(object);
        }
        this.itemEntities.clear();
        this.entities.clear();
    }

    private void removeEntity(Object ... objectArray) {
        try {
            Object obj = craftWorld.cast(this.location.getWorld());
            for (Object object : objectArray) {
                if (versionId > 13) {
                    Entity entity = (Entity)entityClass.getDeclaredMethod("getBukkitEntity", new Class[0]).invoke(object, new Object[0]);
                    entity.remove();
                    continue;
                }
                nmsWorld.getMethod("removeEntity", entityClass).invoke(craftWorld.getMethod("getHandle", new Class[0]).invoke(obj, new Object[0]), object);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private Object[] getCreatePacket(Location location, ItemStack itemStack) {
        try {
            Object obj;
            Object object = craftWorld.getMethod("getHandle", new Class[0]).invoke(craftWorld.cast(location.getWorld()), new Object[0]);
            Object obj2 = versionId > 13 ? armorStand.getConstructor(nmsWorld, Double.TYPE, Double.TYPE, Double.TYPE).newInstance(object, location.getX(), location.getY(), location.getZ()) : armorStand.getConstructor(nmsWorld).newInstance(object);
            Object object2 = obj2.getClass().getMethod("af", new Class[0]).invoke(obj2, new Object[0]);
            Object obj3 = constructEntityItem.newInstance(object, location.getX(), location.getY(), location.getZ(), asNMSCopy.invoke(null, itemStack));
            Object object3 = obj3.getClass().getMethod("af", new Class[0]).invoke(obj3, new Object[0]);
            Object obj4 = constructMetadata.newInstance((Integer)object3, getDataWatcherB.invoke(getDataWatcher.invoke(obj3, new Object[0]), new Object[0]));
            this.configureHologram(obj2, location);
            if (versionId > 8) {
                obj = constructMount.newInstance(obj2);
                Reflection.setValue(obj, "a", object2);
                Reflection.setValue(obj, "b", new int[]{(Integer)object3});
            } else {
                obj = constructAttach.newInstance(new Object[0]);
                Reflection.setValue(obj, "a", 0);
                Reflection.setValue(obj, "b", Integer.valueOf(String.valueOf(object3)));
                Reflection.setValue(obj, "c", Integer.valueOf(String.valueOf(object2)));
            }
            Object obj5 = metaPacket.getConstructor(Integer.TYPE, List.class).newInstance((Integer)object2, getDataWatcherB.invoke(getDataWatcher.invoke(obj2, new Object[0]), new Object[0]));
            return new Object[]{obj5, spawnPacket.getConstructor(entity).newInstance(obj2), object2, constructEntity.newInstance(obj3, 2), object3, obj4, obj};
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private Object getRemovePacket(int n) {
        try {
            return removePacket.getConstructor(int[].class).newInstance(new Object[]{new int[]{n}});
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void update() {
        try {
            if (!this.entities.isEmpty()) {
                for (int i = 0; i < this.entities.size(); ++i) {
                    Object object = this.entities.get(i);
                    if (i <= this.items.size() - 1) continue;
                    this.removeEntity(object);
                }
                Location location = this.location.clone().add(0.0, (double)(this.items.size() / 2) * 0.23, 0.0);
                for (int i = 0; i < this.items.size(); ++i) {
                    ItemStack itemStack = this.items.get(i);
                    if (i >= this.entities.size()) {
                        this.spawnHologram(itemStack, location);
                    } else {
                        this.configureHologram(this.entities.get(i), location);
                    }
                    location.subtract(0.0, 0.23, 0.0);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void configureHologram(Object object, Location location) {
        Method method = object.getClass().getMethod("a", Double.TYPE, Double.TYPE, Double.TYPE, Float.TYPE, Float.TYPE);
        if (versionId >= 13) {
            Method method2 = object.getClass().getMethod("a", Reflection.getMinecraftClass("net.minecraft.network.chat.IChatBaseComponent"));
            Method method3 = object.getClass().getMethod("n", Boolean.TYPE);
            Class<?> clazz = Reflection.getMinecraftClass("net.minecraft.network.chat.IChatBaseComponent$ChatSerializer");
            Method method4 = object.getClass().getMethod("n", Boolean.TYPE);
            Method method5 = object.getClass().getMethod("e", Boolean.TYPE);
            Method method6 = object.getClass().getMethod("j", Boolean.TYPE);
            Method method7 = object.getClass().getMethod("a", Boolean.TYPE);
            method2.invoke(object, clazz.getMethod("a", String.class).invoke(null, "{\"text\": \"Item\"}"));
            method3.invoke(object, false);
            Entity entity = (Entity)entityClass.getDeclaredMethod("getBukkitEntity", new Class[0]).invoke(object, new Object[0]);
            if (entity instanceof ArmorStand) {
                ArmorStand armorStand = (ArmorStand)entity;
                armorStand.setVisible(false);
                armorStand.setMarker(true);
                armorStand.setSmall(true);
                armorStand.setGravity(true);
            }
            method.invoke(object, location.getX(), location.getY() + 0.25, location.getZ(), Float.valueOf(0.0f), Float.valueOf(0.0f));
        } else {
            if (versionId > 8) {
                Method method8 = object.getClass().getMethod("setInvisible", Boolean.TYPE);
                Method method9 = object.getClass().getMethod("setMarker", Boolean.TYPE);
                Method method10 = object.getClass().getMethod("setSmall", Boolean.TYPE);
                Method method11 = versionId == 9 ? object.getClass().getMethod("setGravity", Boolean.TYPE) : object.getClass().getMethod("setNoGravity", Boolean.TYPE);
                method10.invoke(object, true);
                method9.invoke(object, true);
                method11.invoke(object, true);
                method8.invoke(object, true);
            } else {
                Entity entity = (Entity)entityClass.getDeclaredMethod("getBukkitEntity", new Class[0]).invoke(object, new Object[0]);
                entity.setMetadata("Unknown", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)"Unknown"));
                if (entity instanceof ArmorStand) {
                    ArmorStand armorStand = (ArmorStand)entity;
                    armorStand.setVisible(false);
                    armorStand.setMarker(true);
                    armorStand.setSmall(true);
                    armorStand.setGravity(false);
                }
            }
            method.invoke(object, location.getX(), location.getY(), location.getZ(), Float.valueOf(0.0f), Float.valueOf(0.0f));
        }
    }

    private void sendPacket(Player player, Object object) {
        try {
            if (object == null) {
                return;
            }
            Object object2 = getHandle.invoke((Object)player, new Object[0]);
            Object object3 = Reflection.getValue(object2, "c");
            Method method = Reflection.getMethod(object3, "a", packet);
            assert (method != null);
            method.invoke(object3, object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        versionId = Integer.parseInt(Bukkit.getBukkitVersion().split("-")[0].replace(".", "#").split("#")[1]);
        try {
            Class<?> clazz = Reflection.getCraftClass("entity.CraftPlayer");
            craftWorld = Reflection.getCraftClass("CraftWorld");
            entityClass = Reflection.getMinecraftClass("net.minecraft.world.entity.Entity");
            nmsWorld = Reflection.getMinecraftClass("net.minecraft.world.level.World");
            armorStand = Reflection.getMinecraftClass("net.minecraft.world.entity.decoration.EntityArmorStand");
            entityLiving = Reflection.getMinecraftClass("net.minecraft.world.entity.EntityLiving");
            entity = Reflection.getMinecraftClass("net.minecraft.world.entity.Entity");
            spawnPacket = Reflection.getMinecraftClass("net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity");
            removePacket = Reflection.getMinecraftClass("net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy");
            Class<?> clazz2 = Reflection.getMinecraftClass("net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity");
            Class<?> clazz3 = Reflection.getMinecraftClass("net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata");
            if (versionId > 8) {
                mountPacket = Reflection.getMinecraftClass("net.minecraft.network.protocol.game.PacketPlayOutMount");
            } else {
                attachPacket = Reflection.getNMSClass("PacketPlayOutAttachEntity");
            }
            metaPacket = Reflection.getMinecraftClass("net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata");
            packet = Reflection.getMinecraftClass("net.minecraft.network.protocol.Packet");
            Class<?> clazz4 = Reflection.getMinecraftClass("net.minecraft.world.item.ItemStack");
            Class<?> clazz5 = Reflection.getMinecraftClass("net.minecraft.world.entity.item.EntityItem");
            Class<?> clazz6 = Reflection.getCraftClass("inventory.CraftItemStack");
            dataWatcher = Reflection.getMinecraftClass("net.minecraft.network.syncher.DataWatcher");
            getHandle = clazz.getDeclaredMethod("getHandle", new Class[0]);
            asNMSCopy = clazz6.getDeclaredMethod("asNMSCopy", ItemStack.class);
            getDataWatcher = entityClass.getDeclaredMethod("aj", new Class[0]);
            getDataWatcherB = dataWatcher.getMethod("b", new Class[0]);
            constructEntityItem = clazz5.getConstructor(nmsWorld, Double.TYPE, Double.TYPE, Double.TYPE, clazz4);
            constructEntity = clazz2.getConstructor(entityClass, Integer.TYPE);
            constructMetadata = clazz3.getConstructor(Integer.TYPE, List.class);
            if (versionId > 8) {
                constructMount = mountPacket.getConstructor(entityClass);
            } else {
                constructAttach = attachPacket.getConstructor(new Class[0]);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

