/*
 * Decompiled with CFR 0.152.
 */
package HologramAPI;

import HologramAPI.Hologram;
import Revive.RevivePlayer;
import Utils.ItemStackUtils;
import Utils.LocationUtils;
import Weapons.Weapon;
import Zombies.Main;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class TeamMachineHologram {
    private Hologram hologram;
    private List<Location> locations;
    private Player player;
    private String message;
    private boolean activated;

    public TeamMachineHologram(Player player, String string) {
        this.player = player;
        if (Main.getInstance().getConfiguration().getGameArena(player) == null) {
            return;
        }
        FileConfiguration fileConfiguration = Main.getInstance().getConfiguration().getGameArena(player).getFileConfiguration();
        String[] stringArray = fileConfiguration.getString("TeamMachine.Position." + string + ".Pos1").split(":");
        String[] stringArray2 = fileConfiguration.getString("TeamMachine.Position." + string + ".Pos2").split(":");
        String[] stringArray3 = fileConfiguration.getString("TeamMachine.Position." + string + ".Hologram").split(":");
        Location location = new Location(Bukkit.getWorld((String)stringArray[0]), (double)Integer.valueOf(stringArray[1]).intValue(), (double)Integer.valueOf(stringArray[2]).intValue(), (double)Integer.valueOf(stringArray[3]).intValue());
        Location location2 = new Location(Bukkit.getWorld((String)stringArray2[0]), (double)Integer.valueOf(stringArray2[1]).intValue(), (double)Integer.valueOf(stringArray2[2]).intValue(), (double)Integer.valueOf(stringArray2[3]).intValue());
        Location location3 = new Location(Bukkit.getWorld((String)stringArray3[0]), Double.valueOf(stringArray3[1]).doubleValue(), Double.valueOf(stringArray3[2]).doubleValue(), Double.valueOf(stringArray3[3]).doubleValue());
        this.locations = LocationUtils.getBlocks(location, location2);
        this.hologram = new Hologram(location3);
        this.message = Main.getInstance().getConfiguration().getMessage("TeamMachine.HologramHeader");
        this.hologram.setCleanLines(this.message, Main.getInstance().getConfiguration().getMessage("TeamMachine.InactiveHologramFooter"));
        this.hologram.show(player);
    }

    public void restore(Player player) {
        this.hologram.show(player);
    }

    public List<Location> getLocations() {
        return this.locations;
    }

    public Player getPlayer() {
        return this.player;
    }

    public void setActivated() {
        this.activated = true;
        String string = Main.getInstance().getConfiguration().getMessage("TeamMachine.ActiveHologramFooter");
        this.hologram.destroyFrom(this.player);
        this.hologram.setCleanLines(this.message, string);
        this.hologram.show(this.player);
    }

    public boolean open(Player player) {
        ArrayList<String> arrayList;
        List<String> list;
        if (Main.getInstance().getConfiguration().getGameArena(player) == null) {
            return false;
        }
        if (!this.isActivated()) {
            player.sendMessage(Main.getInstance().getConfiguration().getMessage("TeamMachine.RequiresPower"));
            player.playSound(player.getEyeLocation(), Sound.valueOf((String)Main.getInstance().getConfiguration().getSound("NotEnoughGold")), 1.0f, Main.getInstance().getConfiguration().convertDouble("SoundPitch.NotEnoughGold"));
            return false;
        }
        int n = Main.getInstance().getConfiguration().getGameArena(player).getGold(player);
        int n2 = Main.getInstance().getConfiguration().getInteger("AmmoSupply");
        int n3 = Main.getInstance().getConfiguration().getInteger("FullRevive");
        int n4 = Main.getInstance().getConfiguration().getInteger("DragonsWrath");
        Inventory inventory = Bukkit.createInventory(null, (int)27, (String)Main.getInstance().getConfiguration().getMessage("TeamMachine.InventoryName"));
        if (n >= n2) {
            list = Main.getInstance().getConfiguration().getMessageList("TeamMachine.AmmoSupply.Purchaseable.Lores");
            arrayList = new ArrayList<String>();
            for (String string : list) {
                arrayList.add(string.replace("%ammoSupplyGoldValue%", String.valueOf(n2)));
            }
            inventory.setItem(11, ItemStackUtils.getItem(Material.ARROW, 1, 0, Main.getInstance().getConfiguration().getMessage("TeamMachine.AmmoSupply.Purchaseable.DisplayName"), arrayList));
        } else {
            list = Main.getInstance().getConfiguration().getMessageList("TeamMachine.AmmoSupply.NotPurchaseable.Lores");
            arrayList = new ArrayList();
            for (String string : list) {
                arrayList.add(string.replace("%ammoSupplyGoldValue%", String.valueOf(n2)));
            }
            inventory.setItem(11, ItemStackUtils.getItem(Material.ARROW, 1, 0, Main.getInstance().getConfiguration().getMessage("TeamMachine.AmmoSupply.NotPurchaseable.DisplayName"), arrayList));
        }
        if (n >= n3) {
            list = Main.getInstance().getConfiguration().getMessageList("TeamMachine.FullRevive.Purchaseable.Lores");
            arrayList = new ArrayList();
            for (String string : list) {
                arrayList.add(string.replace("%fullReviveGoldValue%", String.valueOf(n3)));
            }
            inventory.setItem(13, ItemStackUtils.getItem(Material.GOLDEN_APPLE, 1, 0, Main.getInstance().getConfiguration().getMessage("TeamMachine.FullRevive.Purchaseable.DisplayName"), arrayList));
        } else {
            list = Main.getInstance().getConfiguration().getMessageList("TeamMachine.FullRevive.NotPurchaseable.Lores");
            arrayList = new ArrayList();
            for (String string : list) {
                arrayList.add(string.replace("%fullReviveGoldValue%", String.valueOf(n3)));
            }
            inventory.setItem(13, ItemStackUtils.getItem(Material.GOLDEN_APPLE, 1, 0, Main.getInstance().getConfiguration().getMessage("TeamMachine.FullRevive.NotPurchaseable.DisplayName"), arrayList));
        }
        if (n >= n4) {
            list = Main.getInstance().getConfiguration().getMessageList("TeamMachine.DragonsWrath.Purchaseable.Lores");
            arrayList = new ArrayList();
            for (String string : list) {
                arrayList.add(string.replace("%dragonsWrathGoldValue%", String.valueOf(n4)));
            }
            inventory.setItem(15, ItemStackUtils.getItem(Material.DRAGON_EGG, 1, 0, Main.getInstance().getConfiguration().getMessage("TeamMachine.DragonsWrath.Purchaseable.DisplayName"), arrayList));
        } else {
            list = Main.getInstance().getConfiguration().getMessageList("TeamMachine.DragonsWrath.NotPurchaseable.Lores");
            arrayList = new ArrayList();
            for (String string : list) {
                arrayList.add(string.replace("%dragonsWrathGoldValue%", String.valueOf(n4)));
            }
            inventory.setItem(15, ItemStackUtils.getItem(Material.DRAGON_EGG, 1, 0, Main.getInstance().getConfiguration().getMessage("TeamMachine.DragonsWrath.NotPurchaseable.DisplayName"), arrayList));
        }
        inventory.setItem(22, ItemStackUtils.getItem(Material.BARRIER, 1, 0, Main.getInstance().getConfiguration().getMessage("TeamMachine.CloseItem.DisplayName"), Main.getInstance().getConfiguration().getMessageList("TeamMachine.CloseItem.Lores")));
        player.openInventory(inventory);
        return true;
    }

    public boolean purchase(final Player player, int n) {
        if (Main.getInstance().getConfiguration().getGameArena(player) == null) {
            return false;
        }
        if (!this.isActivated()) {
            player.sendMessage(Main.getInstance().getConfiguration().getMessage("TeamMachine.RequiresPower"));
            player.playSound(player.getEyeLocation(), Sound.valueOf((String)Main.getInstance().getConfiguration().getSound("NotEnoughGold")), 1.0f, Main.getInstance().getConfiguration().convertDouble("SoundPitch.NotEnoughGold"));
            return false;
        }
        int n2 = Main.getInstance().getConfiguration().getGameArena(player).getGold(player);
        int n3 = Main.getInstance().getConfiguration().getInteger("AmmoSupply");
        int n4 = Main.getInstance().getConfiguration().getInteger("FullRevive");
        int n5 = Main.getInstance().getConfiguration().getInteger("DragonsWrath");
        switch (n) {
            case 11: {
                if (n2 >= n3) {
                    Main.getInstance().getConfiguration().getGameArena(player).removeGold(player, n3);
                    for (Player player2 : Main.getInstance().getConfiguration().getGameArena(player).getPlayers()) {
                        for (Integer n6 : Main.getInstance().getWeaponHandler().getWeaponSlots(player2)) {
                            Weapon weapon = Weapon.getWeapon(player2.getInventory().getItem(n6.intValue()));
                            if (weapon == null) continue;
                            Main.getInstance().getWeaponHandler().loadWeaponAmmo(player2, weapon);
                        }
                    }
                    Main.getInstance().getConfiguration().getGameArena(player).sendMessage(Main.getInstance().getConfiguration().getMessage("TeamMachine.Activate").replace("%displayName%", player.getDisplayName()).replace("%playerName%", player.getName()).replace("%purchasedType%", ChatColor.stripColor((String)Main.getInstance().getConfiguration().getMessage("TeamMachine.AmmoSupply.Purchaseable.DisplayName"))));
                    player.playSound(player.getEyeLocation(), Sound.valueOf((String)Main.getInstance().getConfiguration().getSound("TeamMachinePurchase")), 1.0f, Main.getInstance().getConfiguration().convertDouble("SoundPitch.TeamMachinePurchase"));
                    player.closeInventory();
                    break;
                }
                player.sendMessage(Main.getInstance().getConfiguration().getMessage("NotEnoughGold"));
                player.playSound(player.getEyeLocation(), Sound.valueOf((String)Main.getInstance().getConfiguration().getSound("NotEnoughGold")), 1.0f, Main.getInstance().getConfiguration().convertDouble("SoundPitch.NotEnoughGold"));
                break;
            }
            case 13: {
                if (n2 >= n4) {
                    Main.getInstance().getConfiguration().getGameArena(player).removeGold(player, n4);
                    for (RevivePlayer revivePlayer : Main.getInstance().getConfiguration().getGameArena(player).getRevivePlayers().values()) {
                        revivePlayer.resetStatus();
                    }
                    for (Player player2 : Main.getInstance().getConfiguration().getGameArena(player).getAlivePlayers()) {
                        if (!Main.getInstance().getConfiguration().getGameArena(player).isDead(player2) && !Main.getInstance().getConfiguration().getGameArena(player).isRevivedPlayer(player2)) continue;
                        Main.getInstance().getConfiguration().getGameArena(player).setAlive(player2);
                        player2.teleport(Main.getInstance().getConfiguration().getGameArena(player).getSpawnLocation());
                    }
                    Main.getInstance().getConfiguration().getGameArena(player).sendMessage(Main.getInstance().getConfiguration().getMessage("TeamMachine.Activate").replace("%displayName%", player.getDisplayName()).replace("%playerName%", player.getName()).replace("%purchasedType%", ChatColor.stripColor((String)Main.getInstance().getConfiguration().getMessage("TeamMachine.FullRevive.Purchaseable.DisplayName"))));
                    player.playSound(player.getEyeLocation(), Sound.valueOf((String)Main.getInstance().getConfiguration().getSound("TeamMachinePurchase")), 1.0f, Main.getInstance().getConfiguration().convertDouble("SoundPitch.TeamMachinePurchase"));
                    player.closeInventory();
                    break;
                }
                player.sendMessage(Main.getInstance().getConfiguration().getMessage("NotEnoughGold"));
                player.playSound(player.getEyeLocation(), Sound.valueOf((String)Main.getInstance().getConfiguration().getSound("NotEnoughGold")), 1.0f, Main.getInstance().getConfiguration().convertDouble("SoundPitch.NotEnoughGold"));
                break;
            }
            case 15: {
                if (n2 >= n5) {
                    Main.getInstance().getConfiguration().getGameArena(player).removeGold(player, n5);
                    new BukkitRunnable(){

                        public void run() {
                            if (Main.getInstance().getConfiguration().getGameArena(player).isAlive(player)) {
                                int n = 0;
                                for (Entity entity : player.getWorld().getNearbyEntities(player.getLocation(), 15.0, 15.0, 15.0)) {
                                    if (!entity.hasMetadata("Zombies") || entity.hasMetadata("Bombie") || entity.hasMetadata("Inferno") || entity.hasMetadata("TheBroodmother") || entity.hasMetadata("KingSlime") || entity.hasMetadata("KingWither") || entity.hasMetadata("Herobrine") || entity.hasMetadata("SantaClaus")) continue;
                                    ++n;
                                    player.getWorld().strikeLightningEffect(entity.getLocation());
                                    ((Creature)entity).damage(500.0);
                                }
                                player.sendMessage(Main.getInstance().getConfiguration().getMessage("TeamMachine.DragonsWrath.KillMessage").replace("%killedEnemies%", String.valueOf(n)));
                            }
                        }
                    }.runTaskLater((Plugin)Main.getInstance(), 80L);
                    Main.getInstance().getConfiguration().getGameArena(player).sendMessage(Main.getInstance().getConfiguration().getMessage("TeamMachine.Activate").replace("%displayName%", player.getDisplayName()).replace("%playerName%", player.getName()).replace("%purchasedType%", ChatColor.stripColor((String)Main.getInstance().getConfiguration().getMessage("TeamMachine.DragonsWrath.Purchaseable.DisplayName"))));
                    player.playSound(player.getEyeLocation(), Sound.valueOf((String)Main.getInstance().getConfiguration().getSound("TeamMachinePurchase")), 1.0f, Main.getInstance().getConfiguration().convertDouble("SoundPitch.TeamMachinePurchase"));
                    player.closeInventory();
                    break;
                }
                player.sendMessage(Main.getInstance().getConfiguration().getMessage("NotEnoughGold"));
                player.playSound(player.getEyeLocation(), Sound.valueOf((String)Main.getInstance().getConfiguration().getSound("NotEnoughGold")), 1.0f, Main.getInstance().getConfiguration().convertDouble("SoundPitch.NotEnoughGold"));
                break;
            }
            case 22: {
                player.closeInventory();
            }
        }
        return true;
    }

    public boolean isActivated() {
        return this.activated;
    }

    public Hologram getHologram() {
        return this.hologram;
    }
}

