/*
 * Decompiled with CFR 0.152.
 */
package MySQL;

import MySQL.StatsField;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import java.util.UUID;

public class PlayerStats {
    private String uuid;
    private String mapName;
    private long fastestWinTime;
    private int survivedRounds;
    private int wins;
    private int looses;
    private int kills;
    private int gamesPlayed;
    private long systemTime = System.currentTimeMillis();
    private static SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss");

    public PlayerStats(String string) {
        this.mapName = string;
        this.fastestWinTime = 0L;
        this.survivedRounds = 0;
        this.wins = 0;
        this.looses = 0;
        this.kills = 0;
        this.gamesPlayed = 0;
    }

    public PlayerStats(String string, String string2) {
        this.uuid = string;
        String[] stringArray = string2.split(":");
        if (stringArray.length >= 1) {
            this.mapName = stringArray[0];
        }
        if (stringArray.length >= 2) {
            this.fastestWinTime = Long.parseLong(stringArray[1]);
        }
        if (stringArray.length >= 3) {
            this.survivedRounds = Integer.parseInt(stringArray[2]);
        }
        if (stringArray.length >= 4) {
            this.wins = Integer.parseInt(stringArray[3]);
        }
        if (stringArray.length >= 5) {
            this.looses = Integer.parseInt(stringArray[4]);
        }
        if (stringArray.length >= 6) {
            this.kills = Integer.parseInt(stringArray[5]);
        }
        if (stringArray.length >= 7) {
            this.gamesPlayed = Integer.parseInt(stringArray[6]);
        }
    }

    public PlayerStats(String string, String string2, long l, int n, int n2, int n3, int n4, int n5) {
        this.uuid = string;
        this.mapName = string2;
        this.fastestWinTime = l;
        this.survivedRounds = n;
        this.wins = n2;
        this.looses = n3;
        this.kills = n4;
        this.gamesPlayed = n5;
    }

    public long getSystemTime() {
        return this.systemTime;
    }

    public void setMapName(String string) {
        this.mapName = string;
    }

    public void setKills(int n) {
        this.kills = n;
    }

    public void setGamesPlayed(int n) {
        this.gamesPlayed = n;
    }

    public void setLooses(int n) {
        this.looses = n;
    }

    public void setWins(int n) {
        this.wins = n;
    }

    public void setFastestWinTime(long l) {
        this.fastestWinTime = l;
    }

    public void setSurvivedRounds(int n) {
        this.survivedRounds = n;
    }

    public String getUniqueId() {
        if (this.uuid == null) {
            return UUID.randomUUID().toString();
        }
        return this.uuid;
    }

    public int getKills() {
        return this.kills;
    }

    public int getLooses() {
        return this.looses;
    }

    public int getWins() {
        return this.wins;
    }

    public long getFastestWinTime() {
        return this.fastestWinTime;
    }

    public int getSurvivedRounds() {
        return this.survivedRounds;
    }

    public int getGamesPlayed() {
        return this.gamesPlayed;
    }

    public String getMapName() {
        return this.mapName;
    }

    public String getDatabaseMessage() {
        return this.mapName + ":" + this.fastestWinTime + ":" + this.survivedRounds + ":" + this.wins + ":" + this.looses + ":" + this.kills + ":" + this.gamesPlayed;
    }

    public Object getStats(StatsField statsField) {
        Object object = null;
        switch (statsField) {
            case FASTEST_WIN_TIME: {
                object = format.format(this.getFastestWinTime());
                break;
            }
            case SURVIVED_ROUNDS: {
                object = this.getSurvivedRounds();
                break;
            }
            case WINS: {
                object = this.getWins();
                break;
            }
            case LOOSES: {
                object = this.getLooses();
                break;
            }
            case KILLS: {
                object = this.getKills();
                break;
            }
            case GAMES_PLAYED: {
                object = this.getGamesPlayed();
            }
        }
        return object;
    }

    static {
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

