/*
 * Decompiled with CFR 0.152.
 */
package Utils;

import ActionBarAPI.ActionBar;
import Utils.GameEntity;
import Utils.Reflection;
import Zombies.Configuration;
import Zombies.GameArena;
import Zombies.Main;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Endermite;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Spider;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class EntityUtils {
    private static Class<?> entityInsentient;
    private static Method getEntityHandle;
    private static Method getNavigation;
    private static Method aLocation;
    private static Method aEntity;
    private static Method a;
    private static Method getAttributeInstance;
    private static Method setValue;
    private static Object movementSpeed;
    private static final Map<Entity, GameEntity> gameEntities;
    private static final Map<GameArena, List<Entity>> arenaEntities;
    private static final int versionId;

    public static void initialize() {
        try {
            Class<?> clazz = Reflection.getCraftClass("entity.CraftEntity");
            Class<?> clazz2 = Reflection.getMinecraftClass("net.minecraft.world.entity.EntityLiving");
            Class<?> clazz3 = Reflection.getMinecraftClass("net.minecraft.world.level.pathfinder.PathEntity");
            Class<?> clazz4 = Reflection.getMinecraftClass("net.minecraft.world.entity.ai.attributes.GenericAttributes");
            entityInsentient = Reflection.getMinecraftClass("net.minecraft.world.entity.EntityInsentient");
            Class<?> clazz5 = Reflection.getMinecraftClass("net.minecraft.world.entity.ai.navigation.NavigationAbstract");
            Class<?> clazz6 = null;
            if (versionId <= 15) {
                clazz6 = Reflection.getNMSClass("AttributeInstance");
            }
            Class<?> clazz7 = null;
            if (versionId >= 16) {
                clazz7 = Reflection.getMinecraftClass("net.minecraft.world.entity.ai.attributes.AttributeModifiable");
            }
            getEntityHandle = clazz.getDeclaredMethod("getHandle", new Class[0]);
            getNavigation = entityInsentient.getDeclaredMethod("J", new Class[0]);
            aLocation = versionId >= 14 ? clazz5.getDeclaredMethod("a", Double.TYPE, Double.TYPE, Double.TYPE, Integer.TYPE) : clazz5.getDeclaredMethod("a", Double.TYPE, Double.TYPE, Double.TYPE);
            aEntity = clazz5.getDeclaredMethod("a", clazz3, Double.TYPE);
            a = clazz5.getDeclaredMethod("a", Double.TYPE);
            if (versionId >= 16) {
                Class<?> clazz8 = Reflection.getMinecraftClass("net.minecraft.world.entity.ai.attributes.AttributeBase");
                getAttributeInstance = clazz2.getDeclaredMethod("a", clazz8);
            } else {
                Class<?> clazz9 = Reflection.getNMSClass("IAttribute");
                getAttributeInstance = clazz2.getDeclaredMethod("getAttributeInstance", clazz9);
            }
            setValue = versionId >= 16 ? clazz7.getDeclaredMethod("a", Double.TYPE) : clazz6.getDeclaredMethod("setValue", Double.TYPE);
            movementSpeed = Reflection.getField(clazz4.getDeclaredField("d")).get(null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        new BukkitRunnable(){

            public void run() {
                for (Entity entity : gameEntities.keySet()) {
                    if (!(entity instanceof Spider)) continue;
                    entity.setVelocity(entity.getVelocity().setY(-0.5));
                }
            }
        }.runTaskTimer((Plugin)Main.getInstance(), 0L, 0L);
        new BukkitRunnable(){

            public void run() {
                for (Entity entity : gameEntities.keySet()) {
                    GameArena gameArena;
                    if (!(entity instanceof Endermite) || (gameArena = Main.getInstance().getConfiguration().getGameArena(entity)) == null) continue;
                    double d = Double.MAX_VALUE;
                    Player player = null;
                    for (Player player2 : gameArena.getPlayers()) {
                        double d2;
                        if (!gameArena.isAlive(player2) || !player2.getWorld().getName().equals(entity.getWorld().getName()) || !((d2 = player2.getLocation().distance(entity.getLocation())) < d)) continue;
                        d = d2;
                        player = player2;
                    }
                    if (!(d > 2.5) || player == null) continue;
                    entity.teleport(player, PlayerTeleportEvent.TeleportCause.PLUGIN);
                }
            }
        }.runTaskTimer((Plugin)Main.getInstance(), 200L, 200L);
        new BukkitRunnable(){
            final ActionBar actionBar = new ActionBar();

            public void run() {
                if (Main.getInstance().getConfiguration() != null && Main.getInstance().getConfiguration().getArenaListIncluded() != null) {
                    for (GameArena gameArena : Main.getInstance().getConfiguration().getArenaListIncluded()) {
                        if (gameArena == null || gameArena.hasStopped() || !gameArena.isEnemyDetectorEnabled()) continue;
                        for (Player player : gameArena.getAlivePlayers()) {
                            int n;
                            Entity entity = null;
                            if (arenaEntities.containsKey(gameArena)) {
                                for (Entity entity2 : (List)arenaEntities.get(gameArena)) {
                                    if (entity == null) {
                                        if (!entity2.getWorld().getName().equals(player.getWorld().getName())) continue;
                                        entity = entity2;
                                        continue;
                                    }
                                    if (!entity2.getWorld().getName().equals(player.getWorld().getName()) || !entity.getWorld().getName().equals(player.getWorld().getName()) || !(entity2.getLocation().distance(player.getLocation()) < entity.getLocation().distance(player.getLocation()))) continue;
                                    entity = entity2;
                                }
                                if (entity != null) {
                                    player.setCompassTarget(entity.getLocation());
                                }
                            }
                            if ((n = player.getInventory().getHeldItemSlot()) != gameArena.getEnemyDetectorSlot()) continue;
                            player.getCompassTarget();
                            int n2 = player.getCompassTarget().getBlockX();
                            int n3 = player.getCompassTarget().getBlockY();
                            int n4 = player.getCompassTarget().getBlockZ();
                            int n5 = player.getLocation().getBlockX();
                            int n6 = player.getLocation().getBlockY();
                            int n7 = player.getLocation().getBlockZ();
                            int n8 = n2 > n5 ? n2 - n5 : n5 - n2;
                            int n9 = n3 > n6 ? n3 - n6 : n6 - n3;
                            int n10 = n4 > n7 ? n4 - n7 : n7 - n4;
                            this.actionBar.setMessage(Main.getInstance().getConfiguration().getMessage("EnemyDetectorActionBar").replace("%xCoordinateDifference%", String.valueOf(n8)).replace("%yCoordinateDifference%", String.valueOf(n9)).replace("%zCoordinateDifference%", String.valueOf(n10)));
                            this.actionBar.send(player);
                        }
                    }
                }
            }
        }.runTaskTimer((Plugin)Main.getInstance(), 100L, 20L);
        new BukkitRunnable(){

            public void run() {
                Object object;
                ArrayList<GameEntity> arrayList = new ArrayList<GameEntity>();
                for (Map.Entry object2 : gameEntities.entrySet()) {
                    Location location;
                    object = (Entity)object2.getKey();
                    GameEntity gameEntity = (GameEntity)object2.getValue();
                    if (!object.isValid()) {
                        arrayList.add(gameEntity);
                        continue;
                    }
                    double d = gameEntity.getEntitySpeed();
                    Player player = gameEntity.getTargetPlayer();
                    if (player == null) {
                        player = EntityUtils.getNearbyPlayer((Entity)object);
                        gameEntity.setTargetPlayer(player);
                    }
                    if ((location = gameEntity.getLocation()) == null) continue;
                    if (object instanceof Creature && player != null) {
                        ((Creature)object).setTarget((LivingEntity)player);
                    }
                    try {
                        Object object3 = gameEntity.getEntityNavigation();
                        Object object4 = versionId >= 14 ? aLocation.invoke(object3, location.getX(), location.getY(), location.getZ(), 0) : aLocation.invoke(object3, location.getX(), location.getY(), location.getZ());
                        if (object4 != null) {
                            aEntity.invoke(object3, object4, 1.0);
                        }
                        a.invoke(object3, 1.0);
                        if (!gameEntity.applyAttributes()) continue;
                        Object object5 = gameEntity.getEntityInsentient();
                        setValue.invoke(getAttributeInstance.invoke(object5, movementSpeed), d);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                for (GameEntity gameEntity : arrayList) {
                    gameEntities.remove(gameEntity.getEntity());
                    if (!arenaEntities.containsKey(gameEntity.getGameArena())) continue;
                    object = (List)arenaEntities.get(gameEntity.getGameArena());
                    object.remove(gameEntity.getEntity());
                    if (object.isEmpty()) {
                        arenaEntities.remove(gameEntity.getGameArena());
                        continue;
                    }
                    arenaEntities.put(gameEntity.getGameArena(), object);
                }
            }
        }.runTaskTimer((Plugin)Main.getInstance(), 50L, 50L);
    }

    public static void teleport(final Entity entity, final Location location) {
        new BukkitRunnable(){

            public void run() {
                entity.teleport(location, PlayerTeleportEvent.TeleportCause.PLUGIN);
            }
        }.runTaskLater((Plugin)Main.getInstance(), (long)Main.getInstance().getConfiguration().getInteger("DelayedTeleportTicks").intValue());
    }

    public static void spawnEndermites(final GameArena gameArena, final Entity entity) {
        new BukkitRunnable(){
            double oldLive = -1.0;
            final int max = 5;
            int current = 0;

            public void run() {
                boolean bl;
                if (this.oldLive == -1.0 && entity instanceof Damageable) {
                    this.oldLive = ((Damageable)entity).getHealth();
                }
                if (entity.isDead() || this.oldLive == -1.0 || this.current >= 5) {
                    this.cancel();
                    return;
                }
                boolean bl2 = bl = ((Damageable)entity).getHealth() < this.oldLive;
                if (bl) {
                    this.oldLive = ((Damageable)entity).getHealth();
                    ++this.current;
                    Endermite endermite = (Endermite)entity.getLocation().getWorld().spawn(entity.getLocation(), Endermite.class);
                    double d = gameArena.getFileConfiguration().getDouble("Health.Endermite");
                    if (d <= 0.0) {
                        d = 8.0;
                    }
                    endermite.setMaxHealth(d);
                    endermite.setHealth(d);
                    endermite.getEquipment().clear();
                    endermite.setRemoveWhenFarAway(false);
                    endermite.setMetadata("Arena", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)gameArena.getName()));
                    endermite.setMetadata("Zombies", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)gameArena.getFileConfiguration().getDouble("Gold.Endermite")));
                    endermite.setMetadata("ZombieName", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)Configuration.translateTextCodes(gameArena.getFileConfiguration().getString("Name.Endermite"))));
                    endermite.setMetadata("OtherSpawnReason", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)gameArena.getName()));
                    Player player = EntityUtils.getNearbyPlayer((Entity)endermite);
                    endermite.setTarget((LivingEntity)player);
                    EntityUtils.walk(gameArena, (Entity)endermite, player, gameArena.getFileConfiguration().getDouble("Round." + gameArena.getRound() + ".Speed.Endermite"));
                    EntityUtils.teleport((Entity)endermite, entity.getLocation());
                }
            }
        }.runTaskTimer((Plugin)Main.getInstance(), 40L, 40L);
    }

    public static void walk(Entity entity, Player player) {
        if (player != null && gameEntities.containsKey(entity)) {
            gameEntities.get(entity).setTargetPlayer(player);
        }
    }

    public static void walk(GameArena gameArena, Entity entity, Player player, double d) {
        if (player != null) {
            if (gameEntities.containsKey(entity)) {
                gameEntities.get(entity).setTargetPlayer(player).setEntitySpeed(d);
            } else {
                try {
                    Object object = getEntityHandle.invoke((Object)entity, new Object[0]);
                    Object obj = entityInsentient.cast(object);
                    Object object2 = getNavigation.invoke(obj, new Object[0]);
                    gameEntities.put(entity, new GameEntity(entity, object2, obj, gameArena).setTargetPlayer(player).setEntitySpeed(d).setEntityRange(Double.MAX_VALUE));
                    List<Entity> list = new ArrayList<Entity>();
                    if (arenaEntities.containsKey(gameArena)) {
                        list = arenaEntities.get(gameArena);
                    }
                    list.add(entity);
                    arenaEntities.put(gameArena, list);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    public static Player changeTarget(Entity entity, Player player) {
        GameArena gameArena = Main.getInstance().getConfiguration().getGameArena(player);
        if (gameArena == null) {
            return null;
        }
        if (!gameArena.isRevivedPlayer(player) && gameArena.isAlive(player) && gameEntities.containsKey(entity)) {
            gameEntities.get(entity).setTargetPlayer(player);
            return player;
        }
        return null;
    }

    public static Player getNearbyPlayer(Entity entity) {
        Player player = null;
        GameArena gameArena = Main.getInstance().getConfiguration().getGameArena(entity);
        if (gameArena != null) {
            for (Player player2 : gameArena.getPlayers()) {
                GameArena gameArena2 = Main.getInstance().getConfiguration().getGameArena(player2);
                if (gameArena2 == null || !gameArena2.isAlive(player2) || gameArena2.isRevivedPlayer(player2)) continue;
                if (player == null) {
                    player = player2;
                    continue;
                }
                if (!(player2.getLocation().distance(entity.getLocation()) < player.getLocation().distance(entity.getLocation()))) continue;
                player = player2;
            }
        }
        return player;
    }

    public static boolean isNearbyEnemy(Location location, int n) {
        Collection collection = location.getWorld().getNearbyEntities(location, (double)n, (double)n, (double)n);
        boolean bl = false;
        for (Entity entity : collection) {
            if (!entity.hasMetadata("Zombies")) continue;
            bl = true;
        }
        return bl;
    }

    static {
        gameEntities = new HashMap<Entity, GameEntity>();
        arenaEntities = new HashMap<GameArena, List<Entity>>();
        versionId = Integer.parseInt(Bukkit.getBukkitVersion().split("-")[0].replace(".", "#").split("#")[1]);
    }
}

