/*
 * Decompiled with CFR 0.152.
 */
package Utils;

import Utils.Reflection;
import Zombies.Configuration;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class ItemStackUtils {
    public static Method asNMSCopy;
    public static Method asBukkitCopy;
    public static Method getTag;
    public static Method setTag;
    public static Method getString;
    public static Method mojangsonParse;
    public static Class<?> craftItemStack;
    public static Class<?> nmsItemStack;
    public static Class<?> nbtTagCompound;
    public static Class<?> mojangsonParser;
    public static int versionId;

    public static void loadUtils() {
        try {
            nbtTagCompound = Reflection.getMinecraftClass("net.minecraft.nbt.NBTTagCompound");
            mojangsonParser = Reflection.getMinecraftClass("net.minecraft.nbt.MojangsonParser");
            nmsItemStack = Reflection.getMinecraftClass("net.minecraft.world.item.ItemStack");
            craftItemStack = Reflection.getCraftClass("inventory.CraftItemStack");
            mojangsonParse = mojangsonParser.getDeclaredMethod("a", String.class);
            asNMSCopy = craftItemStack.getDeclaredMethod("asNMSCopy", ItemStack.class);
            asBukkitCopy = craftItemStack.getDeclaredMethod("asBukkitCopy", nmsItemStack);
            getTag = nmsItemStack.getDeclaredMethod("v", new Class[0]);
            setTag = nmsItemStack.getDeclaredMethod("c", nbtTagCompound);
            getString = nbtTagCompound.getDeclaredMethod("l", String.class);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static String getNBTString(ItemStack itemStack, String string) {
        if (itemStack == null) {
            return null;
        }
        if (itemStack.getType() == Material.AIR) {
            return null;
        }
        String string2 = null;
        try {
            String string3;
            Object object = asNMSCopy.invoke(null, itemStack);
            Object object2 = getTag.invoke(object, new Object[0]);
            if (object2 != null && !(string3 = (String)getString.invoke(object2, string)).equals("")) {
                string2 = string3;
            }
        }
        catch (Exception exception) {
            return null;
        }
        return string2;
    }

    public static String getNBTTags(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        if (itemStack.getType() == Material.AIR) {
            return null;
        }
        String string = "";
        try {
            Object object = asNMSCopy.invoke(null, itemStack);
            Object object2 = getTag.invoke(object, new Object[0]);
            if (object2 != null) {
                string = object2.toString();
            }
        }
        catch (Exception exception) {
            return null;
        }
        return string;
    }

    public static ItemStack applyNBTTags(ItemStack itemStack, String string) {
        if (string == null) {
            return itemStack;
        }
        if (string.equals("")) {
            return itemStack;
        }
        ItemStack itemStack2 = itemStack;
        try {
            Object object = asNMSCopy.invoke(null, itemStack);
            Object object2 = mojangsonParse.invoke(null, string);
            setTag.invoke(object, object2);
            itemStack2 = (ItemStack)asBukkitCopy.invoke(null, object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return itemStack2;
    }

    public static ItemStack getNBTItem(Material material, int n, int n2, String string, String string2, List<String> list) {
        ItemStack itemStack = ItemStackUtils.getItem(material, n, n2, string, new String[0]);
        ItemMeta itemMeta = (itemStack = ItemStackUtils.applyNBTTags(itemStack, string2)).getItemMeta();
        if (itemMeta != null) {
            if (string != null) {
                itemMeta.setDisplayName(string);
            }
            itemMeta.setLore(list);
        }
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    public static ItemStack applyCustomModelData(ItemStack itemStack, Integer n) {
        ItemStack itemStack2 = itemStack.clone();
        ItemMeta itemMeta = itemStack2.getItemMeta();
        itemMeta.setCustomModelData(n);
        itemStack2.setItemMeta(itemMeta);
        return itemStack2;
    }

    public static ItemStack getNBTItem(Material material, int n, int n2, String string, String string2, String ... stringArray) {
        return ItemStackUtils.getNBTItem(material, n, n2, string, string2, Arrays.asList(stringArray));
    }

    public static ItemStack getItem(Material material, int n, int n2, String string, List<String> list) {
        ItemStack itemStack = new ItemStack(material, n, (short)n2);
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (string != null) {
            itemMeta.setDisplayName(string);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : list) {
            arrayList.add(Configuration.translateTextCodes(string2));
        }
        itemMeta.setLore(arrayList);
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    public static ItemStack getBookItem(String string, String string2, String string3, List<String> list, List<String> list2) {
        ItemStack itemStack = new ItemStack(Material.WRITTEN_BOOK, 1, 0);
        BookMeta bookMeta = (BookMeta)itemStack.getItemMeta();
        bookMeta.setLore(list);
        bookMeta.setDisplayName(string);
        bookMeta.setAuthor(string3);
        bookMeta.setTitle(string2);
        bookMeta.addPage(list2.toArray(new String[list2.size()]));
        itemStack.setItemMeta((ItemMeta)bookMeta);
        return itemStack;
    }

    public static ItemStack getItem(Material material, int n, int n2, String string, String ... stringArray) {
        return ItemStackUtils.getItem(material, n, n2, string, Arrays.asList(stringArray));
    }

    public static ItemStack addItemFlags(ItemStack itemStack, ItemFlag ... itemFlagArray) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta != null && itemFlagArray != null) {
            itemMeta.addItemFlags(itemFlagArray);
        }
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    public static ItemStack enchant(ItemStack itemStack, Enchantment enchantment, int n) {
        itemStack.addUnsafeEnchantment(enchantment, n);
        return itemStack;
    }

    public static ItemStack getTexturedItem(int n, String string, String string2) {
        ItemStack itemStack = ItemStackUtils.getItem(versionId >= 13 ? Material.LEGACY_SKULL_ITEM : Material.getMaterial((String)"SKULL_ITEM"), n, 3, string, new String[0]);
        if (string2.length() <= 16) {
            SkullMeta skullMeta = (SkullMeta)itemStack.getItemMeta();
            skullMeta.setOwner(ChatColor.stripColor((String)string));
            itemStack.setItemMeta((ItemMeta)skullMeta);
        } else {
            ItemMeta itemMeta = itemStack.getItemMeta();
            itemStack = ItemStackUtils.addTexture(itemStack, itemMeta, string2);
            itemStack.setItemMeta(itemMeta);
        }
        return itemStack;
    }

    public static ItemStack addTexture(ItemStack itemStack, ItemMeta itemMeta, String string) {
        GameProfile gameProfile = new GameProfile(UUID.randomUUID(), null);
        gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", string));
        try {
            Field field = itemMeta.getClass().getDeclaredField("profile");
            field.setAccessible(true);
            field.set(itemMeta, gameProfile);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return itemStack;
    }

    public static ItemStack colorize(ItemStack itemStack, Color color) {
        if (itemStack.getItemMeta() instanceof LeatherArmorMeta) {
            LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)itemStack.getItemMeta();
            leatherArmorMeta.setColor(color);
            itemStack.setItemMeta((ItemMeta)leatherArmorMeta);
            return itemStack;
        }
        return itemStack;
    }

    static {
        versionId = Integer.parseInt(Bukkit.getBukkitVersion().split("-")[0].replace(".", "#").split("#")[1]);
    }
}

