/*
 * Decompiled with CFR 0.152.
 */
package Utils;

import Zombies.GameArena;
import java.util.Collection;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.scoreboard.Scoreboard;

public class PlayerSettings {
    private Player player;
    private String uuid;
    private GameArena gameArena;
    private Scoreboard playerScoreboard;
    private ItemStack[] inventoryContent;
    private ItemStack[] inventoryArmorContent;
    private double health;
    private double maxHealth;
    private Collection<PotionEffect> potionEffects;
    private Location location;
    private float exp;
    private int level;
    private GameMode gameMode;
    private boolean allowFlight;
    private boolean flying;
    private int foodLevel;

    public PlayerSettings(Player player, GameArena gameArena) {
        this.player = player;
        this.uuid = player.getUniqueId().toString();
        this.gameArena = gameArena;
        this.playerScoreboard = player.getScoreboard();
        this.inventoryContent = player.getInventory().getContents();
        this.inventoryArmorContent = player.getInventory().getArmorContents();
        this.health = player.getHealth();
        this.maxHealth = player.getMaxHealth();
        this.potionEffects = player.getActivePotionEffects();
        this.location = player.getLocation();
        this.exp = player.getExp();
        this.level = player.getLevel();
        this.gameMode = player.getGameMode();
        this.allowFlight = player.getAllowFlight();
        this.flying = player.isFlying();
        this.foodLevel = player.getFoodLevel();
    }

    public void restore() {
        PotionEffect potionEffect;
        Player player = Bukkit.getPlayer((UUID)UUID.fromString(this.uuid));
        if (player == null) {
            return;
        }
        if (!player.isOnline()) {
            return;
        }
        player.setScoreboard(this.playerScoreboard);
        player.getInventory().setContents(this.inventoryContent);
        player.getInventory().setArmorContents(this.inventoryArmorContent);
        player.setMaxHealth(this.maxHealth);
        player.setHealth(this.health);
        Object object = this.potionEffects.iterator();
        while (object.hasNext()) {
            potionEffect = object.next();
            player.addPotionEffect(potionEffect);
        }
        if (this.gameArena != null && (object = this.gameArena.getFileConfiguration().getString("ResetLocation")) != null) {
            potionEffect = Bukkit.getWorld((String)((String)object).split(":")[0]);
            double d = Double.valueOf(((String)object).split(":")[1]);
            double d2 = Double.valueOf(((String)object).split(":")[2]);
            double d3 = Double.valueOf(((String)object).split(":")[3]);
            double d4 = Double.valueOf(((String)object).split(":")[4]);
            double d5 = Double.valueOf(((String)object).split(":")[5]);
            Location location = new Location((World)potionEffect, d, d2, d3);
            location.setYaw((float)d4);
            location.setPitch((float)d5);
            this.location = location;
        }
        player.teleport(this.location);
        player.setExp(this.exp);
        player.setLevel(this.level);
        player.setGameMode(this.gameMode);
        player.setAllowFlight(this.allowFlight);
        player.setFlying(this.flying);
        player.setFoodLevel(this.foodLevel);
        player.updateInventory();
    }

    public void restoreDefaultSettings() {
        Player player = Bukkit.getPlayer((UUID)UUID.fromString(this.uuid));
        if (player == null) {
            return;
        }
        if (!player.isOnline()) {
            return;
        }
        player.getInventory().setContents(this.inventoryContent);
        player.getInventory().setArmorContents(this.inventoryArmorContent);
        player.setMaxHealth(this.maxHealth);
        player.setHealth(this.health);
        for (PotionEffect potionEffect : this.potionEffects) {
            player.addPotionEffect(potionEffect);
        }
        player.teleport(this.location);
    }
}

