/*
 * Decompiled with CFR 0.152.
 */
package Weapons;

import Weapons.Weapon;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class WeaponReload {
    private String player;
    private Weapon weapon;
    private int weaponSlot;
    private int durability;
    private ItemStack itemStack;
    private ItemStack savedItemStack;
    private long time;

    public WeaponReload setPlayer(Player player) {
        this.player = player.getUniqueId().toString();
        return this;
    }

    public WeaponReload setWeapon(Weapon weapon) {
        this.weapon = weapon;
        return this;
    }

    public WeaponReload setWeaponSlot(int n) {
        this.weaponSlot = n;
        return this;
    }

    public WeaponReload setDurability(int n) {
        this.durability = n;
        return this;
    }

    public WeaponReload setItemStack(ItemStack itemStack) {
        itemStack.setDurability(itemStack.getType().getMaxDurability());
        this.getPlayer().getInventory().setItem(this.getWeaponSlot(), itemStack);
        this.itemStack = itemStack;
        this.savedItemStack = itemStack;
        return this;
    }

    public WeaponReload setSavedItemStack(ItemStack itemStack) {
        this.savedItemStack = itemStack;
        return this;
    }

    public WeaponReload setTime(long l) {
        this.time = l;
        return this;
    }

    public Player getPlayer() {
        return Bukkit.getPlayer((UUID)UUID.fromString(this.player));
    }

    public Weapon getWeapon() {
        return this.weapon;
    }

    public int getWeaponSlot() {
        return this.weaponSlot;
    }

    public int getDurability() {
        return this.durability;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public ItemStack getSavedItemStack() {
        return this.savedItemStack;
    }

    public long getTime() {
        return this.time;
    }
}

