/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.ae.handlers.lootPopulation;

import com.google.common.collect.ImmutableMap;
import java.util.EnumMap;
import java.util.concurrent.ThreadLocalRandom;
import net.advancedplugins.ae.Core;
import net.advancedplugins.ae.enchanthandler.enchantments.AdvancedGroup;
import net.advancedplugins.ae.features.orbs.Orb;
import net.advancedplugins.ae.features.souls.SoulGem;
import net.advancedplugins.ae.features.souls.SoulTracker;
import net.advancedplugins.ae.features.tinkerer.TinkererItems;
import net.advancedplugins.ae.handlers.commands.MCI;
import net.advancedplugins.ae.handlers.lootPopulation.LootMap;
import net.advancedplugins.ae.handlers.lootPopulation.PopulationFile;
import net.advancedplugins.ae.handlers.lootPopulation.enums.LootMapType;
import net.advancedplugins.ae.handlers.lootPopulation.enums.LootType;
import net.advancedplugins.ae.impl.effects.effects.effects.AdvancedEffect;
import net.advancedplugins.ae.impl.utils.configs.YamlFile;
import net.advancedplugins.ae.items.HolyWhiteScroll;
import net.advancedplugins.ae.items.ItemLoader;
import net.advancedplugins.ae.items.OtherItems;
import net.advancedplugins.ae.items.StatTrak;
import net.advancedplugins.ae.items.WhiteScroll;
import net.advancedplugins.ae.items.item.BlockTrack;
import net.advancedplugins.ae.items.item.MobTracker;
import net.advancedplugins.ae.items.item.RenameTag;
import net.advancedplugins.ae.items.item.SlotIncreaser;
import net.advancedplugins.ae.items.item.TransmogScroll;
import net.advancedplugins.ae.utils.AManager;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;

public class PopulationHandler {
    private final PopulationFile popFile;
    private final LootMap randomLootMap;
    private final LootMap villagerLootMap;
    private static int[] a;
    private static final String[] b;

    public PopulationHandler(JavaPlugin javaPlugin) {
        this.popFile = new PopulationFile(javaPlugin);
        int[] nArray = PopulationHandler.b();
        this.randomLootMap = new LootMap(LootMapType.RANDOM_LOOT, this);
        this.villagerLootMap = new LootMap(LootMapType.VILLAGER, this);
        if (nArray != null) {
            AdvancedEffect.b(new int[5]);
        }
    }

    public LootMap getRandomLootMap() {
        return this.randomLootMap;
    }

    public LootMap getVillagerLootMap() {
        return this.villagerLootMap;
    }

    public PopulationFile getPopFile() {
        return this.popFile;
    }

    public ImmutableMap<LootType, Integer> readChances(LootMapType lootMapType) {
        ImmutableMap immutableMap;
        String string = lootMapType.getChancesPath();
        int[] nArray = PopulationHandler.b();
        EnumMap<LootType, Integer> enumMap = new EnumMap<LootType, Integer>(LootType.class);
        for (String string2 : this.popFile.get().getConfigurationSection(string).getKeys(false)) {
            LootType lootType;
            try {
                lootType = LootType.valueOf(string2);
            }
            catch (Exception exception) {
                AManager.error(b[1] + string2);
                continue;
            }
            int n = this.popFile.get().getInt(string + "." + string2);
            enumMap.put(lootType, n);
            if (nArray == null) continue;
        }
        try {
            immutableMap = ImmutableMap.copyOf(enumMap);
            if (AdvancedEffect.b() != null) {
                PopulationHandler.b(new int[1]);
            }
        }
        catch (Exception exception) {
            throw PopulationHandler.b(exception);
        }
        return immutableMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ItemStack getLoot(LootMapType lootMapType, LootType lootType) {
        try {
            ItemLoader itemLoader = Core.getInstance().getItemHandler();
            switch (lootType) {
                case SLOT_INCREASER: {
                    SlotIncreaser slotIncreaser = (SlotIncreaser)itemLoader.getItem(SlotIncreaser.class);
                    return slotIncreaser.buildFor(AdvancedGroup.getRandomGroup());
                }
                case WHITE_SCROLL: {
                    return WhiteScroll.make();
                }
                case MYSTERY_DUST: {
                    return TinkererItems.mysteryDust();
                }
                case SECRET_DUST: {
                    return TinkererItems.secretDust(AdvancedGroup.getRandomGroup());
                }
                case MAGIC_DUST: {
                    return TinkererItems.magicDust(AdvancedGroup.getRandomGroup());
                }
                case BLACK_SCROLL: {
                    return OtherItems.BlackScroll(ThreadLocalRandom.current().nextInt(100) + 1);
                }
                case RANDOMIZER: {
                    return OtherItems.RandomizationScroll(AdvancedGroup.getRandomGroup());
                }
                case RENAME_TAG: {
                    return itemLoader.getItem(RenameTag.class).build();
                }
                case BLOCKTRAK: {
                    return itemLoader.getItem(BlockTrack.class).build();
                }
                case STATTRAK: {
                    return StatTrak.get();
                }
                case MOBTRAK: {
                    return itemLoader.getItem(MobTracker.class).build();
                }
                case SOUL_TRACKER: {
                    return SoulTracker.make();
                }
                case SOUL_GEM: {
                    return SoulGem.getGem(ThreadLocalRandom.current().nextInt(100));
                }
                case TRANSMOG_SCROLL: {
                    return itemLoader.getItem(TransmogScroll.class).build();
                }
                case HOLY_WHITE_SCROLL: {
                    return HolyWhiteScroll.get(1);
                }
                case ARMOR_ORB: {
                    String[] stringArray = b;
                    return Orb.getOrb(stringArray[2], YamlFile.CONFIG.getInt(stringArray[6], 7) + 1, ThreadLocalRandom.current().nextInt(100) + 1);
                }
                case WEAPON_ORB: {
                    String[] stringArray = b;
                    return Orb.getOrb(stringArray[0], YamlFile.CONFIG.getInt(stringArray[6], 7) + 1, ThreadLocalRandom.current().nextInt(100) + 1);
                }
                case TOOL_ORB: {
                    String[] stringArray = b;
                    return Orb.getOrb(stringArray[7], YamlFile.CONFIG.getInt(stringArray[6], 7) + 1, ThreadLocalRandom.current().nextInt(100) + 1);
                }
                case RANDOM_ENCHANT_BOOK: {
                    try {
                        if (lootMapType == LootMapType.RANDOM_LOOT) {
                            if (this.getRandomLootMap().getBlockedGroups().isEmpty()) return MCI.getRandomBook();
                            return MCI.getRandomBookExcluded(this.getRandomLootMap().getBlockedGroups());
                        }
                    }
                    catch (Exception exception) {
                        throw PopulationHandler.b(exception);
                    }
                    try {
                        if (lootMapType != LootMapType.VILLAGER || this.getVillagerLootMap().getBlockedGroups().isEmpty()) return MCI.getRandomBook();
                        return MCI.getRandomBookExcluded(this.getVillagerLootMap().getBlockedGroups());
                    }
                    catch (Exception exception) {
                        throw PopulationHandler.b(exception);
                    }
                }
            }
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String[] stringArray = new String[2];
            String[] stringArray2 = b;
            stringArray[0] = stringArray2[4] + lootType.name() + stringArray2[5];
            stringArray[1] = stringArray2[3];
            AManager.error(stringArray);
        }
        return null;
    }

    public ItemStack getVillagerTradeItem(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        itemStack.getType();
        if (itemStack.getType() == Material.ENCHANTED_BOOK) {
            return new ItemStack(Material.BOOK);
        }
        return new ItemStack(itemStack.getType());
    }

    public static void b(int[] nArray) {
        a = nArray;
    }

    public static int[] b() {
        return a;
    }

    private static Exception b(Exception exception) {
        return exception;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block10: {
            block9: {
                var5 = new String[8];
                var3_1 = 0;
                var2_2 = "\u0006,X\"\"Q\u001a\u0017\bp\u001e\b{N%\u00069\u001f\fk\r9Iu\u001d\u0002kN%\u0010i\u0017M\u0005\u0010;T=?i\u0018\u001d9\u001b\u001e?\u0003>\u001amR\u0001v\u00054\u0005`R\f?\r>\u0007\u007f\u001b\nj\u001c0\u001dp\u001d\u0003?\u0007\"\u001al\u0017M~\u00005Im\u001a\u0004lN8\u001d|\u001fJlN2\u0006w\u0014\u0004x\u001b#\bm\u001b\u0002qN\"\u0001v\u0007\u0001{N3\f9\u0011\u0005z\r:\f}R\u000fz\b>\u001b|R\u001fz\u001e>\u001bm\u001b\u0003x@=\u0017\bp\u001e\b{N%\u00069\u0015\bq\u000b#\bm\u0017M^\n'\bw\u0011\b{+?\nq\u0013\u0003k\u00034\u0007m\u0001MM\u000f?\rv\u001fMS\u0001>\u001d9\u0014\u0002mN8\u001d|\u001fM\u001fkI|\u0000\u001fp\u001cq\u0000jR\u0001p\r0\u001d|\u0016Mv\u0000q\nv\u001c\u001ep\u00024G9";
                var4_3 = "\u0006,X\"\"Q\u001a\u0017\bp\u001e\b{N%\u00069\u001f\fk\r9Iu\u001d\u0002kN%\u0010i\u0017M\u0005\u0010;T=?i\u0018\u001d9\u001b\u001e?\u0003>\u001amR\u0001v\u00054\u0005`R\f?\r>\u0007\u007f\u001b\nj\u001c0\u001dp\u001d\u0003?\u0007\"\u001al\u0017M~\u00005Im\u001a\u0004lN8\u001d|\u001fJlN2\u0006w\u0014\u0004x\u001b#\bm\u001b\u0002qN\"\u0001v\u0007\u0001{N3\f9\u0011\u0005z\r:\f}R\u000fz\b>\u001b|R\u001fz\u001e>\u001bm\u001b\u0003x@=\u0017\bp\u001e\b{N%\u00069\u0015\bq\u000b#\bm\u0017M^\n'\bw\u0011\b{+?\nq\u0013\u0003k\u00034\u0007m\u0001MM\u000f?\rv\u001fMS\u0001>\u001d9\u0014\u0002mN8\u001d|\u001fM\u001fkI|\u0000\u001fp\u001cq\u0000jR\u0001p\r0\u001d|\u0016Mv\u0000q\nv\u001c\u001ep\u00024G9".length();
                var1_4 = 6;
                var0_5 = -1;
                PopulationHandler.b(null);
lbl8:
                // 2 sources

                while (true) {
                    v0 = 36;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block9;
                    break;
                }
lbl14:
                // 1 sources

                while (true) {
                    var5[var3_1++] = PopulationHandler.a(v0, PopulationHandler.a(v2));
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "[|\u000f\u007fgHzIh\u0004|_/G";
                    var4_3 = "[|\u000f\u007fgHzIh\u0004|_/G".length();
                    var1_4 = 9;
                    var0_5 = -1;
lbl23:
                    // 2 sources

                    while (true) {
                        v0 = 93;
                        v4 = ++var0_5;
                        v2 = var2_2.substring(v4, v4 + var1_4);
                        v3 = 0;
                        break block9;
                        break;
                    }
                    break;
                }
lbl29:
                // 1 sources

                while (true) {
                    var5[var3_1++] = PopulationHandler.a(v0, PopulationHandler.a(v2));
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block10;
                    break;
                }
            }
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl40:
                // 1 sources

                ** continue;
            }
        }
        PopulationHandler.b = var5;
    }

    private static char[] a(String string) {
        char[] cArray = string.toCharArray();
        if (cArray.length < 2) {
            cArray = cArray;
            cArray[0] = (char)(cArray[0] ^ 0x4A);
        }
        return cArray;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    private static String a(int n, char[] cArray) {
        char[] cArray2;
        block11: {
            int n2;
            int n3;
            int n4;
            block10: {
                n4 = n;
                cArray2 = cArray;
                n3 = cArray.length;
                n2 = 0;
                if (!true) break block10;
                n3 = n3;
                if (n3 <= n2) break block11;
            }
            do {
                int n5;
                n4 = n4;
                cArray2 = cArray2;
                int n6 = n2;
                switch (n2 % 7) {
                    case 0: {
                        n5 = 117;
                        break;
                    }
                    case 1: {
                        n5 = 77;
                        break;
                    }
                    case 2: {
                        n5 = 61;
                        break;
                    }
                    case 3: {
                        n5 = 86;
                        break;
                    }
                    case 4: {
                        n5 = 73;
                        break;
                    }
                    case 5: {
                        n5 = 59;
                        break;
                    }
                    default: {
                        n5 = 74;
                    }
                }
                cArray2[n6] = (char)(cArray2[n6] ^ (n4 ^ n5));
                ++n2;
                n3 = n3;
            } while (n3 > n2);
        }
        return new String(cArray2).intern();
    }
}

