/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.ae.libs.apache.commons.math3.util;

import java.util.Arrays;
import net.advancedplugins.ae.libs.apache.commons.math3.RealFieldElement;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.MathArithmeticException;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.NotFiniteNumberException;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.NullArgumentException;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.util.Localizable;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.util.LocalizedFormats;
import net.advancedplugins.ae.libs.apache.commons.math3.util.FastMath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MathUtils {
    public static final double TWO_PI = Math.PI * 2;
    public static final double PI_SQUARED = Math.PI * Math.PI;

    private MathUtils() {
    }

    public static int hash(double d) {
        return new Double(d).hashCode();
    }

    public static boolean equals(double d, double d2) {
        return new Double(d).equals(new Double(d2));
    }

    public static int hash(double[] dArray) {
        return Arrays.hashCode(dArray);
    }

    public static double normalizeAngle(double d, double d2) {
        return d - Math.PI * 2 * FastMath.floor((d + Math.PI - d2) / (Math.PI * 2));
    }

    public static <T extends RealFieldElement<T>> T max(T t, T t2) {
        T t3;
        try {
            t3 = t.subtract(t2).getReal() >= 0.0 ? t : t2;
        }
        catch (MathArithmeticException mathArithmeticException) {
            throw MathUtils.b(mathArithmeticException);
        }
        return t3;
    }

    public static <T extends RealFieldElement<T>> T min(T t, T t2) {
        T t3;
        try {
            t3 = t.subtract(t2).getReal() >= 0.0 ? t2 : t;
        }
        catch (MathArithmeticException mathArithmeticException) {
            throw MathUtils.b(mathArithmeticException);
        }
        return t3;
    }

    public static double reduce(double d, double d2, double d3) {
        double d4 = FastMath.abs(d2);
        return d - d4 * FastMath.floor((d - d3) / d4) - d3;
    }

    public static byte copySign(byte by, byte by2) throws MathArithmeticException {
        block14: {
            block13: {
                try {
                    block12: {
                        try {
                            try {
                                try {
                                    if (by >= 0 && by2 >= 0) break block12;
                                }
                                catch (MathArithmeticException mathArithmeticException) {
                                    throw MathUtils.b(mathArithmeticException);
                                }
                                if (by >= 0) break block13;
                            }
                            catch (MathArithmeticException mathArithmeticException) {
                                throw MathUtils.b(mathArithmeticException);
                            }
                            if (by2 >= 0) break block13;
                        }
                        catch (MathArithmeticException mathArithmeticException) {
                            throw MathUtils.b(mathArithmeticException);
                        }
                    }
                    return by;
                }
                catch (MathArithmeticException mathArithmeticException) {
                    throw MathUtils.b(mathArithmeticException);
                }
            }
            try {
                try {
                    if (by2 < 0 || by != -128) break block14;
                }
                catch (MathArithmeticException mathArithmeticException) {
                    throw MathUtils.b(mathArithmeticException);
                }
                throw new MathArithmeticException(LocalizedFormats.OVERFLOW, new Object[0]);
            }
            catch (MathArithmeticException mathArithmeticException) {
                throw MathUtils.b(mathArithmeticException);
            }
        }
        return -by;
    }

    public static short copySign(short s, short s2) throws MathArithmeticException {
        block14: {
            block13: {
                try {
                    block12: {
                        try {
                            try {
                                try {
                                    if (s >= 0 && s2 >= 0) break block12;
                                }
                                catch (MathArithmeticException mathArithmeticException) {
                                    throw MathUtils.b(mathArithmeticException);
                                }
                                if (s >= 0) break block13;
                            }
                            catch (MathArithmeticException mathArithmeticException) {
                                throw MathUtils.b(mathArithmeticException);
                            }
                            if (s2 >= 0) break block13;
                        }
                        catch (MathArithmeticException mathArithmeticException) {
                            throw MathUtils.b(mathArithmeticException);
                        }
                    }
                    return s;
                }
                catch (MathArithmeticException mathArithmeticException) {
                    throw MathUtils.b(mathArithmeticException);
                }
            }
            try {
                try {
                    if (s2 < 0 || s != Short.MIN_VALUE) break block14;
                }
                catch (MathArithmeticException mathArithmeticException) {
                    throw MathUtils.b(mathArithmeticException);
                }
                throw new MathArithmeticException(LocalizedFormats.OVERFLOW, new Object[0]);
            }
            catch (MathArithmeticException mathArithmeticException) {
                throw MathUtils.b(mathArithmeticException);
            }
        }
        return -s;
    }

    public static int copySign(int n, int n2) throws MathArithmeticException {
        block14: {
            block13: {
                try {
                    block12: {
                        try {
                            try {
                                try {
                                    if (n >= 0 && n2 >= 0) break block12;
                                }
                                catch (MathArithmeticException mathArithmeticException) {
                                    throw MathUtils.b(mathArithmeticException);
                                }
                                if (n >= 0) break block13;
                            }
                            catch (MathArithmeticException mathArithmeticException) {
                                throw MathUtils.b(mathArithmeticException);
                            }
                            if (n2 >= 0) break block13;
                        }
                        catch (MathArithmeticException mathArithmeticException) {
                            throw MathUtils.b(mathArithmeticException);
                        }
                    }
                    return n;
                }
                catch (MathArithmeticException mathArithmeticException) {
                    throw MathUtils.b(mathArithmeticException);
                }
            }
            try {
                try {
                    if (n2 < 0 || n != Integer.MIN_VALUE) break block14;
                }
                catch (MathArithmeticException mathArithmeticException) {
                    throw MathUtils.b(mathArithmeticException);
                }
                throw new MathArithmeticException(LocalizedFormats.OVERFLOW, new Object[0]);
            }
            catch (MathArithmeticException mathArithmeticException) {
                throw MathUtils.b(mathArithmeticException);
            }
        }
        return -n;
    }

    public static long copySign(long l, long l2) throws MathArithmeticException {
        block14: {
            block13: {
                try {
                    block12: {
                        try {
                            try {
                                try {
                                    if (l >= 0L && l2 >= 0L) break block12;
                                }
                                catch (MathArithmeticException mathArithmeticException) {
                                    throw MathUtils.b(mathArithmeticException);
                                }
                                if (l >= 0L) break block13;
                            }
                            catch (MathArithmeticException mathArithmeticException) {
                                throw MathUtils.b(mathArithmeticException);
                            }
                            if (l2 >= 0L) break block13;
                        }
                        catch (MathArithmeticException mathArithmeticException) {
                            throw MathUtils.b(mathArithmeticException);
                        }
                    }
                    return l;
                }
                catch (MathArithmeticException mathArithmeticException) {
                    throw MathUtils.b(mathArithmeticException);
                }
            }
            try {
                try {
                    if (l2 < 0L || l != Long.MIN_VALUE) break block14;
                }
                catch (MathArithmeticException mathArithmeticException) {
                    throw MathUtils.b(mathArithmeticException);
                }
                throw new MathArithmeticException(LocalizedFormats.OVERFLOW, new Object[0]);
            }
            catch (MathArithmeticException mathArithmeticException) {
                throw MathUtils.b(mathArithmeticException);
            }
        }
        return -l;
    }

    public static void checkFinite(double d) throws NotFiniteNumberException {
        block4: {
            try {
                try {
                    if (!Double.isInfinite(d) && !Double.isNaN(d)) break block4;
                }
                catch (NotFiniteNumberException notFiniteNumberException) {
                    throw MathUtils.b(notFiniteNumberException);
                }
                throw new NotFiniteNumberException(d, new Object[0]);
            }
            catch (NotFiniteNumberException notFiniteNumberException) {
                throw MathUtils.b(notFiniteNumberException);
            }
        }
    }

    public static void checkFinite(double[] dArray) throws NotFiniteNumberException {
        String string = FastMath.b();
        for (int i = 0; i < dArray.length; ++i) {
            double d = dArray[i];
            try {
                try {
                    if (!Double.isInfinite(d) && !Double.isNaN(d)) continue;
                }
                catch (NotFiniteNumberException notFiniteNumberException) {
                    throw MathUtils.b(notFiniteNumberException);
                }
                throw new NotFiniteNumberException((Localizable)LocalizedFormats.ARRAY_ELEMENT, d, i);
            }
            catch (NotFiniteNumberException notFiniteNumberException) {
                throw MathUtils.b(notFiniteNumberException);
            }
        }
    }

    public static void checkNotNull(Object object, Localizable localizable, Object ... objectArray) throws NullArgumentException {
        try {
            if (object == null) {
                throw new NullArgumentException(localizable, objectArray);
            }
        }
        catch (NullArgumentException nullArgumentException) {
            throw MathUtils.b(nullArgumentException);
        }
    }

    public static void checkNotNull(Object object) throws NullArgumentException {
        try {
            if (object == null) {
                throw new NullArgumentException();
            }
        }
        catch (NullArgumentException nullArgumentException) {
            throw MathUtils.b(nullArgumentException);
        }
    }

    private static RuntimeException b(RuntimeException runtimeException) {
        return runtimeException;
    }
}

