/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertask.command.admin;

import com.handy.playertask.constants.TaskTypeEnum;
import com.handy.playertask.entity.TaskList;
import com.handy.playertask.entity.TaskNpc;
import com.handy.playertask.lib.command.IHandyCommandEvent;
import com.handy.playertask.lib.util.AssertUtil;
import com.handy.playertask.lib.util.BaseUtil;
import com.handy.playertask.lib.util.MessageUtil;
import com.handy.playertask.service.TaskListService;
import com.handy.playertask.service.TaskNpcService;
import java.util.Optional;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public class AddNpcTaskCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "addNpcTask";
    }

    @Override
    public String permission() {
        return "playerTask.addNpcTask";
    }

    @Override
    public void onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        AssertUtil.notTrue(args.length < 6, sender, BaseUtil.getMsgNotColor("paramFailureMsg"));
        Integer taskId = AssertUtil.isNumericToInt(args[1], sender, BaseUtil.getMsgNotColor("amountFailureMsg"));
        Optional<TaskList> taskListOptional = TaskListService.getInstance().findById(taskId);
        AssertUtil.isTrue(taskListOptional.isPresent(), sender, BaseUtil.getMsgNotColor("noDataExist"));
        TaskList taskList = taskListOptional.get();
        AssertUtil.isTrue(TaskTypeEnum.NPC.getType().equals(taskList.getType()), sender, BaseUtil.getMsgNotColor("noDataExist"));
        Integer npcId = AssertUtil.isNumericToInt(args[2], sender, BaseUtil.getMsgNotColor("amountFailureMsg"));
        Integer isEver = AssertUtil.isNumericToInt(args[3], sender, BaseUtil.getMsgNotColor("amountFailureMsg"));
        AssertUtil.notTrue(isEver > 1 || isEver < 0, sender, BaseUtil.getMsgNotColor("paramFailureMsg"));
        Integer number = AssertUtil.isNumericToInt(args[4], sender, BaseUtil.getMsgNotColor("amountFailureMsg"));
        Integer cd = AssertUtil.isNumericToInt(args[5], sender, BaseUtil.getMsgNotColor("amountFailureMsg"));
        Integer parentId = 0;
        if (args.length > 6) {
            parentId = AssertUtil.isNumericToInt(args[6], sender, BaseUtil.getMsgNotColor("amountFailureMsg"));
            Optional<TaskList> parentTaskListOptional = TaskListService.getInstance().findById(parentId);
            AssertUtil.isTrue(parentTaskListOptional.isPresent(), sender, BaseUtil.getMsgNotColor("noDataExist"));
        }
        TaskNpc taskNpc = new TaskNpc();
        taskNpc.setTaskId(taskId);
        taskNpc.setTaskName(taskList.getTaskName());
        taskNpc.setNpcId(npcId);
        taskNpc.setIsEver(isEver);
        taskNpc.setNumber(number);
        taskNpc.setCd(cd);
        taskNpc.setParentId(parentId);
        boolean rst = TaskNpcService.getInstance().add(taskNpc);
        MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor(rst ? "succeedMsg" : "failureMsg"));
    }
}

