/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertask.command.admin;

import com.handy.playertask.constants.RewardTypeEnum;
import com.handy.playertask.entity.TaskRewards;
import com.handy.playertask.lib.command.IHandyCommandEvent;
import com.handy.playertask.lib.core.StrUtil;
import com.handy.playertask.lib.util.AssertUtil;
import com.handy.playertask.lib.util.BaseUtil;
import com.handy.playertask.lib.util.ItemStackUtil;
import com.handy.playertask.lib.util.MessageUtil;
import com.handy.playertask.service.TaskRewardsService;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class AddRewardCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "addReward";
    }

    @Override
    public String permission() {
        return "playerTask.addReward";
    }

    @Override
    public void onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        boolean rst;
        AssertUtil.notTrue(args.length < 3, sender, BaseUtil.getMsgNotColor("paramFailureMsg"));
        RewardTypeEnum rewardTypeEnum = RewardTypeEnum.getEnumThrow(args[1]);
        Integer amount = AssertUtil.isNumericToInt(args[2], sender, BaseUtil.getMsgNotColor("amountFailureMsg"));
        TaskRewards taskRewards = new TaskRewards();
        taskRewards.setType(rewardTypeEnum.getType());
        taskRewards.setAmount(amount);
        if (RewardTypeEnum.ITEM_STACK.getType().equals(rewardTypeEnum.getType())) {
            Player player = AssertUtil.notPlayer(sender, BaseUtil.getMsgNotColor("noPlayerFailureMsg"));
            ItemStack itemInMainHand = ItemStackUtil.getItemInMainHand(player.getInventory());
            AssertUtil.notTrue(Material.AIR.equals((Object)itemInMainHand.getType()), sender, BaseUtil.getMsgNotColor("noAir"));
            ItemStack clone = itemInMainHand.clone();
            clone.setAmount(1);
            taskRewards.setItemStack(ItemStackUtil.itemStackSerialize(clone));
        }
        if (RewardTypeEnum.COMMAND.getType().equals(rewardTypeEnum.getType())) {
            AssertUtil.notTrue(args.length < 4, sender, BaseUtil.getMsgNotColor("paramFailureMsg"));
            taskRewards.setItemStack(StrUtil.replaceSpace(args[3]));
            if (args.length == 5) {
                taskRewards.setDescription(args[4]);
            }
        } else if (args.length == 4) {
            taskRewards.setDescription(args[3]);
        }
        MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor((rst = TaskRewardsService.getInstance().add(taskRewards)) ? "succeedMsg" : "failureMsg"));
    }
}

