/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertask.command.admin;

import com.handy.playertask.constants.BaseTaskConstants;
import com.handy.playertask.constants.DemandTypeEnum;
import com.handy.playertask.constants.RarityEnum;
import com.handy.playertask.constants.TaskTypeEnum;
import com.handy.playertask.entity.TaskList;
import com.handy.playertask.inventory.CreateDemandGui;
import com.handy.playertask.lib.command.IHandyCommandEvent;
import com.handy.playertask.lib.expand.adapter.HandySchedulerUtil;
import com.handy.playertask.lib.util.AssertUtil;
import com.handy.playertask.lib.util.BaseUtil;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;

public class CreateCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "create";
    }

    @Override
    public String permission() {
        return "playerTask.create";
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        AssertUtil.notTrue(args.length < 2, sender, BaseUtil.getMsgNotColor("paramFailureMsg"));
        Player player = AssertUtil.notPlayer(sender, BaseUtil.getMsgNotColor("noPlayerFailureMsg"));
        TaskList taskList = new TaskList();
        taskList.setTaskName(args[1]);
        taskList.setType(TaskTypeEnum.EVERYDAY.getType());
        taskList.setRarity(RarityEnum.NORMAL.getType());
        if (args.length >= 3) {
            taskList.setType(TaskTypeEnum.getEnum(args[2]).getType());
        }
        if (args.length >= 4) {
            taskList.setRarity(RarityEnum.getEnum(args[3]).getType());
        }
        BaseTaskConstants.TASK_LIST_MAP.put(player.getUniqueId(), taskList);
        Inventory inventory = CreateDemandGui.getInstance().createGui(player, DemandTypeEnum.ALL.getType());
        HandySchedulerUtil.runTask(() -> player.openInventory(inventory));
    }
}

