/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertask.inventory;

import com.handy.playertask.constants.BaseTaskConstants;
import com.handy.playertask.constants.GuiTypeEnum;
import com.handy.playertask.constants.RewardTypeEnum;
import com.handy.playertask.entity.TaskList;
import com.handy.playertask.entity.TaskRewards;
import com.handy.playertask.hook.PlaceholderApiUtil;
import com.handy.playertask.lib.core.MapUtil;
import com.handy.playertask.lib.core.StrUtil;
import com.handy.playertask.lib.db.enter.Page;
import com.handy.playertask.lib.inventory.HandyInventory;
import com.handy.playertask.lib.inventory.HandyInventoryUtil;
import com.handy.playertask.lib.util.BaseUtil;
import com.handy.playertask.lib.util.ItemStackUtil;
import com.handy.playertask.param.TaskReplaceContent;
import com.handy.playertask.service.TaskRewardsService;
import com.handy.playertask.util.ConfigUtil;
import com.handy.playertask.util.RewardReplaceUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class CreateRewardsGui {
    private static final CreateRewardsGui INSTANCE = new CreateRewardsGui();

    private CreateRewardsGui() {
    }

    public static CreateRewardsGui getInstance() {
        return INSTANCE;
    }

    public Inventory createGui(Player player, String search) {
        String title = ConfigUtil.REWARDS_CONFIG.getString("title", "");
        title = PlaceholderApiUtil.set(player, title);
        int size = ConfigUtil.REWARDS_CONFIG.getInt("size", 54);
        HandyInventory handyInventory = new HandyInventory(GuiTypeEnum.CREATE_REWARDS.getType(), title, size);
        handyInventory.setPlayer(player);
        handyInventory.setSearchType(search);
        this.setInventoryDate(handyInventory);
        return handyInventory.getInventory();
    }

    public void setInventoryDate(HandyInventory handyInventory) {
        handyInventory.setGuiType(GuiTypeEnum.CREATE_REWARDS.getType());
        HandyInventoryUtil.refreshInventory(handyInventory.getInventory());
        this.setDate(handyInventory);
        this.setFunctionMenu(handyInventory);
    }

    public void setDate(HandyInventory handyInventory) {
        Inventory inventory = handyInventory.getInventory();
        Player player = handyInventory.getPlayer();
        String searchType = handyInventory.getSearchType();
        Map<Integer, Integer> map = handyInventory.getIntMap();
        List<Integer> indexList = StrUtil.strToIntList(ConfigUtil.REWARDS_CONFIG.getString("rewards.index"));
        handyInventory.setPageSize(indexList.size());
        Page<TaskRewards> page = TaskRewardsService.getInstance().page(searchType, handyInventory.getPageNum(), handyInventory.getPageSize());
        handyInventory.setPageCount(page.getTotal());
        if (page.getTotal() < 1) {
            return;
        }
        int i = 0;
        String name = ConfigUtil.REWARDS_CONFIG.getString("rewards.name", "");
        for (TaskRewards taskRewards : page.getRecords()) {
            TaskReplaceContent rewardContent = RewardReplaceUtil.getRewardContent(taskRewards, player);
            ItemStack itemStack = rewardContent.getItemStack();
            ItemMeta itemMeta = ItemStackUtil.getItemMeta(itemStack);
            itemMeta.setDisplayName(BaseUtil.replaceChatColor(StrUtil.replace(name, "id", taskRewards.getId().toString())));
            List<String> loreList = rewardContent.getLoreList();
            TaskList taskList = BaseTaskConstants.TASK_LIST_MAP.get(player.getUniqueId());
            if (taskList != null && StrUtil.isNotEmpty(taskList.getTaskRewards())) {
                List<Integer> rewardsIds = StrUtil.strToIntList(taskList.getTaskRewards());
                for (Integer rewardsId : rewardsIds) {
                    if (!rewardsId.equals(taskRewards.getId())) continue;
                    ItemStackUtil.setEnchant(itemMeta);
                    ItemStackUtil.hideEnchant(itemMeta);
                    loreList.add(BaseUtil.getMsgNotColor("selected"));
                }
            }
            itemMeta.setLore(BaseUtil.replaceChatColor(loreList));
            itemStack.setItemMeta(itemMeta);
            Integer index = indexList.get(i++);
            inventory.setItem(index.intValue(), itemStack);
            map.put(index, taskRewards.getId());
        }
    }

    private void setFunctionMenu(HandyInventory handyInventory) {
        Inventory inventory = handyInventory.getInventory();
        Map<String, String> replacePageMap = HandyInventoryUtil.replacePageMap(handyInventory);
        HandyInventoryUtil.setButton(ConfigUtil.REWARDS_CONFIG, inventory, "nextPage", replacePageMap);
        HandyInventoryUtil.setButton(ConfigUtil.REWARDS_CONFIG, inventory, "previousPage", replacePageMap);
        HandyInventoryUtil.setButton(ConfigUtil.REWARDS_CONFIG, inventory, "search", this.replaceSearchMap(handyInventory));
        HandyInventoryUtil.setButton(ConfigUtil.REWARDS_CONFIG, inventory, "step");
        HandyInventoryUtil.setButton(ConfigUtil.REWARDS_CONFIG, inventory, "back");
        HandyInventoryUtil.setButton(ConfigUtil.REWARDS_CONFIG, inventory, "pane");
    }

    private Map<String, String> replaceSearchMap(HandyInventory handyInventory) {
        String searchType = handyInventory.getSearchType();
        RewardTypeEnum rewardTypeEnum = RewardTypeEnum.getEnumThrow(searchType);
        RewardTypeEnum nextEnum = RewardTypeEnum.getNextEnum(searchType);
        HashMap<String, String> map = MapUtil.newHashMapWithExpectedSize(2);
        map.put("type", RewardTypeEnum.getTypeName(rewardTypeEnum.getType()));
        map.put("nextType", RewardTypeEnum.getTypeName(nextEnum.getType()));
        return map;
    }
}

