/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertask.inventory;

import com.handy.playertask.constants.GuiTypeEnum;
import com.handy.playertask.entity.TaskPlayer;
import com.handy.playertask.hook.PlaceholderApiUtil;
import com.handy.playertask.lib.core.DateUtil;
import com.handy.playertask.lib.core.MapUtil;
import com.handy.playertask.lib.core.StrUtil;
import com.handy.playertask.lib.db.enter.Page;
import com.handy.playertask.lib.inventory.HandyInventory;
import com.handy.playertask.lib.inventory.HandyInventoryUtil;
import com.handy.playertask.lib.util.BaseUtil;
import com.handy.playertask.service.TaskPlayerService;
import com.handy.playertask.util.ConfigUtil;
import com.handy.playertask.util.TaskUtil;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class OpenGui {
    private static final OpenGui INSTANCE = new OpenGui();

    private OpenGui() {
    }

    public static OpenGui getInstance() {
        return INSTANCE;
    }

    public Inventory createGui(Player player) {
        return this.createGui(player, 1);
    }

    public Inventory createGui(Player player, Integer pageNum) {
        String title = ConfigUtil.OPEN_CONFIG.getString("title", "");
        title = PlaceholderApiUtil.set(player, title);
        int size = ConfigUtil.OPEN_CONFIG.getInt("size", 54);
        HandyInventory handyInventory = new HandyInventory(GuiTypeEnum.OPEN.getType(), title, size);
        handyInventory.setPageNum(pageNum != null ? pageNum : 1);
        handyInventory.setPlayer(player);
        this.setInventoryDate(handyInventory);
        return handyInventory.getInventory();
    }

    public void setInventoryDate(HandyInventory handyInventory) {
        handyInventory.setGuiType(GuiTypeEnum.OPEN.getType());
        HandyInventoryUtil.refreshInventory(handyInventory.getInventory());
        this.setDate(handyInventory);
        this.setFunctionMenu(handyInventory);
    }

    public void setDate(HandyInventory handyInventory) {
        Player player = handyInventory.getPlayer();
        Inventory inventory = handyInventory.getInventory();
        Map<Integer, Integer> map = handyInventory.getIntMap();
        List<Integer> indexList = StrUtil.strToIntList(ConfigUtil.OPEN_CONFIG.getString("task.index"));
        handyInventory.setPageSize(indexList.size());
        Page<TaskPlayer> page = TaskPlayerService.getInstance().page(player.getUniqueId(), DateUtil.getToday(), handyInventory.getPageNum(), handyInventory.getPageSize());
        handyInventory.setPageCount(page.getTotal());
        if (page.getTotal() < 1) {
            return;
        }
        int i = 0;
        for (TaskPlayer taskPlayer : page.getRecords()) {
            ItemStack itemStack = TaskUtil.createTaskItemStack(player, taskPlayer);
            Integer index = indexList.get(i++);
            inventory.setItem(index.intValue(), itemStack);
            map.put(index, taskPlayer.getId());
        }
    }

    private void setFunctionMenu(HandyInventory handyInventory) {
        Inventory inventory = handyInventory.getInventory();
        Map<String, String> replacePageMap = HandyInventoryUtil.replacePageMap(handyInventory);
        HandyInventoryUtil.setButton(ConfigUtil.OPEN_CONFIG, inventory, "nextPage", replacePageMap);
        HandyInventoryUtil.setButton(ConfigUtil.OPEN_CONFIG, inventory, "previousPage", replacePageMap);
        HandyInventoryUtil.setButton(ConfigUtil.OPEN_CONFIG, inventory, "refresh", this.refreshReplaceMap(handyInventory.getPlayer()));
        HandyInventoryUtil.setButton(ConfigUtil.OPEN_CONFIG, inventory, "shop");
        HandyInventoryUtil.setCustomButton(ConfigUtil.OPEN_CONFIG, handyInventory, "custom");
    }

    private Map<String, String> refreshReplaceMap(Player player) {
        boolean doneRefresh = ConfigUtil.REFRESH_CONFIG.getBoolean("doneRefresh", true);
        if (!doneRefresh) {
            return MapUtil.of("lore", BaseUtil.getMsgNotColor("refresh"));
        }
        int doneStatusTask = TaskPlayerService.getInstance().findByDoneStatus(player.getUniqueId(), DateUtil.getToday());
        String lore = BaseUtil.getMsgNotColor(doneStatusTask > 0 ? "noRefresh" : "refresh");
        return MapUtil.of("lore", lore);
    }
}

