/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertask.inventory;

import com.handy.playertask.constants.GuiTypeEnum;
import com.handy.playertask.hook.PlaceholderApiUtil;
import com.handy.playertask.hook.PlayerPointsUtil;
import com.handy.playertask.hook.VaultUtil;
import com.handy.playertask.lib.core.DateUtil;
import com.handy.playertask.lib.core.MapUtil;
import com.handy.playertask.lib.inventory.HandyInventory;
import com.handy.playertask.lib.inventory.HandyInventoryUtil;
import com.handy.playertask.lib.util.BaseUtil;
import com.handy.playertask.lib.util.HandyPermissionUtil;
import com.handy.playertask.service.TaskPlayerService;
import com.handy.playertask.util.ConfigUtil;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;

public class RefreshGui {
    private static final RefreshGui INSTANCE = new RefreshGui();

    private RefreshGui() {
    }

    public static RefreshGui getInstance() {
        return INSTANCE;
    }

    public Inventory createGui(Player player) {
        String title = ConfigUtil.REFRESH_CONFIG.getString("title");
        title = PlaceholderApiUtil.set(player, title);
        int size = ConfigUtil.REFRESH_CONFIG.getInt("size", 27);
        HandyInventory handyInventory = new HandyInventory(GuiTypeEnum.REFRESH.getType(), title, size);
        handyInventory.setPlayer(player);
        this.setInventoryDate(handyInventory);
        return handyInventory.getInventory();
    }

    private void setInventoryDate(HandyInventory handyInventory) {
        handyInventory.setGuiType(GuiTypeEnum.REFRESH.getType());
        this.setFunctionMenu(handyInventory);
    }

    private void setFunctionMenu(HandyInventory handyInventory) {
        Inventory inventory = handyInventory.getInventory();
        Player player = handyInventory.getPlayer();
        String guildName = handyInventory.getSearchType();
        HandyInventoryUtil.setButton(ConfigUtil.REFRESH_CONFIG, inventory, "back");
        HandyInventoryUtil.setButton(ConfigUtil.REFRESH_CONFIG, inventory, "point", this.replaceMap(player, "point", guildName));
        HandyInventoryUtil.setButton(ConfigUtil.REFRESH_CONFIG, inventory, "vault", this.replaceMap(player, "vault", guildName));
    }

    private Map<String, String> replaceMap(Player player, String type, String guildName) {
        int money;
        HashMap<String, String> map = MapUtil.newHashMapWithExpectedSize(5);
        String yes = BaseUtil.getMsgNotColor("clickPay");
        String button = BaseUtil.getMsgNotColor("noBalance");
        int price = ConfigUtil.REFRESH_CONFIG.getInt(type + ".price");
        if ("point".equals(type)) {
            int playerPoints;
            money = playerPoints = PlayerPointsUtil.getPlayerPoints(player);
            if (playerPoints >= price) {
                button = yes;
            }
        } else {
            double playerVault = VaultUtil.getPlayerVault(player);
            money = (int)playerVault;
            if (playerVault >= (double)price) {
                button = yes;
            }
        }
        map.put("price", String.valueOf(price));
        map.put("guild_name", guildName);
        map.put("money", Integer.toString(money));
        map.put("button", button);
        int taskRefresh = TaskPlayerService.getInstance().findTaskRefresh(player.getUniqueId(), DateUtil.getToday());
        int refreshNumber = HandyPermissionUtil.getIntNumber(player, ConfigUtil.REFRESH_CONFIG, "refreshNumber");
        map.put("number", String.valueOf(refreshNumber - taskRefresh));
        return map;
    }
}

