/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertask.inventory;

import com.handy.playertask.constants.GuiTypeEnum;
import com.handy.playertask.entity.TaskList;
import com.handy.playertask.entity.TaskNpc;
import com.handy.playertask.hook.PlaceholderApiUtil;
import com.handy.playertask.lib.core.MapUtil;
import com.handy.playertask.lib.core.StrUtil;
import com.handy.playertask.lib.db.enter.Page;
import com.handy.playertask.lib.inventory.HandyInventory;
import com.handy.playertask.lib.inventory.HandyInventoryUtil;
import com.handy.playertask.lib.util.BaseUtil;
import com.handy.playertask.lib.util.ItemStackUtil;
import com.handy.playertask.service.TaskListService;
import com.handy.playertask.service.TaskNpcService;
import com.handy.playertask.util.ConfigUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ViewNpcGui {
    private static final ViewNpcGui INSTANCE = new ViewNpcGui();

    private ViewNpcGui() {
    }

    public static ViewNpcGui getInstance() {
        return INSTANCE;
    }

    public Inventory createGui(Player player) {
        String title = ConfigUtil.NPC_CONFIG.getString("viewTitle", "");
        title = PlaceholderApiUtil.set(player, title);
        int size = ConfigUtil.NPC_CONFIG.getInt("viewSize", 54);
        HandyInventory handyInventory = new HandyInventory(GuiTypeEnum.VIEW_NPC.getType(), title, size);
        handyInventory.setPlayer(player);
        this.setInventoryDate(handyInventory);
        return handyInventory.getInventory();
    }

    public void setInventoryDate(HandyInventory handyInventory) {
        handyInventory.setGuiType(GuiTypeEnum.VIEW_NPC.getType());
        HandyInventoryUtil.refreshInventory(handyInventory.getInventory());
        this.setDate(handyInventory);
        this.setFunctionMenu(handyInventory);
    }

    public void setDate(HandyInventory handyInventory) {
        Inventory inventory = handyInventory.getInventory();
        Map<Integer, Integer> map = handyInventory.getIntMap();
        List<Integer> indexList = StrUtil.strToIntList(ConfigUtil.NPC_CONFIG.getString("view.index"));
        handyInventory.setPageSize(indexList.size());
        Page<TaskNpc> page = TaskNpcService.getInstance().page(handyInventory.getPageNum(), handyInventory.getPageSize());
        handyInventory.setPageCount(page.getTotal());
        if (page.getTotal() < 1) {
            return;
        }
        int i = 0;
        String name = ConfigUtil.NPC_CONFIG.getString("view.name", "");
        String material = ConfigUtil.NPC_CONFIG.getString("view.material", "PLAYER_HEAD");
        List taskLore = ConfigUtil.NPC_CONFIG.getStringList("view.lore");
        for (TaskNpc taskNpc : page.getRecords()) {
            ItemStack itemStack = ItemStackUtil.getItemStack(material);
            ItemMeta itemMeta = ItemStackUtil.getItemMeta(itemStack);
            String displayName = StrUtil.replace(name, "id", taskNpc.getId().toString());
            displayName = StrUtil.replace(displayName, "taskName", taskNpc.getTaskName());
            itemMeta.setDisplayName(BaseUtil.replaceChatColor(displayName));
            List<String> loreList = ItemStackUtil.loreReplaceMap(taskLore, this.getReplaceLoreMap(taskNpc));
            itemMeta.setLore(BaseUtil.replaceChatColor(loreList));
            itemStack.setItemMeta(itemMeta);
            Integer index = indexList.get(i++);
            inventory.setItem(index.intValue(), itemStack);
            map.put(index, taskNpc.getId());
        }
    }

    private void setFunctionMenu(HandyInventory handyInventory) {
        Inventory inventory = handyInventory.getInventory();
        Map<String, String> replacePageMap = HandyInventoryUtil.replacePageMap(handyInventory);
        HandyInventoryUtil.setButton(ConfigUtil.NPC_CONFIG, inventory, "nextPage", replacePageMap);
        HandyInventoryUtil.setButton(ConfigUtil.NPC_CONFIG, inventory, "previousPage", replacePageMap);
    }

    private Map<String, String> getReplaceLoreMap(TaskNpc taskNpc) {
        HashMap<String, String> map = MapUtil.newHashMapWithExpectedSize(8);
        map.put("id", taskNpc.getId().toString());
        map.put("taskId", taskNpc.getTaskId().toString());
        map.put("parentName", BaseUtil.getMsgNotColor("none"));
        if (taskNpc.getParentId() != null && taskNpc.getParentId() != 0) {
            Optional<TaskList> parentTaskListOptional = TaskListService.getInstance().findById(taskNpc.getParentId());
            parentTaskListOptional.ifPresent(taskList -> map.put("parentName", BaseUtil.replaceChatColor(taskList.getTaskName())));
        }
        map.put("parentId", taskNpc.getParentId() != null && taskNpc.getParentId() != 0 ? taskNpc.getParentId().toString() : BaseUtil.getMsgNotColor("none"));
        map.put("npcId", taskNpc.getNpcId().toString());
        map.put("isEver", BaseUtil.getMsgNotColor(taskNpc.getIsEver() == 1 ? "isEverYes" : "isEverNo"));
        map.put("number", taskNpc.getNumber().toString());
        map.put("cd", taskNpc.getCd() + BaseUtil.getMsgNotColor("second"));
        return map;
    }
}

