/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertask.inventory;

import com.handy.playertask.constants.GuiTypeEnum;
import com.handy.playertask.constants.ShopTypeEnum;
import com.handy.playertask.entity.TaskShop;
import com.handy.playertask.hook.PlaceholderApiUtil;
import com.handy.playertask.lib.core.CollUtil;
import com.handy.playertask.lib.core.MapUtil;
import com.handy.playertask.lib.core.StrUtil;
import com.handy.playertask.lib.db.enter.Page;
import com.handy.playertask.lib.inventory.HandyInventory;
import com.handy.playertask.lib.inventory.HandyInventoryUtil;
import com.handy.playertask.lib.util.BaseUtil;
import com.handy.playertask.lib.util.ItemStackUtil;
import com.handy.playertask.service.TaskShopService;
import com.handy.playertask.util.ConfigUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ViewShopGui {
    private static final ViewShopGui INSTANCE = new ViewShopGui();

    private ViewShopGui() {
    }

    public static ViewShopGui getInstance() {
        return INSTANCE;
    }

    public Inventory createGui(Player player) {
        String title = ConfigUtil.SHOP_CONFIG.getString("viewTitle", "");
        title = PlaceholderApiUtil.set(player, title);
        int size = ConfigUtil.SHOP_CONFIG.getInt("size", 54);
        HandyInventory handyInventory = new HandyInventory(GuiTypeEnum.VIEW_SHOP.getType(), title, size);
        handyInventory.setPlayer(player);
        this.setInventoryDate(handyInventory);
        return handyInventory.getInventory();
    }

    public void setInventoryDate(HandyInventory handyInventory) {
        handyInventory.setGuiType(GuiTypeEnum.VIEW_SHOP.getType());
        HandyInventoryUtil.refreshInventory(handyInventory.getInventory());
        this.setDate(handyInventory);
        this.setFunctionMenu(handyInventory);
    }

    public void setDate(HandyInventory handyInventory) {
        Map<Integer, Integer> map = handyInventory.getIntMap();
        Inventory inventory = handyInventory.getInventory();
        Player player = handyInventory.getPlayer();
        List<Integer> indexList = StrUtil.strToIntList(ConfigUtil.SHOP_CONFIG.getString("view.index"));
        handyInventory.setPageSize(indexList.size());
        Page<TaskShop> page = TaskShopService.getInstance().page(handyInventory.getPageNum(), handyInventory.getPageSize());
        handyInventory.setPageCount(page.getTotal());
        if (page.getTotal() < 1) {
            return;
        }
        List shopLoreList = ConfigUtil.SHOP_CONFIG.getStringList("view.viewLore");
        int i = 0;
        for (TaskShop taskShop : page.getRecords()) {
            ItemStack itemStack = ItemStackUtil.itemStackDeserialize(taskShop.getItemStack(), Material.STONE);
            ItemMeta itemMeta = ItemStackUtil.getItemMeta(itemStack);
            ArrayList<String> loreList = new ArrayList<String>();
            if (CollUtil.isNotEmpty(itemMeta.getLore())) {
                loreList.addAll(itemMeta.getLore());
            }
            loreList.addAll(ItemStackUtil.loreReplaceMap(shopLoreList, this.replaceMap(taskShop)));
            itemMeta.setLore(BaseUtil.replaceChatColor(loreList));
            itemStack.setItemMeta(itemMeta);
            Integer index = indexList.get(i++);
            inventory.setItem(index.intValue(), itemStack);
            map.put(index, taskShop.getId());
        }
    }

    private void setFunctionMenu(HandyInventory handyInventory) {
        Inventory inventory = handyInventory.getInventory();
        Map<String, String> replacePageMap = HandyInventoryUtil.replacePageMap(handyInventory);
        HandyInventoryUtil.setButton(ConfigUtil.SHOP_CONFIG, inventory, "nextPage", replacePageMap);
        HandyInventoryUtil.setButton(ConfigUtil.SHOP_CONFIG, inventory, "previousPage", replacePageMap);
        HandyInventoryUtil.setButton(ConfigUtil.SHOP_CONFIG, inventory, "back");
        HandyInventoryUtil.setButton(ConfigUtil.SHOP_CONFIG, inventory, "pane");
    }

    private Map<String, String> replaceMap(TaskShop taskShop) {
        HashMap<String, String> map = MapUtil.newHashMapWithExpectedSize(3);
        map.put("id", taskShop.getId().toString());
        map.put("price", taskShop.getAmount().toString());
        map.put("num", ShopTypeEnum.getTypeName(taskShop.getType()));
        return map;
    }
}

