/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertask.lib.command;

import com.handy.playertask.lib.command.HandySubCommandParam;
import com.handy.playertask.lib.command.IHandyCommandEvent;
import com.handy.playertask.lib.core.CollUtil;
import com.handy.playertask.lib.core.LockUtil;
import com.handy.playertask.lib.core.SignUtil;
import com.handy.playertask.lib.core.StrUtil;
import com.handy.playertask.lib.exception.HandyException;
import com.handy.playertask.lib.expand.adapter.HandySchedulerUtil;
import com.handy.playertask.lib.util.MessageUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public class HandyCommandFactory {
    private static final HandyCommandFactory INSTANCE = new HandyCommandFactory();
    private static final Map<String, IHandyCommandEvent> HANDY_COMMAND_EVENT_MAP = new HashMap<String, IHandyCommandEvent>();
    private static Map<String, Map<String, HandySubCommandParam>> SUB_COMMAND_MAP = new HashMap<String, Map<String, HandySubCommandParam>>();

    private HandyCommandFactory() {
    }

    public static HandyCommandFactory getInstance() {
        return INSTANCE;
    }

    public void init(List<IHandyCommandEvent> handyCommandEvents) {
        if (CollUtil.isEmpty(handyCommandEvents)) {
            return;
        }
        for (IHandyCommandEvent handyCommandEvent : handyCommandEvents) {
            HANDY_COMMAND_EVENT_MAP.put(handyCommandEvent.command().toLowerCase(), handyCommandEvent);
        }
    }

    public void initSubCommand(Map<String, Map<String, HandySubCommandParam>> subCommandMap) {
        SUB_COMMAND_MAP = subCommandMap;
    }

    public boolean onSubCommand(String command, CommandSender sender, Command cmd, String label, String[] args, String noPermission) {
        if (args.length == 0) {
            return false;
        }
        Map<String, HandySubCommandParam> subCommandParamMap = SUB_COMMAND_MAP.get(command.toLowerCase());
        if (subCommandParamMap == null) {
            return false;
        }
        HandySubCommandParam param = subCommandParamMap.get(args[0].toLowerCase());
        if (param == null) {
            return false;
        }
        if (StrUtil.isNotEmpty(param.getPermission()) && !sender.hasPermission(param.getPermission())) {
            MessageUtil.sendMessage(sender, StrUtil.replace(noPermission, "permission", param.getPermission()));
            return true;
        }
        if (SignUtil.isCommandPermission(args[0])) {
            MessageUtil.sendConsoleMessage(ChatColor.GREEN + "\u672a\u68c0\u6d4b\u5230\u6fc0\u6d3b\u7801,\u8bf7\u8054\u7cfb\u4f5c\u8005\u8d2d\u4e70QQ:956812056");
            return true;
        }
        if (param.isAsync()) {
            this.onAsyncSubCommandExecution(param, sender, cmd, label, args);
            return true;
        }
        this.onSubCommandExecution(param, sender, cmd, label, args);
        return true;
    }

    private void onAsyncSubCommandExecution(HandySubCommandParam param, CommandSender sender, Command cmd, String label, String[] args) {
        HandySchedulerUtil.runTaskAsynchronously(() -> this.onSubCommandExecution(param, sender, cmd, label, args));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSubCommandExecution(HandySubCommandParam param, CommandSender sender, Command cmd, String label, String[] args) {
        String name = sender.getName();
        try {
            LockUtil.reentrantLock(name);
            param.getMethod().invoke(param.getAClass().newInstance(), sender, cmd, label, args);
        }
        catch (HandyException exception) {
            MessageUtil.sendMessage(sender, exception.getMessage());
        }
        finally {
            LockUtil.unReentrantLock(name);
        }
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args, String noPermission) {
        if (args.length == 0) {
            return false;
        }
        IHandyCommandEvent handyCommandEvent = HANDY_COMMAND_EVENT_MAP.get(args[0].toLowerCase());
        if (handyCommandEvent == null) {
            return false;
        }
        if (StrUtil.isNotEmpty(handyCommandEvent.permission()) && !sender.hasPermission(handyCommandEvent.permission())) {
            MessageUtil.sendMessage(sender, StrUtil.replace(noPermission, "permission", handyCommandEvent.permission()));
            return true;
        }
        if (SignUtil.isCommandPermission(args[0])) {
            MessageUtil.sendConsoleMessage(ChatColor.GREEN + "\u672a\u68c0\u6d4b\u5230\u6fc0\u6d3b\u7801,\u8bf7\u8054\u7cfb\u4f5c\u8005\u8d2d\u4e70QQ:956812056");
            return true;
        }
        if (handyCommandEvent.isAsync()) {
            this.onAsyncCommand(handyCommandEvent, sender, cmd, label, args);
            return true;
        }
        this.onCommandExecution(handyCommandEvent, sender, cmd, label, args);
        return true;
    }

    private void onAsyncCommand(IHandyCommandEvent handyCommandEvent, CommandSender sender, Command cmd, String label, String[] args) {
        HandySchedulerUtil.runTaskAsynchronously(() -> this.onCommandExecution(handyCommandEvent, sender, cmd, label, args));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onCommandExecution(IHandyCommandEvent handyCommandEvent, CommandSender sender, Command cmd, String label, String[] args) {
        String name = sender.getName();
        try {
            LockUtil.reentrantLock(name);
            handyCommandEvent.onCommand(sender, cmd, label, args);
        }
        catch (HandyException exception) {
            MessageUtil.sendMessage(sender, exception.getMessage());
        }
        finally {
            LockUtil.unReentrantLock(name);
        }
    }
}

