/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertask.listener;

import com.handy.playertask.entity.TaskNpc;
import com.handy.playertask.inventory.TaskNpcGui;
import com.handy.playertask.lib.annotation.HandyListener;
import com.handy.playertask.lib.expand.adapter.HandySchedulerUtil;
import com.handy.playertask.service.TaskNpcService;
import java.util.Optional;
import net.citizensnpcs.api.event.NPCLeftClickEvent;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.inventory.Inventory;

@HandyListener
public class NpcClickEventListener
implements Listener {
    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onBlockBreak(NPCLeftClickEvent event) {
        HandySchedulerUtil.runTaskAsynchronously(() -> {
            Player player = event.getClicker();
            int npcId = event.getNPC().getId();
            Optional<TaskNpc> npcOptional = TaskNpcService.getInstance().existNpcTask(npcId);
            if (!npcOptional.isPresent()) {
                return;
            }
            Inventory inventory = TaskNpcGui.getInstance().createGui(player, npcId);
            HandySchedulerUtil.runTask(() -> player.openInventory(inventory));
        });
    }
}

