/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertask.listener;

import com.handy.playertask.constants.DemandTypeEnum;
import com.handy.playertask.entity.TaskReel;
import com.handy.playertask.entity.TaskReelPlayerDemand;
import com.handy.playertask.entity.TaskRewards;
import com.handy.playertask.lib.annotation.HandyListener;
import com.handy.playertask.lib.constants.BaseConstants;
import com.handy.playertask.lib.constants.VersionCheckEnum;
import com.handy.playertask.lib.core.CollUtil;
import com.handy.playertask.lib.core.StrUtil;
import com.handy.playertask.lib.util.BaseUtil;
import com.handy.playertask.lib.util.ItemStackUtil;
import com.handy.playertask.lib.util.MessageUtil;
import com.handy.playertask.reward.RewardStrategy;
import com.handy.playertask.service.TaskReelPlayerDemandService;
import com.handy.playertask.service.TaskReelService;
import com.handy.playertask.service.TaskRewardsService;
import com.handy.playertask.util.ConfigUtil;
import com.handy.playertask.util.TaskUtil;
import java.util.List;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

@HandyListener
public class TaskReelListener
implements Listener {
    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        ItemStack item = event.getItem();
        if (item == null) {
            return;
        }
        int playerReelId = this.check(event);
        if (playerReelId == 0) {
            return;
        }
        Player player = event.getPlayer();
        Optional<TaskReel> taskReelOptional = TaskReelService.getInstance().findByPlayerReelIdAndPlayer(playerReelId, player.getUniqueId());
        if (!taskReelOptional.isPresent()) {
            return;
        }
        TaskReel taskReel = taskReelOptional.get();
        if (taskReel.getStatus().booleanValue()) {
            return;
        }
        List<TaskReelPlayerDemand> taskReelPlayerDemandList = TaskReelPlayerDemandService.getInstance().findByReelId(taskReel.getId());
        boolean submitRst = this.submitTask(player, taskReelPlayerDemandList);
        int num = 0;
        for (TaskReelPlayerDemand taskPlayerDemand : taskReelPlayerDemandList) {
            if (taskPlayerDemand.getCompletionAmount() < taskPlayerDemand.getAmount()) continue;
            ++num;
        }
        if (num != taskReelPlayerDemandList.size()) {
            MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("notTaskFinish"));
            if (submitRst) {
                taskReel.setTaskReelPlayerDemands(taskReelPlayerDemandList);
                ItemStack taskItemStack = TaskUtil.createTaskItemStack(taskReel, player);
                item.setItemMeta(taskItemStack.getItemMeta());
            }
            return;
        }
        ItemStackUtil.removeItem(player.getInventory(), item, 1);
        TaskReelService.getInstance().updateStatus(playerReelId, true);
        List<TaskRewards> taskRewardsList = TaskRewardsService.getInstance().findByIds(StrUtil.strToIntList(taskReelOptional.get().getTaskRewards()));
        RewardStrategy.getInstance().reward(player, taskRewardsList);
        MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("taskFinish"));
    }

    private int check(PlayerInteractEvent event) {
        ItemStack item = event.getItem();
        if (item == null || item.getAmount() > 1 || item.getItemMeta() == null) {
            return 0;
        }
        Material material = ItemStackUtil.getMaterial(ConfigUtil.REEL_CONFIG.getString("reel.material", Material.PAPER.name()));
        if (!material.equals((Object)item.getType())) {
            return 0;
        }
        ItemMeta itemMeta = item.getItemMeta();
        if (StrUtil.isEmpty(itemMeta.getDisplayName()) || CollUtil.isEmpty(itemMeta.getLore())) {
            return 0;
        }
        if (BaseConstants.VERSION_ID > VersionCheckEnum.V_1_8.getVersionId() && !EquipmentSlot.HAND.equals((Object)event.getHand())) {
            return 0;
        }
        return itemMeta.getEnchantLevel(Enchantment.LURE);
    }

    private boolean submitTask(Player player, List<TaskReelPlayerDemand> taskPlayerDemands) {
        boolean returnRst = false;
        if (CollUtil.isEmpty(taskPlayerDemands)) {
            return false;
        }
        for (TaskReelPlayerDemand taskPlayerDemand : taskPlayerDemands) {
            ItemStack itemStack;
            if (!DemandTypeEnum.SUBMIT.getType().equals(taskPlayerDemand.getType()) || taskPlayerDemand.getCompletionAmount() >= taskPlayerDemand.getAmount() || (itemStack = ItemStackUtil.itemStackDeserialize(taskPlayerDemand.getItemStack())).getItemMeta() == null) continue;
            String displayName = BaseUtil.getDisplayName(itemStack);
            Boolean removeItemRst = ItemStackUtil.removeItem(player.getInventory(), itemStack, taskPlayerDemand.getAmount(), false);
            if (!removeItemRst.booleanValue()) {
                String submitFailureMsg = BaseUtil.getMsgNotColor("submitFailureMsg", "").replace("${item}", displayName);
                MessageUtil.sendMessage(player, submitFailureMsg);
                continue;
            }
            boolean rst = TaskReelPlayerDemandService.getInstance().updateCompletionAmount(taskPlayerDemand.getId(), taskPlayerDemand.getAmount());
            if (!rst) continue;
            taskPlayerDemand.setCompletionAmount(taskPlayerDemand.getCompletionAmount() + taskPlayerDemand.getAmount());
            String submitSucceedMsg = BaseUtil.getMsgNotColor("submitSucceedMsg", "").replace("${item}", displayName);
            MessageUtil.sendMessage(player, submitSucceedMsg);
            returnRst = true;
        }
        return returnRst;
    }
}

