/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertask.listener.gui;

import com.handy.playertask.constants.BaseTaskConstants;
import com.handy.playertask.constants.GuiTypeEnum;
import com.handy.playertask.constants.RarityEnum;
import com.handy.playertask.constants.RewardTypeEnum;
import com.handy.playertask.entity.TaskList;
import com.handy.playertask.inventory.CreateRewardsGui;
import com.handy.playertask.lib.core.CollUtil;
import com.handy.playertask.lib.core.StrUtil;
import com.handy.playertask.lib.inventory.HandyInventory;
import com.handy.playertask.lib.inventory.HandyInventoryUtil;
import com.handy.playertask.lib.inventory.IHandyClickEvent;
import com.handy.playertask.lib.util.BaseUtil;
import com.handy.playertask.lib.util.MessageUtil;
import com.handy.playertask.service.TaskListService;
import com.handy.playertask.util.ConfigUtil;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;

public class CreateRewardsClickEvent
implements IHandyClickEvent {
    @Override
    public String guiType() {
        return GuiTypeEnum.CREATE_REWARDS.getType();
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void rawSlotClick(HandyInventory handyInventory, InventoryClickEvent event) {
        int rawSlot = event.getRawSlot();
        Integer pageNum = handyInventory.getPageNum();
        Integer pageCount = handyInventory.getPageCount();
        Player player = handyInventory.getPlayer();
        Map<Integer, Integer> map = handyInventory.getIntMap();
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.REWARDS_CONFIG, "previousPage")) {
            if (pageNum > 1) {
                handyInventory.setPageNum(handyInventory.getPageNum() - 1);
                CreateRewardsGui.getInstance().setInventoryDate(handyInventory);
            }
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.REWARDS_CONFIG, "nextPage")) {
            if (pageNum + 1 <= pageCount) {
                handyInventory.setPageNum(handyInventory.getPageNum() + 1);
                CreateRewardsGui.getInstance().setInventoryDate(handyInventory);
            }
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.REWARDS_CONFIG, "back")) {
            BaseTaskConstants.TASK_LIST_MAP.remove(player.getUniqueId());
            handyInventory.syncClose();
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.REWARDS_CONFIG, "search")) {
            handyInventory.setSearchType(RewardTypeEnum.getNextEnum(handyInventory.getSearchType()).getType());
            CreateRewardsGui.getInstance().setInventoryDate(handyInventory);
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.REWARDS_CONFIG, "step")) {
            this.finish(player);
            handyInventory.syncClose();
            return;
        }
        Integer taskRewardId = map.get(event.getRawSlot());
        if (taskRewardId == null) {
            return;
        }
        TaskList taskList = BaseTaskConstants.TASK_LIST_MAP.get(player.getUniqueId());
        if (taskList == null) {
            return;
        }
        if (StrUtil.isEmpty(taskList.getTaskRewards())) {
            taskList.setTaskRewards(String.valueOf(taskRewardId));
        } else {
            List<Integer> taskRewardIds = StrUtil.strToIntList(taskList.getTaskRewards());
            if (taskRewardIds.contains(taskRewardId)) {
                taskRewardIds.remove(taskRewardId);
            } else {
                taskRewardIds.add(taskRewardId);
            }
            taskList.setTaskRewards(CollUtil.listToStr(taskRewardIds));
        }
        CreateRewardsGui.getInstance().setInventoryDate(handyInventory);
    }

    private void finish(Player player) {
        TaskList taskList = BaseTaskConstants.TASK_LIST_MAP.get(player.getUniqueId());
        int taskId = TaskListService.getInstance().add(taskList);
        if (taskId < 1) {
            MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("createError"));
            return;
        }
        String createSuccess = BaseUtil.getMsgNotColor("createSuccess", "");
        createSuccess = StrUtil.replace(createSuccess, "taskName", taskList.getTaskName());
        createSuccess = StrUtil.replace(createSuccess, "rarity", RarityEnum.getEnumName(taskList.getRarity()));
        createSuccess = StrUtil.replace(createSuccess, "taskId", String.valueOf(taskId));
        MessageUtil.sendMessage(player, createSuccess);
        BaseTaskConstants.TASK_LIST_MAP.remove(player.getUniqueId());
    }
}

