/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertask.listener.gui;

import com.handy.playertask.constants.GuiTypeEnum;
import com.handy.playertask.hook.PlayerPointsUtil;
import com.handy.playertask.hook.VaultUtil;
import com.handy.playertask.inventory.OpenGui;
import com.handy.playertask.lib.core.DateUtil;
import com.handy.playertask.lib.inventory.HandyInventory;
import com.handy.playertask.lib.inventory.HandyInventoryUtil;
import com.handy.playertask.lib.inventory.IHandyClickEvent;
import com.handy.playertask.lib.util.BaseUtil;
import com.handy.playertask.lib.util.HandyPermissionUtil;
import com.handy.playertask.lib.util.MessageUtil;
import com.handy.playertask.service.TaskPlayerService;
import com.handy.playertask.util.ConfigUtil;
import com.handy.playertask.util.TaskJob;
import java.util.Date;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;

public class RefreshClickEvent
implements IHandyClickEvent {
    @Override
    public String guiType() {
        return GuiTypeEnum.REFRESH.getType();
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void rawSlotClick(HandyInventory handyInventory, InventoryClickEvent event) {
        int refreshNumber;
        int doneStatusTask;
        int rawSlot = event.getRawSlot();
        Player player = handyInventory.getPlayer();
        Date today = DateUtil.getToday();
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.REFRESH_CONFIG, "back")) {
            Inventory inventory = OpenGui.getInstance().createGui(player, handyInventory.getId());
            handyInventory.syncOpen(inventory);
            return;
        }
        if (!HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.REFRESH_CONFIG, "point") && !HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.REFRESH_CONFIG, "vault")) {
            return;
        }
        if (ConfigUtil.REFRESH_CONFIG.getBoolean("doneRefresh", true) && (doneStatusTask = TaskPlayerService.getInstance().findByDoneStatus(player.getUniqueId(), today)) > 0) {
            MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("noRefresh"));
            return;
        }
        int taskRefresh = TaskPlayerService.getInstance().findTaskRefresh(player.getUniqueId(), today);
        if (taskRefresh >= (refreshNumber = HandyPermissionUtil.getIntNumber(player, ConfigUtil.REFRESH_CONFIG, "refreshNumber"))) {
            MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("noRefreshNumber"));
            return;
        }
        boolean rst = false;
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.REFRESH_CONFIG, "point")) {
            int pointPrice = ConfigUtil.REFRESH_CONFIG.getInt("point.price");
            rst = PlayerPointsUtil.buy(player, pointPrice);
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.REFRESH_CONFIG, "vault")) {
            int vaultPrice = ConfigUtil.REFRESH_CONFIG.getInt("vault.price");
            rst = VaultUtil.buy(player, vaultPrice);
        }
        if (!rst) {
            MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("notMoneyFailureMsg"));
            return;
        }
        TaskJob.getInstance().refreshPlayerTask(player);
        Inventory inventory = OpenGui.getInstance().createGui(player, 1);
        handyInventory.syncOpen(inventory);
    }
}

