/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertask.listener.gui;

import com.handy.playertask.constants.GuiTypeEnum;
import com.handy.playertask.constants.ShopTypeEnum;
import com.handy.playertask.entity.TaskShop;
import com.handy.playertask.inventory.OpenGui;
import com.handy.playertask.inventory.ShopGui;
import com.handy.playertask.lib.inventory.HandyInventory;
import com.handy.playertask.lib.inventory.HandyInventoryUtil;
import com.handy.playertask.lib.inventory.IHandyClickEvent;
import com.handy.playertask.lib.util.BaseUtil;
import com.handy.playertask.lib.util.ItemStackUtil;
import com.handy.playertask.lib.util.MessageUtil;
import com.handy.playertask.service.TaskCoinService;
import com.handy.playertask.service.TaskShopService;
import com.handy.playertask.util.ConfigUtil;
import java.util.Map;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class ShopClickEvent
implements IHandyClickEvent {
    @Override
    public String guiType() {
        return GuiTypeEnum.SHOP.getType();
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void rawSlotClick(HandyInventory handyInventory, InventoryClickEvent event) {
        int rawSlot = event.getRawSlot();
        Integer pageNum = handyInventory.getPageNum();
        Integer pageCount = handyInventory.getPageCount();
        Player player = handyInventory.getPlayer();
        Map<Integer, Integer> map = handyInventory.getIntMap();
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.SHOP_CONFIG, "previousPage")) {
            if (pageNum > 1) {
                handyInventory.setPageNum(handyInventory.getPageNum() - 1);
                ShopGui.getInstance().setInventoryDate(handyInventory);
            }
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.SHOP_CONFIG, "nextPage")) {
            if (pageNum + 1 <= pageCount) {
                handyInventory.setPageNum(handyInventory.getPageNum() + 1);
                ShopGui.getInstance().setInventoryDate(handyInventory);
            }
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.SHOP_CONFIG, "back")) {
            handyInventory.syncClose();
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.SHOP_CONFIG, "task")) {
            Inventory inventory = OpenGui.getInstance().createGui(player);
            handyInventory.syncOpen(inventory);
            return;
        }
        Integer taskShopId = map.get(event.getRawSlot());
        if (taskShopId == null) {
            return;
        }
        this.buy(taskShopId, player);
        ShopGui.getInstance().setInventoryDate(handyInventory);
    }

    private void buy(Integer taskShopId, Player player) {
        Optional<TaskShop> taskShopOptional = TaskShopService.getInstance().findById(taskShopId);
        if (!taskShopOptional.isPresent()) {
            return;
        }
        TaskShop taskShop = taskShopOptional.get();
        boolean rst = TaskCoinService.getInstance().subtractCoin(player.getUniqueId(), taskShop.getAmount());
        MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor(rst ? "buySucceed" : "noBalance"));
        if (rst) {
            ItemStack itemStack = ItemStackUtil.itemStackDeserialize(taskShop.getItemStack(), Material.STONE);
            ItemStackUtil.addItem(player.getInventory(), itemStack, itemStack.getAmount());
            if (ShopTypeEnum.ONCE.getType().equals(taskShop.getType())) {
                TaskShopService.getInstance().deleteById(taskShopId);
            }
        }
    }
}

