/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertask.listener.gui;

import com.handy.playertask.constants.DemandTypeEnum;
import com.handy.playertask.constants.GuiTypeEnum;
import com.handy.playertask.entity.TaskDemand;
import com.handy.playertask.entity.TaskList;
import com.handy.playertask.entity.TaskNpc;
import com.handy.playertask.entity.TaskNpcPlayer;
import com.handy.playertask.entity.TaskNpcPlayerDemand;
import com.handy.playertask.inventory.TaskNpcGui;
import com.handy.playertask.lib.core.CollUtil;
import com.handy.playertask.lib.core.StrUtil;
import com.handy.playertask.lib.expand.adapter.HandySchedulerUtil;
import com.handy.playertask.lib.inventory.HandyInventory;
import com.handy.playertask.lib.inventory.HandyInventoryUtil;
import com.handy.playertask.lib.inventory.IHandyClickEvent;
import com.handy.playertask.lib.util.BaseUtil;
import com.handy.playertask.lib.util.ItemStackUtil;
import com.handy.playertask.lib.util.MessageUtil;
import com.handy.playertask.reward.RewardStrategy;
import com.handy.playertask.reward.impl.CommandServiceImpl;
import com.handy.playertask.service.TaskDemandService;
import com.handy.playertask.service.TaskListService;
import com.handy.playertask.service.TaskNpcPlayerDemandService;
import com.handy.playertask.service.TaskNpcPlayerService;
import com.handy.playertask.service.TaskNpcService;
import com.handy.playertask.util.ConfigUtil;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class TaskNpcClickEvent
implements IHandyClickEvent {
    @Override
    public String guiType() {
        return GuiTypeEnum.TASK_NPC.getType();
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void rawSlotClick(HandyInventory handyInventory, InventoryClickEvent event) {
        boolean rst;
        int rawSlot = event.getRawSlot();
        Integer pageNum = handyInventory.getPageNum();
        Integer pageCount = handyInventory.getPageCount();
        Player player = handyInventory.getPlayer();
        Map<Integer, Integer> map = handyInventory.getIntMap();
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.NPC_CONFIG, "previousPage")) {
            if (pageNum > 1) {
                handyInventory.setPageNum(handyInventory.getPageNum() - 1);
                TaskNpcGui.getInstance().setInventoryDate(handyInventory);
            }
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.NPC_CONFIG, "nextPage")) {
            if (pageNum + 1 <= pageCount) {
                handyInventory.setPageNum(handyInventory.getPageNum() + 1);
                TaskNpcGui.getInstance().setInventoryDate(handyInventory);
            }
            return;
        }
        Map<Integer, String> custom = HandyInventoryUtil.getCustomButton(ConfigUtil.NPC_CONFIG, "custom");
        String command = custom.get(rawSlot);
        if (StrUtil.isNotEmpty(command)) {
            if ("[CLOSE]".equalsIgnoreCase(command)) {
                handyInventory.syncClose();
                return;
            }
            HandySchedulerUtil.runTask(() -> player.chat("/" + command.trim()));
            return;
        }
        Integer npcId = map.get(event.getRawSlot());
        if (npcId == null) {
            return;
        }
        Optional<TaskNpc> taskNpcOptional = TaskNpcService.getInstance().findById(npcId);
        if (taskNpcOptional.isPresent() && (rst = this.playerTask(player, taskNpcOptional.get()))) {
            TaskNpcGui.getInstance().setInventoryDate(handyInventory);
        }
    }

    private boolean playerTask(Player player, TaskNpc taskNpc) {
        Optional<TaskList> taskListOptional = TaskListService.getInstance().findById(taskNpc.getTaskId());
        if (!taskListOptional.isPresent()) {
            return false;
        }
        TaskList taskList = taskListOptional.get();
        Optional<TaskNpcPlayer> taskNpcPlayerOpt = TaskNpcPlayerService.getInstance().findByPlayerAndTaskNpcId(player.getUniqueId(), taskNpc.getId());
        if (!taskNpcPlayerOpt.isPresent()) {
            return this.addPlayerTask(player, taskNpc, taskList, null);
        }
        TaskNpcPlayer taskNpcPlayer = taskNpcPlayerOpt.get();
        if (!taskNpcPlayer.getStatus().booleanValue()) {
            return this.doneTask(player, taskNpcPlayer);
        }
        boolean next = true;
        if (taskNpc.getIsEver() != 1 && taskNpcPlayer.getNumber() >= taskNpc.getNumber()) {
            MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("taskFinish"));
            next = false;
        }
        long time = (long)taskNpc.getCd().intValue() - (System.currentTimeMillis() - taskNpcPlayer.getTaskDate().getTime()) / 1000L;
        if (next && taskNpcPlayer.getStatus().booleanValue() && time > 0L) {
            String timeMsg = BaseUtil.getMsgNotColor("timeMsg");
            timeMsg = StrUtil.replace(timeMsg, "time", String.valueOf(time));
            MessageUtil.sendMessage(player, timeMsg);
            next = false;
        }
        if (next) {
            return this.addPlayerTask(player, taskNpc, taskList, taskNpcPlayer);
        }
        return false;
    }

    private boolean addPlayerTask(Player player, TaskNpc taskNpc, TaskList taskList, TaskNpcPlayer taskNpcPlayerEnter) {
        List<TaskDemand> taskDemandList;
        Optional<TaskList> taskListOptional;
        Optional<TaskNpcPlayer> taskNpcPlayerOptional;
        if (taskNpc.getParentId() != null && taskNpc.getParentId() != 0 && !(taskNpcPlayerOptional = TaskNpcPlayerService.getInstance().existTask(player.getUniqueId(), taskNpc.getParentId())).isPresent() && (taskListOptional = TaskListService.getInstance().findById(taskNpc.getParentId())).isPresent()) {
            String parentTaskMsg = BaseUtil.getMsgNotColor("parentTaskMsg");
            parentTaskMsg = StrUtil.replace(parentTaskMsg, "task", taskListOptional.get().getTaskName());
            MessageUtil.sendMessage(player, parentTaskMsg);
            return false;
        }
        int number = 1;
        if (taskNpcPlayerEnter != null) {
            number = taskNpcPlayerEnter.getNumber() + 1;
            TaskNpcPlayerService.getInstance().deleteById(taskNpcPlayerEnter.getId());
        }
        TaskNpcPlayer taskNpcPlayer = new TaskNpcPlayer();
        taskNpcPlayer.setPlayerName(player.getName());
        taskNpcPlayer.setPlayerUuid(player.getUniqueId().toString());
        taskNpcPlayer.setTaskNpcId(taskNpc.getId());
        taskNpcPlayer.setTaskId(taskNpc.getTaskId());
        taskNpcPlayer.setTaskName(taskList.getTaskName());
        taskNpcPlayer.setTaskDemand(taskList.getTaskDemand());
        taskNpcPlayer.setTaskRewards(taskList.getTaskRewards());
        taskNpcPlayer.setNpcId(taskNpc.getNpcId());
        taskNpcPlayer.setTaskDate(new Date());
        taskNpcPlayer.setStatus(false);
        taskNpcPlayer.setNumber(number);
        int id = TaskNpcPlayerService.getInstance().add(taskNpcPlayer);
        if (id > 0 && CollUtil.isNotEmpty(taskDemandList = TaskDemandService.getInstance().findByIds(StrUtil.strToIntList(taskNpcPlayer.getTaskDemand())))) {
            for (TaskDemand taskDemand : taskDemandList) {
                TaskNpcPlayerDemand taskNpcPlayerDemand = new TaskNpcPlayerDemand();
                taskNpcPlayerDemand.setTaskNpcPlayerId(id);
                taskNpcPlayerDemand.setPlayerName(player.getName());
                taskNpcPlayerDemand.setPlayerUuid(player.getUniqueId().toString());
                taskNpcPlayerDemand.setType(taskDemand.getType());
                taskNpcPlayerDemand.setCompletionAmount(0);
                taskNpcPlayerDemand.setAmount(taskDemand.getAmount());
                taskNpcPlayerDemand.setItemStack(taskDemand.getItemStack());
                taskNpcPlayerDemand.setNpcId(taskNpc.getNpcId());
                TaskNpcPlayerDemandService.getInstance().add(taskNpcPlayerDemand);
            }
        }
        this.executeCommand(taskList.getEnableCommand(), player);
        MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor(id > 0 ? "takeSucceedMsg" : "takeFailureMsg"));
        return true;
    }

    private void executeCommand(String command, Player player) {
        if (StrUtil.isEmpty(command)) {
            return;
        }
        int type = 0;
        if (command.contains("[op]")) {
            command = command.replace("[op]", "");
            type = 1;
        }
        if (command.contains("[Console]")) {
            command = command.replace("[Console]", "");
            type = 2;
        }
        CommandServiceImpl.executeCommand(player, command, type);
    }

    public boolean doneTask(Player player, TaskNpcPlayer taskNpcPlayer) {
        if (taskNpcPlayer.getStatus().booleanValue()) {
            MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("isFinish"));
            return false;
        }
        List<TaskNpcPlayerDemand> taskNpcPlayerDemands = taskNpcPlayer.getTaskPlayerDemands();
        if (CollUtil.isEmpty(taskNpcPlayerDemands)) {
            this.taskFinish(player, taskNpcPlayer);
            return true;
        }
        this.submitTask(player, taskNpcPlayer);
        int num = 0;
        for (TaskNpcPlayerDemand taskNpcPlayerDemand : taskNpcPlayerDemands) {
            if (taskNpcPlayerDemand.getCompletionAmount() < taskNpcPlayerDemand.getAmount()) continue;
            ++num;
        }
        if (num == taskNpcPlayerDemands.size()) {
            this.taskFinish(player, taskNpcPlayer);
            return true;
        }
        MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("notTaskFinish"));
        return false;
    }

    private void submitTask(Player player, TaskNpcPlayer taskNpcPlayer) {
        for (TaskNpcPlayerDemand taskNpcPlayerDemand : taskNpcPlayer.getTaskPlayerDemands()) {
            ItemStack itemStack;
            if (!DemandTypeEnum.SUBMIT.getType().equals(taskNpcPlayerDemand.getType()) || taskNpcPlayerDemand.getCompletionAmount() >= taskNpcPlayerDemand.getAmount() || (itemStack = ItemStackUtil.itemStackDeserialize(taskNpcPlayerDemand.getItemStack())).getItemMeta() == null) continue;
            String displayName = BaseUtil.getDisplayName(itemStack);
            PlayerInventory playerInventory = player.getInventory();
            Boolean removeItemRst = ItemStackUtil.removeItem(playerInventory, itemStack, taskNpcPlayerDemand.getAmount());
            if (!removeItemRst.booleanValue()) {
                MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("submitFailureMsg").replace("${item}", displayName));
                continue;
            }
            Boolean rst = TaskNpcPlayerDemandService.getInstance().updateCompletionAmount(taskNpcPlayerDemand.getId(), taskNpcPlayerDemand.getAmount());
            if (!rst.booleanValue()) continue;
            taskNpcPlayerDemand.setCompletionAmount(taskNpcPlayerDemand.getCompletionAmount() + taskNpcPlayerDemand.getAmount());
            MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("submitSucceedMsg").replace("${item}", displayName));
        }
    }

    private void taskFinish(Player player, TaskNpcPlayer taskNpcPlayer) {
        Boolean rst = TaskNpcPlayerService.getInstance().updateStatusById(taskNpcPlayer.getId(), true);
        if (!rst.booleanValue()) {
            MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("taskFinishFailure"));
            return;
        }
        RewardStrategy.getInstance().reward(player, taskNpcPlayer.getTaskRewardsList());
        MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("taskFinish"));
    }
}

