/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertask.listener.gui;

import com.handy.playertask.constants.BaseTaskConstants;
import com.handy.playertask.constants.DemandTypeEnum;
import com.handy.playertask.constants.GuiTypeEnum;
import com.handy.playertask.inventory.ViewDemandGui;
import com.handy.playertask.lib.inventory.HandyInventory;
import com.handy.playertask.lib.inventory.HandyInventoryUtil;
import com.handy.playertask.lib.inventory.IHandyClickEvent;
import com.handy.playertask.service.TaskDemandService;
import com.handy.playertask.util.ConfigUtil;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;

public class ViewDemandClickEvent
implements IHandyClickEvent {
    @Override
    public String guiType() {
        return GuiTypeEnum.VIEW_DEMAND.getType();
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void rawSlotClick(HandyInventory handyInventory, InventoryClickEvent event) {
        int rawSlot = event.getRawSlot();
        Integer pageNum = handyInventory.getPageNum();
        Integer pageCount = handyInventory.getPageCount();
        Player player = handyInventory.getPlayer();
        Map<Integer, Integer> map = handyInventory.getIntMap();
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.DEMAND_CONFIG, "previousPage")) {
            if (pageNum > 1) {
                handyInventory.setPageNum(handyInventory.getPageNum() - 1);
                ViewDemandGui.getInstance().setInventoryDate(handyInventory);
            }
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.DEMAND_CONFIG, "nextPage")) {
            if (pageNum + 1 <= pageCount) {
                handyInventory.setPageNum(handyInventory.getPageNum() + 1);
                ViewDemandGui.getInstance().setInventoryDate(handyInventory);
            }
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.DEMAND_CONFIG, "back")) {
            BaseTaskConstants.TASK_LIST_MAP.remove(player.getUniqueId());
            handyInventory.syncClose();
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.DEMAND_CONFIG, "search")) {
            handyInventory.setSearchType(DemandTypeEnum.getNextEnum(handyInventory.getSearchType()).getType());
            ViewDemandGui.getInstance().setInventoryDate(handyInventory);
            return;
        }
        Integer taskDemandId = map.get(event.getRawSlot());
        if (taskDemandId == null) {
            return;
        }
        TaskDemandService.getInstance().deleteById(taskDemandId);
        ViewDemandGui.getInstance().setInventoryDate(handyInventory);
    }
}

