/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertask.listener.gui;

import com.handy.playertask.constants.BaseTaskConstants;
import com.handy.playertask.constants.GuiTypeEnum;
import com.handy.playertask.constants.RarityEnum;
import com.handy.playertask.constants.TaskTypeEnum;
import com.handy.playertask.inventory.ViewListGui;
import com.handy.playertask.lib.inventory.HandyInventory;
import com.handy.playertask.lib.inventory.HandyInventoryUtil;
import com.handy.playertask.lib.inventory.IHandyClickEvent;
import com.handy.playertask.service.TaskListService;
import com.handy.playertask.util.ConfigUtil;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;

public class ViewListClickEvent
implements IHandyClickEvent {
    @Override
    public String guiType() {
        return GuiTypeEnum.VIEW_LIST.getType();
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void rawSlotClick(HandyInventory handyInventory, InventoryClickEvent event) {
        int rawSlot = event.getRawSlot();
        Integer pageNum = handyInventory.getPageNum();
        Integer pageCount = handyInventory.getPageCount();
        Player player = handyInventory.getPlayer();
        Map<Integer, Integer> map = handyInventory.getIntMap();
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.LIST_CONFIG, "previousPage")) {
            if (pageNum > 1) {
                handyInventory.setPageNum(handyInventory.getPageNum() - 1);
                ViewListGui.getInstance().setInventoryDate(handyInventory);
            }
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.LIST_CONFIG, "nextPage")) {
            if (pageNum + 1 <= pageCount) {
                handyInventory.setPageNum(handyInventory.getPageNum() + 1);
                ViewListGui.getInstance().setInventoryDate(handyInventory);
            }
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.LIST_CONFIG, "back")) {
            BaseTaskConstants.TASK_LIST_MAP.remove(player.getUniqueId());
            handyInventory.syncClose();
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.LIST_CONFIG, "search")) {
            handyInventory.setSearchType(TaskTypeEnum.getNextEnum(handyInventory.getSearchType()).getType());
            ViewListGui.getInstance().setInventoryDate(handyInventory);
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.LIST_CONFIG, "raritySearch")) {
            handyInventory.setObj(RarityEnum.getNextEnum(handyInventory.getObj().toString()).getType());
            ViewListGui.getInstance().setInventoryDate(handyInventory);
            return;
        }
        Integer taskListId = map.get(event.getRawSlot());
        if (taskListId == null) {
            return;
        }
        TaskListService.getInstance().deleteById(taskListId);
        ViewListGui.getInstance().setInventoryDate(handyInventory);
    }
}

