/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertask.service;

import com.handy.playertask.entity.TaskCoin;
import com.handy.playertask.lib.db.Db;
import java.util.Date;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.OfflinePlayer;

public class TaskCoinService {
    private TaskCoinService() {
    }

    public static TaskCoinService getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public boolean add(TaskCoin taskCoin) {
        return Db.use(TaskCoin.class).execution().insert(taskCoin) > 0;
    }

    public Optional<TaskCoin> findByPlayer(UUID playerUuid) {
        Db<TaskCoin> use = Db.use(TaskCoin.class);
        use.where().eq(TaskCoin::getPlayerUuid, playerUuid);
        return use.execution().selectOne();
    }

    public Integer findCoinByPlayer(UUID playerUuid) {
        Optional<TaskCoin> taskCoinOptional = this.findByPlayer(playerUuid);
        return taskCoinOptional.isPresent() ? taskCoinOptional.get().getAmount() : 0;
    }

    public boolean addCoin(UUID playerUuid, Integer amount) {
        Db<TaskCoin> use = Db.use(TaskCoin.class);
        use.update().add(TaskCoin::getAmount, TaskCoin::getAmount, amount);
        use.where().eq(TaskCoin::getPlayerUuid, playerUuid);
        return use.execution().update() > 0;
    }

    public boolean subtractCoin(UUID playerUuid, Integer amount) {
        if (this.findCoinByPlayer(playerUuid) < amount) {
            return false;
        }
        Db<TaskCoin> use = Db.use(TaskCoin.class);
        use.update().subtract(TaskCoin::getAmount, TaskCoin::getAmount, amount);
        use.where().eq(TaskCoin::getPlayerUuid, playerUuid);
        return use.execution().update() > 0;
    }

    public boolean set(UUID playerUuid, Integer amount) {
        Db<TaskCoin> use = Db.use(TaskCoin.class);
        use.update().set(TaskCoin::getAmount, amount);
        use.where().eq(TaskCoin::getPlayerUuid, playerUuid);
        return use.execution().update() > 0;
    }

    public void init(OfflinePlayer offlinePlayer) {
        Optional<TaskCoin> taskCoinOptional = this.findByPlayer(offlinePlayer.getUniqueId());
        if (taskCoinOptional.isPresent()) {
            this.updateLastJoinTimeByPlayer(offlinePlayer.getUniqueId(), new Date());
            return;
        }
        TaskCoin taskCoin = new TaskCoin();
        taskCoin.setPlayerUuid(offlinePlayer.getUniqueId().toString());
        taskCoin.setPlayerName(offlinePlayer.getName());
        taskCoin.setAmount(0);
        this.add(taskCoin);
    }

    public void updateLastQuitTimeByPlayer(UUID playerUuid, Date lastQuitTime) {
        Db<TaskCoin> db = Db.use(TaskCoin.class);
        db.update().set(TaskCoin::getLastQuitTime, lastQuitTime);
        db.where().eq(TaskCoin::getPlayerUuid, playerUuid);
        db.execution().update();
    }

    public void updateLastJoinTimeByPlayer(UUID playerUuid, Date lastJoinTime) {
        Db<TaskCoin> db = Db.use(TaskCoin.class);
        db.update().set(TaskCoin::getLastJoinTime, lastJoinTime);
        db.where().eq(TaskCoin::getPlayerUuid, playerUuid);
        db.execution().update();
    }

    private static class SingletonHolder {
        private static final TaskCoinService INSTANCE = new TaskCoinService();

        private SingletonHolder() {
        }
    }
}

