/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertask.service;

import com.handy.playertask.constants.DemandTypeEnum;
import com.handy.playertask.entity.TaskDemand;
import com.handy.playertask.lib.core.CollUtil;
import com.handy.playertask.lib.db.Db;
import com.handy.playertask.lib.db.enter.Page;
import java.util.ArrayList;
import java.util.List;

public class TaskDemandService {
    private TaskDemandService() {
    }

    public static TaskDemandService getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public boolean add(TaskDemand taskDemand) {
        return Db.use(TaskDemand.class).execution().insert(taskDemand) > 0;
    }

    public List<TaskDemand> findByIds(List<Integer> ids) {
        if (CollUtil.isEmpty(ids)) {
            return new ArrayList<TaskDemand>();
        }
        return Db.use(TaskDemand.class).execution().selectBatchIds(ids);
    }

    public Page<TaskDemand> page(String type, Integer pageNum, Integer pageSize) {
        Db<TaskDemand> use = Db.use(TaskDemand.class);
        use.where().eq(!DemandTypeEnum.ALL.getType().equalsIgnoreCase(type), TaskDemand::getType, type).limit(pageNum, pageSize);
        return use.execution().page();
    }

    public Boolean deleteById(Integer id) {
        return Db.use(TaskDemand.class).execution().deleteById(id) > 0;
    }

    public List<TaskDemand> selectAll() {
        return Db.use(TaskDemand.class).execution().list();
    }

    public void updateItemStack(String itemStack, Integer id) {
        Db<TaskDemand> use = Db.use(TaskDemand.class);
        use.update().set(TaskDemand::getItemStack, itemStack);
        use.execution().updateById(id);
    }

    private static class SingletonHolder {
        private static final TaskDemandService INSTANCE = new TaskDemandService();

        private SingletonHolder() {
        }
    }
}

