/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertask.service;

import com.handy.playertask.constants.RarityEnum;
import com.handy.playertask.constants.TaskTypeEnum;
import com.handy.playertask.entity.TaskDemand;
import com.handy.playertask.entity.TaskList;
import com.handy.playertask.entity.TaskNpcPlayer;
import com.handy.playertask.entity.TaskReel;
import com.handy.playertask.entity.TaskRewards;
import com.handy.playertask.lib.core.CollUtil;
import com.handy.playertask.lib.core.StrUtil;
import com.handy.playertask.lib.db.Db;
import com.handy.playertask.lib.db.enter.Page;
import com.handy.playertask.service.TaskDemandService;
import com.handy.playertask.service.TaskNpcPlayerDemandService;
import com.handy.playertask.service.TaskNpcPlayerService;
import com.handy.playertask.service.TaskNpcService;
import com.handy.playertask.service.TaskPlayerService;
import com.handy.playertask.service.TaskReelPlayerDemandService;
import com.handy.playertask.service.TaskReelService;
import com.handy.playertask.service.TaskRewardsService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class TaskListService {
    private TaskListService() {
    }

    public static TaskListService getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public int add(TaskList taskList) {
        if (taskList.getId() != null) {
            return this.update(taskList);
        }
        return Db.use(TaskList.class).execution().insert(taskList);
    }

    public int update(TaskList taskList) {
        Db<TaskList> use = Db.use(TaskList.class);
        use.update().set(StrUtil.isNotEmpty(taskList.getTaskName()), TaskList::getTaskName, taskList.getTaskName()).set(StrUtil.isNotEmpty(taskList.getTaskDemand()), TaskList::getTaskDemand, taskList.getTaskDemand()).set(StrUtil.isNotEmpty(taskList.getTaskRewards()), TaskList::getTaskRewards, taskList.getTaskRewards()).set(StrUtil.isNotEmpty(taskList.getType()), TaskList::getType, taskList.getType()).set(StrUtil.isNotEmpty(taskList.getRarity()), TaskList::getRarity, taskList.getRarity()).set(StrUtil.isNotEmpty(taskList.getDescription()), TaskList::getDescription, taskList.getDescription());
        use.execution().updateById(taskList.getId());
        return taskList.getId();
    }

    public boolean updateDescription(Integer id, String description) {
        Db<TaskList> use = Db.use(TaskList.class);
        use.update().set(TaskList::getDescription, description);
        return use.execution().updateById(id) > 0;
    }

    public Boolean updateRarityById(String rarity, Integer id) {
        Db<TaskList> use = Db.use(TaskList.class);
        use.update().set(TaskList::getRarity, rarity);
        return use.execution().updateById(id) > 0;
    }

    public Optional<TaskList> findById(Integer id) {
        return Db.use(TaskList.class).execution().selectById(id);
    }

    public List<TaskList> findByIds(List<Integer> ids) {
        return Db.use(TaskList.class).execution().selectBatchIds(ids);
    }

    public List<TaskList> findDataByIds(List<Integer> ids) {
        List<TaskList> taskListList = this.findByIds(ids);
        this.setData(taskListList);
        return taskListList;
    }

    public Page<TaskList> page(Integer pageNum, Integer pageSize, String type, String rarity) {
        Db<TaskList> use = Db.use(TaskList.class);
        use.where().limit(pageNum, pageSize).eq(!TaskTypeEnum.ALL.getType().equalsIgnoreCase(type), TaskList::getType, type).eq(!RarityEnum.ALL.getType().equalsIgnoreCase(rarity), TaskList::getRarity, rarity);
        Page<TaskList> page = use.execution().page();
        this.setData(page.getRecords());
        return page;
    }

    private void setData(List<TaskList> taskListList) {
        List<TaskRewards> taskRewardList;
        if (CollUtil.isEmpty(taskListList)) {
            return;
        }
        ArrayList<Integer> rewardList = new ArrayList<Integer>();
        ArrayList<Integer> demandList = new ArrayList<Integer>();
        for (TaskList taskList : taskListList) {
            if (StrUtil.isNotEmpty(taskList.getTaskRewards())) {
                rewardList.addAll(StrUtil.strToIntList(taskList.getTaskRewards()));
            }
            if (!StrUtil.isNotEmpty(taskList.getTaskDemand())) continue;
            demandList.addAll(StrUtil.strToIntList(taskList.getTaskDemand()));
        }
        List<TaskDemand> taskDemandList = TaskDemandService.getInstance().findByIds(demandList);
        if (CollUtil.isNotEmpty(taskDemandList)) {
            Map<Integer, TaskDemand> taskDemandMap = taskDemandList.stream().collect(Collectors.groupingBy(TaskDemand::getId, Collectors.collectingAndThen(Collectors.toList(), value -> (TaskDemand)value.get(0))));
            for (TaskList taskList : taskListList) {
                if (!StrUtil.isNotEmpty(taskList.getTaskDemand())) continue;
                ArrayList<TaskDemand> taskDemands = new ArrayList<TaskDemand>();
                List<Integer> demands = StrUtil.strToIntList(taskList.getTaskDemand());
                for (Integer demand : demands) {
                    TaskDemand taskDemand = taskDemandMap.get(demand);
                    if (taskDemand == null) continue;
                    taskDemands.add(taskDemand);
                }
                taskList.setTaskDemands(CollUtil.isNotEmpty(taskDemands) ? taskDemands : null);
            }
        }
        if (CollUtil.isNotEmpty(taskRewardList = TaskRewardsService.getInstance().findByIds(rewardList))) {
            Map<Integer, TaskRewards> taskRewardsMap = taskRewardList.stream().collect(Collectors.groupingBy(TaskRewards::getId, Collectors.collectingAndThen(Collectors.toList(), value -> (TaskRewards)value.get(0))));
            for (TaskList taskList : taskListList) {
                if (!StrUtil.isNotEmpty(taskList.getTaskRewards())) continue;
                ArrayList<TaskRewards> taskRewardsList = new ArrayList<TaskRewards>();
                List<Integer> rewardIds = StrUtil.strToIntList(taskList.getTaskRewards());
                for (Integer rewardId : rewardIds) {
                    TaskRewards taskRewards = taskRewardsMap.get(rewardId);
                    if (taskRewards == null) continue;
                    taskRewardsList.add(taskRewards);
                }
                taskList.setTaskRewardsList(CollUtil.isNotEmpty(taskRewardsList) ? taskRewardsList : null);
            }
        }
    }

    public List<Integer> findAllId(String type, String rarity, int num) {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        Db<TaskList> use = Db.use(TaskList.class);
        use.where().eq(StrUtil.isNotEmpty(type), TaskList::getType, type).eq(StrUtil.isNotEmpty(rarity), TaskList::getRarity, rarity);
        List<TaskList> list = use.execution().list();
        if (CollUtil.isEmpty(list)) {
            return ids;
        }
        Collections.shuffle(list);
        for (int i = 0; i < num && list.size() > i; ++i) {
            TaskList taskList = list.get(i);
            ids.add(taskList.getId());
        }
        return ids;
    }

    public boolean deleteById(Integer taskListId) {
        boolean rst;
        boolean bl = rst = Db.use(TaskList.class).execution().deleteById(taskListId) > 0;
        if (rst) {
            List<TaskReel> taskReels;
            TaskPlayerService.getInstance().deleteByTaskId(taskListId);
            TaskNpcService.getInstance().deleteByTaskId(taskListId);
            TaskReelService.getInstance().deleteByTaskId(taskListId);
            List<TaskNpcPlayer> taskPlayers = TaskNpcPlayerService.getInstance().findByTaskId(taskListId);
            if (CollUtil.isNotEmpty(taskPlayers)) {
                for (TaskNpcPlayer taskPlayer : taskPlayers) {
                    TaskNpcPlayerDemandService.getInstance().deleteByTaskNpcPlayerId(taskPlayer.getId());
                }
                TaskNpcPlayerService.getInstance().deleteByTaskId(taskListId);
            }
            if (CollUtil.isNotEmpty(taskReels = TaskReelService.getInstance().findByTaskId(taskListId))) {
                for (TaskReel taskReel : taskReels) {
                    TaskReelPlayerDemandService.getInstance().deleteByReelId(taskReel.getId());
                }
                TaskReelService.getInstance().deleteByTaskId(taskListId);
            }
        }
        return rst;
    }

    public Optional<TaskList> findDetailById(Integer id) {
        Optional<TaskList> taskListOptional = this.findById(id);
        taskListOptional.ifPresent(taskList -> this.setData(Collections.singletonList(taskList)));
        return taskListOptional;
    }

    public boolean updateEnableCommand(Integer id, String enableCommand) {
        Db<TaskList> use = Db.use(TaskList.class);
        use.update().set(TaskList::getEnableCommand, enableCommand);
        return use.execution().updateById(id) > 0;
    }

    private static class SingletonHolder {
        private static final TaskListService INSTANCE = new TaskListService();

        private SingletonHolder() {
        }
    }
}

