/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertask.service;

import com.handy.playertask.entity.TaskPlayerDemand;
import com.handy.playertask.lib.db.Db;
import java.util.List;
import java.util.UUID;

public class TaskPlayerDemandService {
    private TaskPlayerDemandService() {
    }

    public static TaskPlayerDemandService getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public Boolean add(TaskPlayerDemand taskPlayerDemand) {
        return Db.use(TaskPlayerDemand.class).execution().insert(taskPlayerDemand) > 0;
    }

    public void addBatch(List<TaskPlayerDemand> list) {
        Db.use(TaskPlayerDemand.class).execution().insertBatch(list);
    }

    public List<TaskPlayerDemand> findByTaskPlayerIds(List<Integer> taskPlayerIds) {
        Db<TaskPlayerDemand> use = Db.use(TaskPlayerDemand.class);
        use.where().in(TaskPlayerDemand::getTaskPlayerId, taskPlayerIds);
        return use.execution().list();
    }

    public List<TaskPlayerDemand> findByPlayerAndContent(UUID playerUuid, String content, String demandType) {
        Db<TaskPlayerDemand> use = Db.use(TaskPlayerDemand.class);
        use.where().eq(TaskPlayerDemand::getPlayerUuid, playerUuid).eq(TaskPlayerDemand::getItemStack, content).eq(TaskPlayerDemand::getType, demandType).lt(TaskPlayerDemand::getCompletionAmount, TaskPlayerDemand::getAmount);
        return use.execution().list();
    }

    public boolean findCountByTaskPlayerId(Integer taskPlayerId) {
        Db<TaskPlayerDemand> use = Db.use(TaskPlayerDemand.class);
        use.where().eq(TaskPlayerDemand::getTaskPlayerId, taskPlayerId).lt(TaskPlayerDemand::getCompletionAmount, TaskPlayerDemand::getAmount);
        return use.execution().count() > 0;
    }

    public boolean updateCompletionAmount(Integer id, Integer completionAmount) {
        Db<TaskPlayerDemand> use = Db.use(TaskPlayerDemand.class);
        use.update().add(TaskPlayerDemand::getCompletionAmount, TaskPlayerDemand::getCompletionAmount, completionAmount);
        return use.execution().updateById(id) > 0;
    }

    public Boolean deleteById(Integer id) {
        return Db.use(TaskPlayerDemand.class).execution().deleteById(id) > 0;
    }

    public void deleteAll() {
        Db.use(TaskPlayerDemand.class).execution().delete();
    }

    public void deleteByPlayer(UUID playerUuid) {
        Db<TaskPlayerDemand> use = Db.use(TaskPlayerDemand.class);
        use.where().eq(TaskPlayerDemand::getPlayerUuid, playerUuid);
        use.execution().delete();
    }

    public List<TaskPlayerDemand> selectAll() {
        return Db.use(TaskPlayerDemand.class).execution().list();
    }

    public void updateItemStack(String itemStack, Integer id) {
        Db<TaskPlayerDemand> use = Db.use(TaskPlayerDemand.class);
        use.update().set(TaskPlayerDemand::getItemStack, itemStack);
        use.execution().updateById(id);
    }

    private static class SingletonHolder {
        private static final TaskPlayerDemandService INSTANCE = new TaskPlayerDemandService();

        private SingletonHolder() {
        }
    }
}

