/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertask.service;

import com.handy.playertask.entity.TaskReel;
import com.handy.playertask.lib.db.Db;
import com.handy.playertask.service.TaskReelPlayerDemandService;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

public class TaskReelService {
    private TaskReelService() {
    }

    public static TaskReelService getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public int add(TaskReel taskReel) {
        int playerReelIdByPlayer = this.findPlayerReelIdByPlayer(UUID.fromString(taskReel.getPlayerUuid()));
        taskReel.setPlayerReelId(playerReelIdByPlayer + 1);
        Db<TaskReel> db = Db.use(TaskReel.class);
        return db.execution().insert(taskReel);
    }

    public Optional<TaskReel> findById(Integer id) {
        Db<TaskReel> db = Db.use(TaskReel.class);
        Optional<TaskReel> taskReelOptional = db.execution().selectById(id);
        taskReelOptional.ifPresent(taskReel -> taskReel.setTaskReelPlayerDemands(TaskReelPlayerDemandService.getInstance().findByReelId(id)));
        return taskReelOptional;
    }

    public Optional<TaskReel> findByIdAndPlayer(Integer id, UUID playerUuid) {
        Db<TaskReel> db = Db.use(TaskReel.class);
        db.where().eq(TaskReel::getId, id).eq(TaskReel::getPlayerUuid, playerUuid);
        Optional<TaskReel> taskReelOptional = db.execution().selectOne();
        taskReelOptional.ifPresent(taskReel -> taskReel.setTaskReelPlayerDemands(TaskReelPlayerDemandService.getInstance().findByReelId(id)));
        return taskReelOptional;
    }

    public Optional<TaskReel> findByPlayerReelIdAndPlayer(Integer playerReelId, UUID playerUuid) {
        Db<TaskReel> db = Db.use(TaskReel.class);
        db.where().eq(TaskReel::getPlayerReelId, playerReelId).eq(TaskReel::getPlayerUuid, playerUuid);
        Optional<TaskReel> taskReelOptional = db.execution().selectOne();
        taskReelOptional.ifPresent(taskReel -> taskReel.setTaskReelPlayerDemands(TaskReelPlayerDemandService.getInstance().findByReelId(taskReel.getId())));
        return taskReelOptional;
    }

    public List<TaskReel> findByTaskId(Integer taskId) {
        Db<TaskReel> db = Db.use(TaskReel.class);
        db.where().eq(TaskReel::getTaskId, taskId);
        return db.execution().list();
    }

    public int findPlayerReelIdByPlayer(UUID playerUuid) {
        Db<TaskReel> db = Db.use(TaskReel.class);
        db.where().eq(TaskReel::getPlayerUuid, playerUuid).orderByDesc(TaskReel::getPlayerReelId).limit(1, 1);
        Optional<TaskReel> taskReelOptional = db.execution().selectOne();
        return taskReelOptional.isPresent() ? taskReelOptional.get().getPlayerReelId() : 0;
    }

    public void deleteByTaskId(Integer taskId) {
        Db<TaskReel> db = Db.use(TaskReel.class);
        db.where().eq(TaskReel::getTaskId, taskId);
        db.execution().delete();
    }

    public void updateStatus(Integer id, Boolean status) {
        Db<TaskReel> db = Db.use(TaskReel.class);
        db.update().set(TaskReel::getStatus, status);
        db.execution().updateById(id);
    }

    private static class SingletonHolder {
        private static final TaskReelService INSTANCE = new TaskReelService();

        private SingletonHolder() {
        }
    }
}

