/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertask.service;

import com.handy.playertask.entity.TaskShop;
import com.handy.playertask.lib.db.Db;
import com.handy.playertask.lib.db.enter.Page;
import java.util.List;
import java.util.Optional;

public class TaskShopService {
    private TaskShopService() {
    }

    public static TaskShopService getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public boolean add(TaskShop taskShop) {
        return Db.use(TaskShop.class).execution().insert(taskShop) > 0;
    }

    public Optional<TaskShop> findById(Integer id) {
        return Db.use(TaskShop.class).execution().selectById(id);
    }

    public Page<TaskShop> page(Integer pageNum, Integer pageSize) {
        Db<TaskShop> use = Db.use(TaskShop.class);
        use.where().limit(pageNum, pageSize);
        return use.execution().page();
    }

    public boolean deleteById(Integer id) {
        return Db.use(TaskShop.class).execution().deleteById(id) > 0;
    }

    public List<TaskShop> selectAll() {
        return Db.use(TaskShop.class).execution().list();
    }

    public void updateItemStack(String itemStack, Integer id) {
        Db<TaskShop> use = Db.use(TaskShop.class);
        use.update().set(TaskShop::getItemStack, itemStack);
        use.execution().updateById(id);
    }

    private static class SingletonHolder {
        private static final TaskShopService INSTANCE = new TaskShopService();

        private SingletonHolder() {
        }
    }
}

