/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertask.util;

import com.handy.playertask.constants.DemandTypeEnum;
import com.handy.playertask.constants.TaskEnchantmentEnum;
import com.handy.playertask.lib.mm.MythicMobUtil;
import com.handy.playertask.lib.util.BaseUtil;
import com.handy.playertask.lib.util.ItemStackUtil;
import com.handy.playertask.param.TaskDemandParam;
import com.handy.playertask.param.TaskReplaceContent;
import com.handy.playertask.util.ConfigUtil;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class DemandReplaceUtil {
    private static final List<String> AGE_ABLE_LIST = Arrays.asList("WHEAT", "CARROT", "POTATO", "BEETROOT", "NETHER_WART", "PUMPKIN", "MELON", "TORCHFLOWER", "PITCHER_PLANT", "CACTUS", "SUGAR_CANE", "BAMBOO");

    public static TaskReplaceContent getDemandContent(TaskDemandParam param) {
        String displayName;
        ItemStack itemStack;
        DemandTypeEnum demandTypeEnum = DemandTypeEnum.getEnumThrow(param.getType());
        boolean isAgeAble = false;
        switch (demandTypeEnum) {
            case KILL: {
                itemStack = new ItemStack(Material.EGG);
                displayName = MythicMobUtil.getInstance().getMythicMobName(param.getItemStack());
                break;
            }
            case KILL_PLAYER: {
                itemStack = ItemStackUtil.getItemStack("PLAYER_HEAD");
                displayName = param.getItemStack();
                break;
            }
            case KILL_NORMAL: {
                itemStack = ItemStackUtil.getItemStack("ZOMBIE_SPAWN_EGG");
                displayName = ConfigUtil.MONSTER_CONFIG.getString(param.getItemStack(), BaseUtil.getEntityName(param.getItemStack()));
                break;
            }
            case BLOCK_BREAK: {
                itemStack = ItemStackUtil.getItemStack(param.getItemStack());
                displayName = BaseUtil.getDisplayName(itemStack);
                isAgeAble = DemandReplaceUtil.isAgeAble(itemStack);
                break;
            }
            case ENCHANTMENT: {
                itemStack = ItemStackUtil.getItemStack("ENCHANTED_BOOK");
                displayName = TaskEnchantmentEnum.getTypeName(param.getItemStack());
                break;
            }
            case SHEAR: {
                itemStack = ItemStackUtil.getItemStack(param.getItemStack());
                displayName = BaseUtil.getDisplayName(itemStack);
                break;
            }
            default: {
                itemStack = ItemStackUtil.itemStackDeserialize(param.getItemStack(), Material.STONE);
                displayName = BaseUtil.getDisplayName(itemStack);
            }
        }
        String amount = param.getAmount().toString();
        if (param.getCompletionAmount() != null) {
            Integer completionAmount = param.getCompletionAmount() > param.getAmount() ? param.getAmount() : param.getCompletionAmount();
            amount = completionAmount + "/" + param.getAmount();
        }
        String demand = isAgeAble ? BaseUtil.getMsgNotColor("demand.harvest") : DemandTypeEnum.getTypeName(demandTypeEnum.getType());
        String msg = demand + " " + amount + " " + displayName;
        return TaskReplaceContent.init(msg, itemStack);
    }

    public static boolean isAgeAble(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        for (String ageAble : AGE_ABLE_LIST) {
            if (!ItemStackUtil.isSimilar(itemStack, ItemStackUtil.getItemByMaterial(ageAble))) continue;
            return true;
        }
        return false;
    }
}

