/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertask.util;

import com.handy.playertask.constants.RarityEnum;
import com.handy.playertask.constants.TaskTypeEnum;
import com.handy.playertask.entity.TaskDemand;
import com.handy.playertask.entity.TaskList;
import com.handy.playertask.entity.TaskPlayer;
import com.handy.playertask.entity.TaskPlayerDemand;
import com.handy.playertask.lib.core.CollUtil;
import com.handy.playertask.lib.core.DateUtil;
import com.handy.playertask.lib.core.StrUtil;
import com.handy.playertask.lib.expand.adapter.HandySchedulerUtil;
import com.handy.playertask.lib.util.BaseUtil;
import com.handy.playertask.lib.util.MessageUtil;
import com.handy.playertask.service.TaskDemandService;
import com.handy.playertask.service.TaskListService;
import com.handy.playertask.service.TaskPlayerDemandService;
import com.handy.playertask.service.TaskPlayerService;
import com.handy.playertask.util.ConfigUtil;
import com.handy.playertask.util.TaskUtil;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class TaskJob {
    private static final TaskJob INSTANCE = new TaskJob();

    private TaskJob() {
    }

    public static TaskJob getInstance() {
        return INSTANCE;
    }

    public void setAsyncTodayTask() {
        HandySchedulerUtil.runTaskTimerAsynchronously(() -> {
            String time = LocalDateTime.now().format(DateTimeFormatter.ofPattern("HH:mm"));
            String setTodayDate = ConfigUtil.CONFIG.getString("setTodayDate", "00:00");
            if (!setTodayDate.equals(time)) {
                return;
            }
            this.getToday();
        }, 1L, 1200L);
    }

    public void getToday() {
        this.delHistory();
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.setPlayerToDayTask(player, -1);
        }
    }

    public void delHistory() {
        TaskPlayerService.getInstance().deleteAll();
        TaskPlayerDemandService.getInstance().deleteAll();
    }

    public void refreshPlayerTask(Player player) {
        int taskRefresh = TaskPlayerService.getInstance().findTaskRefresh(player.getUniqueId(), DateUtil.getToday());
        this.delPlayerHistory(player);
        this.setPlayerToDayTask(player, taskRefresh);
        MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("yesRefresh"));
    }

    public synchronized void setPlayerToDayTask(Player player, int taskRefresh) {
        int todayTaskNum = ConfigUtil.CONFIG.getInt("todayTaskNum", 10);
        if (todayTaskNum < 1) {
            return;
        }
        Date today = DateUtil.getToday();
        int taskCount = TaskPlayerService.getInstance().findCountByPlayerAndDate(player.getUniqueId(), today);
        int num = todayTaskNum - taskCount;
        if (num <= 0) {
            return;
        }
        List<Integer> taskIds = this.getTaskIds(player, num);
        if (CollUtil.isEmpty(taskIds)) {
            return;
        }
        for (Integer taskId : taskIds) {
            Optional<TaskList> taskListOptional = TaskListService.getInstance().findById(taskId);
            if (!taskListOptional.isPresent()) continue;
            TaskList taskList = taskListOptional.get();
            TaskPlayer taskPlayer = new TaskPlayer();
            taskPlayer.setPlayerName(player.getName());
            taskPlayer.setPlayerUuid(player.getUniqueId().toString());
            taskPlayer.setTaskId(taskId);
            taskPlayer.setTaskName(taskList.getTaskName());
            taskPlayer.setTaskDemand(taskList.getTaskDemand());
            taskPlayer.setTaskDate(today);
            taskPlayer.setTaskRewards(taskList.getTaskRewards());
            taskPlayer.setStatus(false);
            taskPlayer.setRefresh(taskRefresh + 1);
            Integer id = TaskPlayerService.getInstance().add(taskPlayer);
            List<TaskDemand> taskDemandList = TaskDemandService.getInstance().findByIds(StrUtil.strToIntList(taskPlayer.getTaskDemand()));
            if (!CollUtil.isNotEmpty(taskDemandList)) continue;
            ArrayList<TaskPlayerDemand> taskPlayerDemandList = new ArrayList<TaskPlayerDemand>();
            for (TaskDemand taskDemand : taskDemandList) {
                TaskPlayerDemand taskPlayerDemand = new TaskPlayerDemand();
                taskPlayerDemand.setTaskPlayerId(id);
                taskPlayerDemand.setPlayerName(player.getName());
                taskPlayerDemand.setPlayerUuid(player.getUniqueId().toString());
                taskPlayerDemand.setType(taskDemand.getType());
                taskPlayerDemand.setCompletionAmount(0);
                taskPlayerDemand.setAmount(taskDemand.getAmount());
                taskPlayerDemand.setItemStack(taskDemand.getItemStack());
                taskPlayerDemand.setTaskDate(today);
                taskPlayerDemandList.add(taskPlayerDemand);
            }
            TaskPlayerDemandService.getInstance().addBatch(taskPlayerDemandList);
        }
    }

    private List<Integer> getTaskIds(Player player, Integer todayTaskNum) {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        Map<String, Integer> typeMap = RarityEnum.getTypeMap(player, todayTaskNum);
        for (String rarity : typeMap.keySet()) {
            List<Integer> idList = TaskListService.getInstance().findAllId(TaskTypeEnum.EVERYDAY.getType(), rarity, typeMap.get(rarity));
            ids.addAll(idList);
            String msg = player.getName() + "\u8fdb\u884c\u4efb\u52a1\u62bd\u53d6,\u7c7b\u578b:" + BaseUtil.getMsgNotColor("rarity." + rarity) + ",\u6570\u91cf:" + typeMap.get(rarity);
            TaskUtil.sendMsg(msg);
        }
        int num = todayTaskNum - ids.size();
        if (num > 0) {
            List<Integer> allId = TaskListService.getInstance().findAllId(TaskTypeEnum.EVERYDAY.getType(), null, num);
            allId.removeAll(ids);
            Collections.shuffle(allId);
            for (int i = 0; i < num && i < allId.size(); ++i) {
                ids.add(allId.get(i));
            }
        }
        return ids;
    }

    private void delPlayerHistory(Player player) {
        TaskPlayerService.getInstance().deleteByPlayer(player.getUniqueId());
        TaskPlayerDemandService.getInstance().deleteByPlayer(player.getUniqueId());
    }
}

