/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.top.hook;

import cn.handyplus.top.PlayerTop;
import cn.handyplus.top.lib.core.StrUtil;
import cn.handyplus.top.lib.util.BaseUtil;
import cn.handyplus.top.lib.util.ItemStackUtil;
import com.gmail.filoghost.holographicdisplays.api.Hologram;
import com.gmail.filoghost.holographicdisplays.api.HologramsAPI;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class HolographicDisplaysUtil {
    private HolographicDisplaysUtil() {
    }

    protected static HolographicDisplaysUtil getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public void create(List<String> textLineList, Location location, String material, int customModelData) {
        if (!PlayerTop.USE_HOLOGRAPHIC_DISPLAYS) {
            return;
        }
        Hologram hologram = HologramsAPI.createHologram((Plugin)PlayerTop.getInstance(), (Location)location);
        hologram.clearLines();
        if (StrUtil.isNotEmpty(material)) {
            ItemStack itemStack = ItemStackUtil.getItemStack(material, null, null, false, customModelData);
            hologram.appendItemLine(itemStack);
        }
        for (String textLine : textLineList) {
            hologram.appendTextLine(BaseUtil.replaceChatColor(textLine));
        }
    }

    public void delete(Location location) {
        if (!PlayerTop.USE_HOLOGRAPHIC_DISPLAYS) {
            return;
        }
        for (Hologram hologram : HologramsAPI.getHolograms((Plugin)PlayerTop.getInstance())) {
            Location hdLocation = hologram.getLocation();
            if (hdLocation.getX() != location.getX() || hdLocation.getY() != location.getY() || hdLocation.getZ() != location.getZ()) continue;
            hologram.delete();
            return;
        }
    }

    public void deleteAll() {
        if (!PlayerTop.USE_HOLOGRAPHIC_DISPLAYS) {
            return;
        }
        for (Hologram hologram : HologramsAPI.getHolograms((Plugin)PlayerTop.getInstance())) {
            hologram.delete();
        }
    }

    private static class SingletonHolder {
        private static final HolographicDisplaysUtil INSTANCE = new HolographicDisplaysUtil();

        private SingletonHolder() {
        }
    }
}

