/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.top.hook;

import cn.handyplus.top.PlayerTop;
import cn.handyplus.top.lib.core.StrUtil;
import com.handy.guild.api.PlayerGuildApi;

public class PlayerGuildUtil {
    private PlayerGuildUtil() {
    }

    public static PlayerGuildUtil getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public long getPlayerGuildMoney(String playerName) {
        if (!PlayerTop.USE_GUILD || StrUtil.isEmpty(playerName)) {
            return 0L;
        }
        Integer playerGuildMoney = PlayerGuildApi.getInstance().getPlayerMoney(playerName);
        return playerGuildMoney != null ? (long)playerGuildMoney.intValue() : 0L;
    }

    public long getPlayerGuildKill(String playerName) {
        if (!PlayerTop.USE_GUILD || StrUtil.isEmpty(playerName)) {
            return 0L;
        }
        Integer playerGuildKill = PlayerGuildApi.getInstance().getPlayerKill(playerName);
        return playerGuildKill != null ? (long)playerGuildKill.intValue() : 0L;
    }

    public long getPlayerGuildDie(String playerName) {
        if (!PlayerTop.USE_GUILD || StrUtil.isEmpty(playerName)) {
            return 0L;
        }
        Integer playerGuildDie = PlayerGuildApi.getInstance().getPlayerDie(playerName);
        return playerGuildDie != null ? (long)playerGuildDie.intValue() : 0L;
    }

    public long getPlayerDonatedGuildMoney(String playerName) {
        if (!PlayerTop.USE_GUILD || StrUtil.isEmpty(playerName)) {
            return 0L;
        }
        try {
            Integer playerGuildMoney = PlayerGuildApi.getInstance().getPlayerGuildMoney(playerName);
            return playerGuildMoney != null ? (long)playerGuildMoney.intValue() : 0L;
        }
        catch (Throwable throwable) {
            return 0L;
        }
    }

    private static class SingletonHolder {
        private static final PlayerGuildUtil INSTANCE = new PlayerGuildUtil();

        private SingletonHolder() {
        }
    }
}

