/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.top.util;

import cn.handyplus.top.constants.PlayerTopTypeEnum;
import cn.handyplus.top.enter.TopPapiPlayer;
import cn.handyplus.top.hook.HdUtil;
import cn.handyplus.top.hook.PlaceholderApiUtil;
import cn.handyplus.top.lib.core.CollUtil;
import cn.handyplus.top.lib.core.StrUtil;
import cn.handyplus.top.lib.util.BaseUtil;
import cn.handyplus.top.lib.util.HandyConfigUtil;
import cn.handyplus.top.param.PlayerPapiHd;
import cn.handyplus.top.service.TopPapiPlayerService;
import cn.handyplus.top.util.ConfigUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;

public class TopUtil {
    public static String getContent(String lore, TopPapiPlayer topPapiPlayer) {
        String content = lore.replace("${content}", topPapiPlayer.getVault().toString()).replace("${player}", topPapiPlayer.getPlayerName()).replace("${rank}", topPapiPlayer.getRank().toString());
        content = PlaceholderApiUtil.set(UUID.fromString(topPapiPlayer.getPlayerUuid()), content);
        return BaseUtil.replaceChatColor(content);
    }

    public static PlayerPapiHd createHd(PlayerTopTypeEnum topTypeEnum, Location location) {
        World world;
        String jobs;
        String type = topTypeEnum.getType();
        int line = ConfigUtil.FORMAT_CONFIG.getInt("hdFormat." + type + ".line", 10);
        String material = ConfigUtil.FORMAT_CONFIG.getString("hdFormat." + type + ".material");
        int customModelData = ConfigUtil.FORMAT_CONFIG.getInt("hdFormat." + type + ".custom-model-data");
        String title = ConfigUtil.FORMAT_CONFIG.getString("hdFormat." + type + ".title");
        String lore = ConfigUtil.FORMAT_CONFIG.getString("hdFormat." + type + ".lore", "");
        if (type.contains(PlayerTopTypeEnum.MC_MMO.getType())) {
            line = ConfigUtil.FORMAT_CONFIG.getInt("hdFormat." + PlayerTopTypeEnum.MC_MMO.getType() + ".line", 10);
            material = ConfigUtil.FORMAT_CONFIG.getString("hdFormat." + PlayerTopTypeEnum.MC_MMO.getType() + ".material");
            title = ConfigUtil.FORMAT_CONFIG.getString("hdFormat." + PlayerTopTypeEnum.MC_MMO.getType() + ".title", "");
            title = title.replace("${mcMmo}", topTypeEnum.getName());
            lore = ConfigUtil.FORMAT_CONFIG.getString("hdFormat." + PlayerTopTypeEnum.MC_MMO.getType() + ".lore", "");
        }
        if (type.contains(jobs = "jobs")) {
            line = ConfigUtil.FORMAT_CONFIG.getInt("hdFormat." + jobs + ".line", 10);
            material = ConfigUtil.FORMAT_CONFIG.getString("hdFormat." + jobs + ".material");
            title = ConfigUtil.FORMAT_CONFIG.getString("hdFormat." + jobs + ".title", "");
            title = title.replace("${jobs}", topTypeEnum.getName());
            lore = ConfigUtil.FORMAT_CONFIG.getString("hdFormat." + jobs + ".lore", "");
        }
        List<TopPapiPlayer> topPlayerList = TopPapiPlayerService.getInstance().page(topTypeEnum.getType(), 1, line);
        ArrayList<String> textLineList = new ArrayList<String>();
        if (StrUtil.isNotEmpty(title)) {
            textLineList.add(title);
        }
        if (CollUtil.isNotEmpty(topPlayerList)) {
            for (TopPapiPlayer topPapiPlayer : topPlayerList) {
                textLineList.add(TopUtil.getContent(lore, topPapiPlayer));
            }
        }
        if ((world = location.getWorld()) == null) {
            return null;
        }
        HandyConfigUtil.setPath(ConfigUtil.HD_CONFIG, type + ".enable", true, Collections.singletonList("\u662f\u5426\u5f00\u542f"), "/hologram.yml");
        HandyConfigUtil.setPath(ConfigUtil.HD_CONFIG, type + ".world", world.getName(), null, "/hologram.yml");
        HandyConfigUtil.setPath(ConfigUtil.HD_CONFIG, type + ".x", location.getX(), null, "/hologram.yml");
        HandyConfigUtil.setPath(ConfigUtil.HD_CONFIG, type + ".y", location.getY(), null, "/hologram.yml");
        HandyConfigUtil.setPath(ConfigUtil.HD_CONFIG, type + ".z", location.getZ(), null, "/hologram.yml");
        ConfigUtil.HD_CONFIG = HandyConfigUtil.load("hologram.yml");
        return PlayerPapiHd.builder().textLineList(textLineList).location(location).material(material).customModelData(customModelData).build();
    }

    public static void movePapiHd(String type, Location location) {
        HandyConfigUtil.setPath(ConfigUtil.PAPI_CONFIG, type + ".enable", true, null, "/papi.yml");
        HandyConfigUtil.setPath(ConfigUtil.PAPI_CONFIG, type + ".world", Objects.requireNonNull(location.getWorld()).getName(), null, "/papi.yml");
        HandyConfigUtil.setPath(ConfigUtil.PAPI_CONFIG, type + ".x", location.getX(), null, "/papi.yml");
        HandyConfigUtil.setPath(ConfigUtil.PAPI_CONFIG, type + ".y", location.getY(), null, "/papi.yml");
        HandyConfigUtil.setPath(ConfigUtil.PAPI_CONFIG, type + ".z", location.getZ(), null, "/papi.yml");
        ConfigUtil.PAPI_CONFIG = HandyConfigUtil.load("papi.yml");
    }

    public static void createPapiHd(String type, Location location) {
        HandyConfigUtil.setPath(ConfigUtil.PAPI_CONFIG, type + ".enable", true, null, "/papi.yml");
        HandyConfigUtil.setPath(ConfigUtil.PAPI_CONFIG, type + ".world", Objects.requireNonNull(location.getWorld()).getName(), null, "/papi.yml");
        HandyConfigUtil.setPath(ConfigUtil.PAPI_CONFIG, type + ".x", location.getX(), null, "/papi.yml");
        HandyConfigUtil.setPath(ConfigUtil.PAPI_CONFIG, type + ".y", location.getY(), null, "/papi.yml");
        HandyConfigUtil.setPath(ConfigUtil.PAPI_CONFIG, type + ".z", location.getZ(), null, "/papi.yml");
        HandyConfigUtil.setPathIsNotContains(ConfigUtil.PAPI_CONFIG, type + ".papi", "%" + type + "%", null, "/papi.yml");
        HandyConfigUtil.setPathIsNotContains(ConfigUtil.PAPI_CONFIG, type + ".line", 10, null, "/papi.yml");
        HandyConfigUtil.setPathIsNotContains(ConfigUtil.PAPI_CONFIG, type + ".material", "PAPER", null, "/papi.yml");
        HandyConfigUtil.setPathIsNotContains(ConfigUtil.PAPI_CONFIG, type + ".custom-model-data", 0, null, "/papi.yml");
        HandyConfigUtil.setPathIsNotContains(ConfigUtil.PAPI_CONFIG, type + ".title", "&e======" + type + "\u53d8\u91cf\u6392\u884c\u699c======", null, "/papi.yml");
        HandyConfigUtil.setPathIsNotContains(ConfigUtil.PAPI_CONFIG, type + ".lore", "&e${rank}   &f\u73a9\u5bb6:&e${player}   &f\u6570\u91cf:&e${content}", null, "/papi.yml");
        HandyConfigUtil.setPathIsNotContains(ConfigUtil.PAPI_CONFIG, type + ".sort", "desc", null, "/papi.yml");
        ConfigUtil.PAPI_CONFIG = HandyConfigUtil.load("papi.yml");
    }

    public static void deleteHd(String type) {
        String world = ConfigUtil.HD_CONFIG.getString(type + ".world", "");
        if (StrUtil.isEmpty(world)) {
            return;
        }
        double x = ConfigUtil.HD_CONFIG.getDouble(type + ".x");
        double y = ConfigUtil.HD_CONFIG.getDouble(type + ".y");
        double z = ConfigUtil.HD_CONFIG.getDouble(type + ".z");
        HdUtil.delete(new Location(Bukkit.getWorld((String)world), x, y, z));
    }

    public static void deletePapiHd(String type) {
        String world = ConfigUtil.PAPI_CONFIG.getString(type + ".world", "");
        if (StrUtil.isEmpty(world)) {
            return;
        }
        double x = ConfigUtil.PAPI_CONFIG.getDouble(type + ".x");
        double y = ConfigUtil.PAPI_CONFIG.getDouble(type + ".y");
        double z = ConfigUtil.PAPI_CONFIG.getDouble(type + ".z");
        HdUtil.delete(new Location(Bukkit.getWorld((String)world), x, y, z));
    }
}

