/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertitle.inventory;

import com.handy.playertitle.constants.GuiTypeEnum;
import com.handy.playertitle.constants.TitleUseTypeEnum;
import com.handy.playertitle.entity.TitlePlayer;
import com.handy.playertitle.hook.PlaceholderApiUtil;
import com.handy.playertitle.lib.core.DateUtil;
import com.handy.playertitle.lib.core.MapUtil;
import com.handy.playertitle.lib.core.StrUtil;
import com.handy.playertitle.lib.db.enter.Page;
import com.handy.playertitle.lib.inventory.HandyInventory;
import com.handy.playertitle.lib.inventory.HandyInventoryUtil;
import com.handy.playertitle.lib.util.BaseUtil;
import com.handy.playertitle.lib.util.ItemStackUtil;
import com.handy.playertitle.service.TitlePlayerService;
import com.handy.playertitle.util.ConfigUtil;
import com.handy.playertitle.util.TitleUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class OpenGui {
    private static final OpenGui INSTANCE = new OpenGui();

    private OpenGui() {
    }

    public static OpenGui getInstance() {
        return INSTANCE;
    }

    public Inventory createGui(Player player) {
        return this.createGui(player, 1);
    }

    public Inventory createGui(Player player, Integer pageNum) {
        String title = ConfigUtil.OPEN_CONFIG.getString("title", "");
        title = PlaceholderApiUtil.set(player, title);
        int size = ConfigUtil.OPEN_CONFIG.getInt("size", 54);
        HandyInventory handyInventory = new HandyInventory(GuiTypeEnum.OPEN.getType(), title, size);
        handyInventory.setPageNum(pageNum != null ? pageNum : 1);
        handyInventory.setPlayer(player);
        this.setInventoryDate(handyInventory);
        return handyInventory.getInventory();
    }

    public void setInventoryDate(HandyInventory handyInventory) {
        handyInventory.setGuiType(GuiTypeEnum.OPEN.getType());
        HandyInventoryUtil.refreshInventory(handyInventory.getInventory());
        this.setDate(handyInventory);
        this.setFunctionMenu(handyInventory);
    }

    public void setDate(HandyInventory handyInventory) {
        Player player = handyInventory.getPlayer();
        Inventory inventory = handyInventory.getInventory();
        Map<Integer, Integer> map = handyInventory.getIntMap();
        List<Integer> indexList = StrUtil.strToIntList(ConfigUtil.OPEN_CONFIG.getString("open.index"));
        handyInventory.setPageSize(indexList.size());
        Page<TitlePlayer> page = TitlePlayerService.getInstance().findPageByPlayerName(player.getName(), handyInventory.getPageNum(), handyInventory.getPageSize());
        handyInventory.setPageCount(page.getTotal());
        if (page.getTotal() < 1) {
            return;
        }
        String materialStr = ConfigUtil.OPEN_CONFIG.getString("open.material");
        String useMaterial = ConfigUtil.OPEN_CONFIG.getString("open.useMaterial");
        int customModelDataId = ConfigUtil.OPEN_CONFIG.getInt("open.custom-model-data");
        int i = 0;
        for (TitlePlayer titlePlayer : page.getRecords()) {
            String name = ConfigUtil.OPEN_CONFIG.getString("open.name", "${titleName}");
            List infoLoreList = ConfigUtil.OPEN_CONFIG.getStringList("open.lore.info");
            List descriptionLoreList = ConfigUtil.OPEN_CONFIG.getStringList("open.lore.description");
            List buffLoreList = ConfigUtil.OPEN_CONFIG.getStringList("open.lore.buff");
            List particleLoreList = ConfigUtil.OPEN_CONFIG.getStringList("open.lore.particle");
            List statusLoreList = ConfigUtil.OPEN_CONFIG.getStringList("open.lore.status");
            List buttonLoreList = ConfigUtil.OPEN_CONFIG.getStringList("open.lore.button");
            String titleMaterial = ConfigUtil.MATERIAL_CONFIG.getString(titlePlayer.getTitleId().toString(), materialStr);
            String material = TitleUtil.isUse(titlePlayer, TitleUseTypeEnum.ALL) ? useMaterial : titleMaterial;
            List<String> loreList = new ArrayList<String>(infoLoreList);
            HashMap<String, List<String>> replaceBatchMap = MapUtil.newHashMapWithExpectedSize(3);
            if (StrUtil.isNotEmpty(titlePlayer.getDescription())) {
                replaceBatchMap.put("description", TitleUtil.getDescription(titlePlayer.getDescription()));
                loreList.addAll(descriptionLoreList);
            }
            if (TitleUtil.isHaveBuff(titlePlayer.getTitleBuffs())) {
                replaceBatchMap.put("buff", TitleUtil.getBuff(titlePlayer.getTitleBuffs()));
                loreList.addAll(buffLoreList);
            }
            if (titlePlayer.getTitleParticle() != null) {
                replaceBatchMap.put("particle", TitleUtil.getParticle(titlePlayer.getTitleParticle()));
                loreList.addAll(particleLoreList);
            }
            loreList.addAll(statusLoreList);
            loreList.addAll(buttonLoreList);
            Map<String, String> replaceMap = this.getReplaceOpenLoreMap(titlePlayer, player);
            loreList = ItemStackUtil.loreReplaceMap(loreList, replaceMap);
            loreList = ItemStackUtil.loreBatchReplaceMap(loreList, replaceBatchMap, BaseUtil.getLangMsg("not"));
            int titleCustomModelDataId = ConfigUtil.MATERIAL_CONFIG.getInt(titlePlayer.getTitleId() + "_custom-model-data", customModelDataId);
            String titleName = PlaceholderApiUtil.set(player, titlePlayer.getTitleName());
            loreList = PlaceholderApiUtil.set(player, loreList);
            titleName = name.replace("${titleName}", titleName);
            ItemStack itemStack = ItemStackUtil.getItemStack(material, titleName, loreList, TitleUtil.isUse(titlePlayer, TitleUseTypeEnum.ALL), titleCustomModelDataId);
            Integer index = indexList.get(i++);
            inventory.setItem(index.intValue(), itemStack);
            map.put(index, titlePlayer.getId());
        }
    }

    private void setFunctionMenu(HandyInventory handyInventory) {
        Inventory inventory = handyInventory.getInventory();
        Map<String, String> replacePageMap = HandyInventoryUtil.replacePageMap(handyInventory);
        HandyInventoryUtil.setButton(ConfigUtil.OPEN_CONFIG, inventory, "nextPage", replacePageMap);
        HandyInventoryUtil.setButton(ConfigUtil.OPEN_CONFIG, inventory, "previousPage", replacePageMap);
        HandyInventoryUtil.setButton(ConfigUtil.OPEN_CONFIG, inventory, "number");
        HandyInventoryUtil.setButton(ConfigUtil.OPEN_CONFIG, inventory, "shop");
        HandyInventoryUtil.setCustomButton(ConfigUtil.OPEN_CONFIG, handyInventory, "custom");
    }

    private Map<String, String> getReplaceOpenLoreMap(TitlePlayer titlePlayer, Player player) {
        HashMap<String, String> map = MapUtil.newHashMapWithExpectedSize(6);
        map.put("id", titlePlayer.getTitleId().toString());
        String titleName = PlaceholderApiUtil.set(player, titlePlayer.getTitleName());
        map.put("titleName", titleName);
        map.put("expirationTime", DateUtil.format(titlePlayer.getExpirationTime(), "yyyy-MM-dd"));
        if (DateUtil.isPerpetual(titlePlayer.getExpirationTime())) {
            map.put("expirationTime", BaseUtil.getLangMsg("perpetual"));
        }
        map.put("useStatus", TitleUtil.isUse(titlePlayer, TitleUseTypeEnum.ALL) ? ConfigUtil.OPEN_CONFIG.getString("inUse") : ConfigUtil.OPEN_CONFIG.getString("notUse"));
        int haveCount = TitlePlayerService.getInstance().findCount(titlePlayer.getTitleId());
        map.put("haveCount", String.valueOf(haveCount));
        if (ConfigUtil.SELECT_CONFIG.getBoolean("enable")) {
            map.put("useButton", ConfigUtil.OPEN_CONFIG.getString("useSelectButton"));
            return map;
        }
        map.put("useButton", ConfigUtil.OPEN_CONFIG.getString(TitleUtil.isUse(titlePlayer, TitleUseTypeEnum.ALL) ? "noUseButton" : "useButton"));
        return map;
    }
}

