/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertitle.inventory;

import com.handy.playertitle.constants.GuiTypeEnum;
import com.handy.playertitle.constants.TitleUseTypeEnum;
import com.handy.playertitle.entity.TitlePlayer;
import com.handy.playertitle.hook.PlaceholderApiUtil;
import com.handy.playertitle.lib.core.MapUtil;
import com.handy.playertitle.lib.inventory.HandyInventory;
import com.handy.playertitle.lib.inventory.HandyInventoryUtil;
import com.handy.playertitle.service.TitlePlayerService;
import com.handy.playertitle.util.ConfigUtil;
import com.handy.playertitle.util.TitleUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;

public class SelectGui {
    private static final SelectGui INSTANCE = new SelectGui();

    private SelectGui() {
    }

    public static SelectGui getInstance() {
        return INSTANCE;
    }

    public Inventory createGui(Player player, Integer titlePlayerId, Integer openPageNum) {
        String title = ConfigUtil.SELECT_CONFIG.getString("title", "");
        title = PlaceholderApiUtil.set(player, title);
        int size = ConfigUtil.SELECT_CONFIG.getInt("size", 27);
        HandyInventory handyInventory = new HandyInventory(GuiTypeEnum.SELECT.getType(), title, size);
        handyInventory.setPageNum(openPageNum);
        handyInventory.setPlayer(player);
        handyInventory.setId(titlePlayerId);
        this.setInventoryDate(handyInventory);
        return handyInventory.getInventory();
    }

    public void setInventoryDate(HandyInventory handyInventory) {
        handyInventory.setGuiType(GuiTypeEnum.SELECT.getType());
        this.setFunctionMenu(handyInventory);
    }

    private void setFunctionMenu(HandyInventory handyInventory) {
        Inventory inventory = handyInventory.getInventory();
        Optional<TitlePlayer> titlePlayerOptional = TitlePlayerService.getInstance().findById(handyInventory.getId());
        if (!titlePlayerOptional.isPresent()) {
            return;
        }
        TitlePlayer titlePlayer = titlePlayerOptional.get();
        HandyInventoryUtil.setButton(ConfigUtil.SELECT_CONFIG, inventory, "show", this.replaceMap(titlePlayer, TitleUseTypeEnum.SHOW), TitleUtil.isUse(titlePlayer, TitleUseTypeEnum.SHOW));
        HandyInventoryUtil.setButton(ConfigUtil.SELECT_CONFIG, inventory, "buff", this.replaceMap(titlePlayer, TitleUseTypeEnum.BUFF), TitleUtil.isUse(titlePlayer, TitleUseTypeEnum.BUFF));
        HandyInventoryUtil.setButton(ConfigUtil.SELECT_CONFIG, inventory, "particle", this.replaceMap(titlePlayer, TitleUseTypeEnum.PARTICLE), TitleUtil.isUse(titlePlayer, TitleUseTypeEnum.PARTICLE));
        HandyInventoryUtil.setButton(ConfigUtil.SELECT_CONFIG, inventory, "back");
    }

    private Map<String, String> replaceMap(TitlePlayer titlePlayer, TitleUseTypeEnum useType) {
        HashMap<String, String> map = MapUtil.newHashMapWithExpectedSize(1);
        String yesStatus = ConfigUtil.SELECT_CONFIG.getString("yesStatus");
        String noStatus = ConfigUtil.SELECT_CONFIG.getString("noStatus");
        map.put("useStatus", noStatus);
        switch (useType) {
            case SHOW: {
                if (titlePlayer.getIsUseShow() == null || !titlePlayer.getIsUseShow().booleanValue()) break;
                map.put("useStatus", yesStatus);
                break;
            }
            case BUFF: {
                if (titlePlayer.getIsUseBuff() == null || !titlePlayer.getIsUseBuff().booleanValue()) break;
                map.put("useStatus", yesStatus);
                break;
            }
            case PARTICLE: {
                if (titlePlayer.getIsUseParticle() == null || !titlePlayer.getIsUseParticle().booleanValue()) break;
                map.put("useStatus", yesStatus);
                break;
            }
        }
        return map;
    }
}

