/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertitle.inventory;

import com.google.common.collect.Maps;
import com.handy.playertitle.constants.BuyTypeEnum;
import com.handy.playertitle.constants.GuiTypeEnum;
import com.handy.playertitle.constants.RewardTypeEnum;
import com.handy.playertitle.entity.TitleReward;
import com.handy.playertitle.hook.PlaceholderApiUtil;
import com.handy.playertitle.lib.core.StrUtil;
import com.handy.playertitle.lib.db.enter.Page;
import com.handy.playertitle.lib.inventory.HandyInventory;
import com.handy.playertitle.lib.inventory.HandyInventoryUtil;
import com.handy.playertitle.lib.util.BaseUtil;
import com.handy.playertitle.lib.util.ItemStackUtil;
import com.handy.playertitle.service.TitleRewardService;
import com.handy.playertitle.util.ConfigUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class ViewRewardGui {
    private static final ViewRewardGui INSTANCE = new ViewRewardGui();

    private ViewRewardGui() {
    }

    public static ViewRewardGui getInstance() {
        return INSTANCE;
    }

    public Inventory createGui(Player player) {
        String title = ConfigUtil.REWARD_CONFIG.getString("viewTitle", "");
        title = PlaceholderApiUtil.set(player, title);
        int size = ConfigUtil.REWARD_CONFIG.getInt("size", 54);
        HandyInventory handyInventory = new HandyInventory(GuiTypeEnum.VIEW_REWARD.getType(), title, size);
        this.setInventoryDate(handyInventory);
        return handyInventory.getInventory();
    }

    public void setInventoryDate(HandyInventory handyInventory) {
        handyInventory.setGuiType(GuiTypeEnum.VIEW_REWARD.getType());
        HandyInventoryUtil.refreshInventory(handyInventory.getInventory());
        this.setDate(handyInventory);
        this.setFunctionMenu(handyInventory);
    }

    public void setDate(HandyInventory handyInventory) {
        Map<Integer, Integer> map = handyInventory.getIntMap();
        Inventory inventory = handyInventory.getInventory();
        List<Integer> indexList = StrUtil.strToIntList(ConfigUtil.REWARD_CONFIG.getString("reward.index"));
        handyInventory.setPageSize(indexList.size());
        Page<TitleReward> page = TitleRewardService.getInstance().findPage(handyInventory.getPageNum(), handyInventory.getPageSize());
        handyInventory.setPageCount(page.getTotal());
        if (page.getTotal() < 1) {
            return;
        }
        int i = 0;
        block6: for (TitleReward titleReward : page.getRecords()) {
            List<String> loreList = ConfigUtil.REWARD_CONFIG.getStringList("reward.viewLore");
            Map<String, String> rewardMap = this.getRewardMap(titleReward);
            loreList = ItemStackUtil.loreReplaceMap(loreList, rewardMap);
            Integer index = indexList.get(i++);
            RewardTypeEnum rewardTypeEnum = RewardTypeEnum.getEnumThrow(titleReward.getRewardType());
            switch (rewardTypeEnum) {
                case VAULT: {
                    inventory.setItem(index.intValue(), ItemStackUtil.getItemStack(Material.GOLD_INGOT.name(), BaseUtil.getLangMsg("titleRewardMsg") + titleReward.getNumber(), loreList));
                    break;
                }
                case PLAYER_POINTS: {
                    inventory.setItem(index.intValue(), ItemStackUtil.getItemStack(Material.DIAMOND.name(), BaseUtil.getLangMsg("titleRewardMsg") + titleReward.getNumber(), loreList));
                    break;
                }
                case COIN: {
                    inventory.setItem(index.intValue(), ItemStackUtil.getItemStack(Material.EMERALD.name(), BaseUtil.getLangMsg("titleRewardMsg") + titleReward.getNumber(), loreList));
                    break;
                }
                case ITEM_STACK: {
                    ItemStack itemStack = ItemStackUtil.itemStackDeserialize(titleReward.getItemStack());
                    inventory.setItem(index.intValue(), ItemStackUtil.getItemStack(itemStack.getType().name(), BaseUtil.getLangMsg("titleRewardMsg") + titleReward.getNumber(), loreList));
                    break;
                }
                default: {
                    continue block6;
                }
            }
            map.put(index, titleReward.getId());
        }
    }

    private void setFunctionMenu(HandyInventory handyInventory) {
        Inventory inventory = handyInventory.getInventory();
        Map<String, String> replacePageMap = HandyInventoryUtil.replacePageMap(handyInventory);
        HandyInventoryUtil.setButton(ConfigUtil.REWARD_CONFIG, inventory, "nextPage", replacePageMap);
        HandyInventoryUtil.setButton(ConfigUtil.REWARD_CONFIG, inventory, "previousPage", replacePageMap);
    }

    private Map<String, String> getRewardMap(TitleReward titleReward) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)5);
        map.put("id", titleReward.getId().toString());
        map.put("number", titleReward.getNumber().toString());
        map.put("amount", titleReward.getAmount().toString());
        if (BuyTypeEnum.ITEM_STACK.getBuyType().equals(titleReward.getRewardType())) {
            ItemStack itemStack = ItemStackUtil.itemStackDeserialize(titleReward.getItemStack());
            map.put("rewardType", BaseUtil.getDisplayName(ItemStackUtil.getItemMeta(itemStack).getDisplayName(), itemStack.getType().toString()));
        } else {
            map.put("rewardType", RewardTypeEnum.getRewardTypeName(titleReward.getRewardType()));
        }
        return map;
    }
}

