/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertitle.lib.core;

import java.util.HashMap;

public class MapUtil {
    private static final Integer MIN_EXPECTED_SIZE = 3;

    private MapUtil() {
    }

    public static <K, V> HashMap<K, V> newHashMapWithExpectedSize(int expectedSize) {
        return new HashMap(MapUtil.capacity(expectedSize));
    }

    public static <K, V> HashMap<K, V> of() {
        return new HashMap(MapUtil.capacity(0));
    }

    public static <K, V> HashMap<K, V> of(final K k1, final V v1) {
        return new HashMap<K, V>(MapUtil.capacity(1)){
            {
                super(x0);
                this.put(k1, v1);
            }
        };
    }

    public static <K, V> HashMap<K, V> of(final K k1, final V v1, final K k2, final V v2) {
        return new HashMap<K, V>(MapUtil.capacity(1)){
            {
                super(x0);
                this.put(k1, v1);
                this.put(k2, v2);
            }
        };
    }

    public static <K, V> HashMap<K, V> of(final K k1, final V v1, final K k2, final V v2, final K k3, final V v3) {
        return new HashMap<K, V>(MapUtil.capacity(1)){
            {
                super(x0);
                this.put(k1, v1);
                this.put(k2, v2);
                this.put(k3, v3);
            }
        };
    }

    public static <K, V> HashMap<K, V> of(final K k1, final V v1, final K k2, final V v2, final K k3, final V v3, final K k4, final V v4) {
        return new HashMap<K, V>(MapUtil.capacity(1)){
            {
                super(x0);
                this.put(k1, v1);
                this.put(k2, v2);
                this.put(k3, v3);
                this.put(k4, v4);
            }
        };
    }

    public static <K, V> HashMap<K, V> of(final K k1, final V v1, final K k2, final V v2, final K k3, final V v3, final K k4, final V v4, final K k5, final V v5) {
        return new HashMap<K, V>(MapUtil.capacity(1)){
            {
                super(x0);
                this.put(k1, v1);
                this.put(k2, v2);
                this.put(k3, v3);
                this.put(k4, v4);
                this.put(k5, v5);
            }
        };
    }

    private static int capacity(int expectedSize) {
        if (expectedSize < 0) {
            expectedSize = 0;
        }
        if (expectedSize < MIN_EXPECTED_SIZE) {
            return expectedSize + 1;
        }
        return expectedSize < 0x40000000 ? (int)((float)expectedSize / 0.75f + 1.0f) : Integer.MAX_VALUE;
    }
}

