/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertitle.lib.expand.adapter;

import com.handy.playertitle.lib.expand.adapter.BukkitScheduler;
import com.handy.playertitle.lib.expand.adapter.FoliaScheduler;
import com.handy.playertitle.lib.expand.adapter.HandyRunnable;
import com.handy.playertitle.lib.expand.adapter.ServerTypeEnum;
import org.bukkit.plugin.Plugin;

public class HandySchedulerUtil {
    protected static Plugin BUKKIT_PLUGIN;
    private static ServerTypeEnum SERVER_TYPE;

    private HandySchedulerUtil() {
    }

    public static void init(Plugin plugin) {
        BUKKIT_PLUGIN = plugin;
        SERVER_TYPE = ServerTypeEnum.getServerType();
    }

    public static void runTask(Runnable task) {
        if (HandySchedulerUtil.isFolia()) {
            FoliaScheduler.runTask(task);
            return;
        }
        BukkitScheduler.runTask(task);
    }

    public static void runTaskLater(Runnable task, long delay) {
        if (HandySchedulerUtil.isFolia()) {
            FoliaScheduler.runTaskLater(task, delay);
            return;
        }
        BukkitScheduler.runTaskLater(task, delay);
    }

    public static void runTaskLater(HandyRunnable task, long delay) {
        if (HandySchedulerUtil.isFolia()) {
            FoliaScheduler.runTaskLater(task, delay);
            return;
        }
        BukkitScheduler.runTaskLater(task, delay);
    }

    public static void runTaskTimer(Runnable task, long delay, long period) {
        if (HandySchedulerUtil.isFolia()) {
            FoliaScheduler.runTaskTimer(task, delay, period);
            return;
        }
        BukkitScheduler.runTaskTimer(task, delay, period);
    }

    public static void runTaskTimer(HandyRunnable task, long delay, long period) {
        if (HandySchedulerUtil.isFolia()) {
            FoliaScheduler.runTaskTimer(task, delay, period);
            return;
        }
        BukkitScheduler.runTaskTimer(task, delay, period);
    }

    public static void runTaskAsynchronously(Runnable task) {
        if (HandySchedulerUtil.isFolia()) {
            FoliaScheduler.runTaskAsynchronously(task);
            return;
        }
        BukkitScheduler.runTaskAsynchronously(task);
    }

    public static void runTaskLaterAsynchronously(Runnable task, long delay) {
        if (HandySchedulerUtil.isFolia()) {
            FoliaScheduler.runTaskLaterAsynchronously(task, delay);
            return;
        }
        BukkitScheduler.runTaskLaterAsynchronously(task, delay);
    }

    public static void runTaskLaterAsynchronously(HandyRunnable task, long delay) {
        if (HandySchedulerUtil.isFolia()) {
            FoliaScheduler.runTaskLaterAsynchronously(task, delay);
            return;
        }
        BukkitScheduler.runTaskLaterAsynchronously(task, delay);
    }

    public static void runTaskTimerAsynchronously(Runnable task, long delay, long period) {
        if (HandySchedulerUtil.isFolia()) {
            FoliaScheduler.runTaskTimerAsynchronously(task, delay, period);
            return;
        }
        BukkitScheduler.runTaskTimerAsynchronously(task, delay, period);
    }

    public static void runTaskTimerAsynchronously(HandyRunnable task, long delay, long period) {
        if (HandySchedulerUtil.isFolia()) {
            FoliaScheduler.runTaskTimerAsynchronously(task, delay, period);
            return;
        }
        BukkitScheduler.runTaskTimerAsynchronously(task, delay, period);
    }

    public static void cancelTask() {
        if (HandySchedulerUtil.isFolia()) {
            FoliaScheduler.cancelTask();
        } else {
            BukkitScheduler.cancelTask();
        }
    }

    public static boolean isFolia() {
        return ServerTypeEnum.FOLIA.equals((Object)SERVER_TYPE);
    }
}

