/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild;

import com.handy.guild.constants.GuildConstants;
import com.handy.guild.enter.GuildPlayer;
import com.handy.guild.hook.PlaceholderUtil;
import com.handy.guild.hook.PlayerChatUtil;
import com.handy.guild.lib.InitApi;
import com.handy.guild.lib.core.CollUtil;
import com.handy.guild.lib.db.SqlManagerUtil;
import com.handy.guild.lib.expand.adapter.HandySchedulerUtil;
import com.handy.guild.lib.inventory.HandyInventory;
import com.handy.guild.lib.util.BaseUtil;
import com.handy.guild.lib.util.MessageUtil;
import com.handy.guild.listener.AdaptAdaptationUseEventListener;
import com.handy.guild.listener.GuildPluginMessageListener;
import com.handy.guild.listener.PlayerTaskScheduleEventListener;
import com.handy.guild.service.GuildPlayerService;
import com.handy.guild.util.ConfigUtil;
import com.handy.guild.util.GuildRunTaskTimer;
import com.handy.guild.util.LeatherUtil;
import com.handy.guild.util.UpUtil;
import com.onarandombox.MultiverseCore.MultiverseCore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.milkbowl.vault.economy.Economy;
import org.black_ixx.playerpoints.PlayerPoints;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public class PlayerGuild
extends JavaPlugin {
    public static PlayerGuild INSTANCE;
    public static boolean USE_TITLE;
    public static boolean USE_CHAT;
    public static boolean USE_TASK;
    public static boolean USE_RACE;
    public static boolean USE_PAPI;
    public static boolean USE_ADAPT;
    public static boolean USE_WORLD_BORDER;
    public static boolean USE_WORLD_EDIT;
    public static MultiverseCore MULTIVERSE_CORE;
    public static Economy ECON;
    public static PlayerPoints PLAYER_POINTS;

    public void onEnable() {
        INSTANCE = this;
        InitApi initApi = InitApi.getInstance(this);
        ConfigUtil.init();
        this.loadPlaceholder();
        this.loadEconomy();
        this.loadPlayerPoints();
        this.loadMultiverseCore();
        USE_WORLD_BORDER = BaseUtil.hook("WorldBorder", "worldBorderSucceedMsg", "worldBorderFailureMsg");
        USE_TITLE = BaseUtil.hook("PlayerTitle", "playerTitleSucceedMsg", "playerTitleFailureMsg");
        USE_TASK = BaseUtil.hook("PlayerTask", "playerTaskSucceedMsg", "playerTaskFailureMsg");
        USE_RACE = BaseUtil.hook("PlayerRace", "playerRaceSucceedMsg", "playerRaceFailureMsg");
        USE_WORLD_EDIT = BaseUtil.hook("WorldEdit", "worldEditSucceedMsg", "worldEditFailureMsg");
        USE_CHAT = BaseUtil.hook("PlayerChat", "playerChatSucceedMsg", "playerChatFailureMsg");
        USE_ADAPT = BaseUtil.hook("Adapt", "adaptSucceedMsg", "adaptFailureMsg");
        List<String> lordList = Arrays.asList("", "  ____  _                        ____       _ _     _ ", " |  _ \\| | __ _ _   _  ___ _ __ / ___|_   _(_) | __| |", " | |_) | |/ _` | | | |/ _ \\ '__| |  _| | | | | |/ _` |", " |  __/| | (_| | |_| |  __/ |  | |_| | |_| | | | (_| |", " |_|   |_|\\__,_|\\__, |\\___|_|   \\____|\\__,_|_|_|\\__,_|", "                |___/                                 ");
        for (String lord : lordList) {
            MessageUtil.sendConsoleMessage(ChatColor.DARK_AQUA + lord);
        }
        ArrayList<String> classList = new ArrayList<String>();
        if (!USE_TASK) {
            classList.add(PlayerTaskScheduleEventListener.class.getName());
        }
        if (!USE_ADAPT || !ConfigUtil.KIT_PVP_CONFIG.getBoolean("adapt", false)) {
            classList.add(AdaptAdaptationUseEventListener.class.getName());
        }
        initApi.initCommand("com.handy.guild.command").initListener("com.handy.guild.listener", classList).initClickEvent("com.handy.guild.listener.gui").enableSql("com.handy.guild.enter").addMetrics(12551).enableBc().checkVersion(ConfigUtil.CONFIG.getBoolean("isCheckUpdate"), "https://api.github.com/repos/handy-git/PlayerGuild/releases/latest");
        GuildRunTaskTimer.init();
        ArrayList<String> playerNameList = new ArrayList<String>();
        for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
            playerNameList.add(onlinePlayer.getName());
        }
        if (CollUtil.isNotEmpty(playerNameList)) {
            List<GuildPlayer> guildPlayerList = GuildPlayerService.getInstance().findByPlayerNameList(playerNameList);
            Map<String, GuildPlayer> guildPlayerMap = guildPlayerList.stream().collect(Collectors.groupingBy(GuildPlayer::getPlayerName, Collectors.collectingAndThen(Collectors.toList(), value -> (GuildPlayer)value.get(0))));
            for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                GuildConstants.PLAYER_GUILD_MAP.put(onlinePlayer.getUniqueId(), guildPlayerMap.get(onlinePlayer.getName()));
            }
        }
        UpUtil.up();
        new GuildPluginMessageListener();
        PlayerChatUtil.regChannel();
        MessageUtil.sendConsoleMessage(ChatColor.GREEN + "\u5df2\u6210\u529f\u8f7d\u5165\u670d\u52a1\u5668\uff01");
        MessageUtil.sendConsoleMessage(ChatColor.GREEN + "Author:handy MCBBS: https://www.mcbbs.net/thread-1297813-1-1.html");
    }

    public void onDisable() {
        for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
            InventoryView openInventory = onlinePlayer.getOpenInventory();
            InventoryHolder holder = openInventory.getTopInventory().getHolder();
            if (holder instanceof HandyInventory) {
                onlinePlayer.closeInventory();
            }
            LeatherUtil.setPlayerItemStack(onlinePlayer);
        }
        SqlManagerUtil.getInstance().close();
        PlayerChatUtil.unRegChannel();
        HandySchedulerUtil.cancelTask();
    }

    public void loadPlaceholder() {
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            USE_PAPI = true;
            new PlaceholderUtil(this).register();
            MessageUtil.sendConsoleMessage(BaseUtil.getMsgNotColor("placeholderAPISucceedMsg"));
            return;
        }
        USE_PAPI = false;
        MessageUtil.sendConsoleMessage(BaseUtil.getLangMsg("placeholderAPIFailureMsg"));
    }

    public void loadEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            MessageUtil.sendConsoleMessage(BaseUtil.getLangMsg("vaultFailureMsg"));
            return;
        }
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            MessageUtil.sendConsoleMessage(BaseUtil.getLangMsg("vaultFailureMsg"));
            return;
        }
        ECON = (Economy)rsp.getProvider();
        MessageUtil.sendConsoleMessage(BaseUtil.getLangMsg("vaultSucceedMsg"));
    }

    private void loadPlayerPoints() {
        if (Bukkit.getPluginManager().getPlugin("PlayerPoints") != null) {
            Plugin plugin = this.getServer().getPluginManager().getPlugin("PlayerPoints");
            PLAYER_POINTS = (PlayerPoints)plugin;
            MessageUtil.sendConsoleMessage(BaseUtil.getLangMsg("playerPointsSucceedMsg"));
            return;
        }
        MessageUtil.sendConsoleMessage(BaseUtil.getLangMsg("playerPointsFailureMsg"));
    }

    public void loadMultiverseCore() {
        MULTIVERSE_CORE = (MultiverseCore)Bukkit.getPluginManager().getPlugin("Multiverse-Core");
        if (MULTIVERSE_CORE != null) {
            MessageUtil.sendConsoleMessage(BaseUtil.getLangMsg("multiverseCoreSucceedMsg"));
        } else {
            MessageUtil.sendConsoleMessage(BaseUtil.getLangMsg("multiverseCoreFailureMsg"));
        }
    }
}

