/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.command;

import com.handy.guild.constants.TabListEnum;
import com.handy.guild.constants.TabPlayerListEnum;
import com.handy.guild.lib.annotation.HandyCommand;
import com.handy.guild.lib.command.HandyCommandFactory;
import com.handy.guild.lib.constants.BaseConstants;
import com.handy.guild.lib.util.BaseUtil;
import com.handy.guild.lib.util.MessageUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.NotNull;

@HandyCommand(name="playerGuild")
public class PlayerGuildCommand
implements TabExecutor {
    private static final String PERMISSION = "playerGuild.reload";

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String label, String[] args) {
        if (args.length < 1) {
            return this.sendHelp(sender);
        }
        boolean rst = HandyCommandFactory.getInstance().onCommand(sender, cmd, label, args, BaseUtil.getMsgNotColor("noPermission"));
        if (!rst) {
            return this.sendHelp(sender);
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, @NotNull Command cmd, @NotNull String label, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        List<String> commands = !sender.hasPermission(PERMISSION) ? TabPlayerListEnum.returnList(args, args.length) : TabListEnum.returnList(args, args.length);
        if (commands == null) {
            return null;
        }
        StringUtil.copyPartialMatches((String)args[args.length - 1].toLowerCase(), commands, completions);
        Collections.sort(completions);
        return completions;
    }

    private boolean sendHelp(CommandSender sender) {
        if (!sender.hasPermission(PERMISSION)) {
            return true;
        }
        List helps = BaseConstants.LANG_CONFIG.getStringList("helps");
        for (String help : helps) {
            MessageUtil.sendMessage(sender, help);
        }
        return true;
    }
}

