/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.command.player;

import com.handy.guild.constants.GuildRoleEnum;
import com.handy.guild.enter.GuildInfo;
import com.handy.guild.enter.GuildPlayer;
import com.handy.guild.lib.command.IHandyCommandEvent;
import com.handy.guild.lib.core.StrUtil;
import com.handy.guild.lib.util.AssertUtil;
import com.handy.guild.lib.util.BaseUtil;
import com.handy.guild.lib.util.MessageUtil;
import com.handy.guild.service.GuildInfoService;
import com.handy.guild.service.GuildPlayerService;
import com.handy.guild.util.ConfigUtil;
import java.util.List;
import java.util.Optional;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class EditDescriptionCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "editDescription";
    }

    @Override
    public String permission() {
        return "playerGuild.editDescription";
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void onCommand(CommandSender sender, Command command, String s, String[] args) {
        AssertUtil.notTrue(args.length < 2, sender, BaseUtil.getMsgNotColor("paramFailureMsg"));
        Player player = AssertUtil.notPlayer(sender, BaseUtil.getMsgNotColor("noPlayerFailureMsg"));
        String guildName = args[1].trim();
        EditDescriptionCommand.editDescription(player, guildName);
    }

    public static void editDescription(Player player, String guildDescription) {
        int maxFont = ConfigUtil.SETTING_CONFIG.getInt("description.maxFont");
        if (BaseUtil.stripColor(guildDescription).length() > maxFont) {
            String lengthFailureMsg = ConfigUtil.CREATE_CONFIG.getString("lengthFailureMsg", "").replace("${length}", maxFont + "");
            MessageUtil.sendMessage(player, lengthFailureMsg);
            return;
        }
        List<String> guildDescriptionList = StrUtil.strToStrList(guildDescription);
        int maxLine = ConfigUtil.SETTING_CONFIG.getInt("description.maxLine");
        for (String string : guildDescriptionList) {
            if (BaseUtil.stripColor(string).length() <= maxLine) continue;
            String lengthFailureMsg = ConfigUtil.CREATE_CONFIG.getString("lengthFailureMsg", "").replace("${length}", maxLine + "");
            MessageUtil.sendMessage(player, lengthFailureMsg);
            return;
        }
        List nameBlackList = ConfigUtil.CREATE_CONFIG.getStringList("nameBlackList");
        for (String nameBlack : nameBlackList) {
            if (!guildDescription.contains(nameBlack)) continue;
            String nameBlackListFailureMsg = ConfigUtil.CREATE_CONFIG.getString("nameBlackListFailureMsg", "").replace("${name}", nameBlack);
            MessageUtil.sendMessage(player, nameBlackListFailureMsg);
            return;
        }
        Optional<GuildPlayer> optional = GuildPlayerService.getInstance().findByPlayerName(player.getName());
        if (!optional.isPresent()) {
            MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("noGuildMsg"));
            return;
        }
        GuildPlayer guildPlayer = optional.get();
        Optional<GuildInfo> guildInfoOptional = GuildInfoService.getInstance().findById(guildPlayer.getGuildInfoId());
        if (!guildInfoOptional.isPresent()) {
            return;
        }
        GuildInfo guildInfo = guildInfoOptional.get();
        if (guildPlayer.getRoleId() > GuildRoleEnum.TWO.getRoleId()) {
            MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("noPermission"));
            return;
        }
        int price = ConfigUtil.SETTING_CONFIG.getInt("description.price");
        if (guildInfo.getMoney() < price) {
            MessageUtil.sendMessage(player, ConfigUtil.SETTING_CONFIG.getString("description.noButton"));
            return;
        }
        GuildInfoService.getInstance().editguildDescription(guildInfo.getId(), guildDescription, price);
        String descriptionOkButton = ConfigUtil.SETTING_CONFIG.getString("description.okButton", "");
        MessageUtil.sendMessage(player, descriptionOkButton);
    }
}

