/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.inventory;

import com.handy.guild.constants.GuiTypeEnum;
import com.handy.guild.hook.PlaceholderApiUtil;
import com.handy.guild.lib.inventory.HandyInventory;
import com.handy.guild.lib.inventory.HandyInventoryUtil;
import com.handy.guild.util.ConfigUtil;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;

public class ConfirmGui {
    private static final ConfirmGui INSTANCE = new ConfirmGui();

    private ConfirmGui() {
    }

    public static ConfirmGui getInstance() {
        return INSTANCE;
    }

    public Inventory createGui(Player player, Integer id, String type, Object obj) {
        String title = ConfigUtil.CONFIRM_CONFIG.getString("title");
        int size = ConfigUtil.CONFIRM_CONFIG.getInt("size", 27);
        title = PlaceholderApiUtil.set(player, title);
        HandyInventory handyInventory = new HandyInventory(GuiTypeEnum.CONFIRM.getType(), title, size);
        handyInventory.setPlayer(player);
        handyInventory.setId(id);
        handyInventory.setSearchType(type);
        handyInventory.setObj(obj);
        this.setInventoryDate(handyInventory);
        return handyInventory.getInventory();
    }

    public void setInventoryDate(HandyInventory handyInventory) {
        handyInventory.setGuiType(GuiTypeEnum.CONFIRM.getType());
        HandyInventoryUtil.refreshInventory(handyInventory.getInventory());
        this.setFunctionMenu(handyInventory);
    }

    private void setFunctionMenu(HandyInventory handyInventory) {
        Inventory inventory = handyInventory.getInventory();
        HandyInventoryUtil.setButton(ConfigUtil.CONFIRM_CONFIG, inventory, "confirm");
        HandyInventoryUtil.setButton(ConfigUtil.CONFIRM_CONFIG, inventory, "cancel");
        HandyInventoryUtil.setButton(ConfigUtil.CONFIRM_CONFIG, inventory, "back");
    }
}

