/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.inventory;

import com.handy.guild.constants.GuiTypeEnum;
import com.handy.guild.enter.GuildInfo;
import com.handy.guild.enter.GuildPlayer;
import com.handy.guild.hook.PlaceholderApiUtil;
import com.handy.guild.lib.core.MapUtil;
import com.handy.guild.lib.inventory.HandyInventory;
import com.handy.guild.lib.inventory.HandyInventoryUtil;
import com.handy.guild.service.GuildInfoService;
import com.handy.guild.service.GuildPlayerService;
import com.handy.guild.util.ConfigUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;

public class GuildBankGui {
    private static final GuildBankGui INSTANCE = new GuildBankGui();

    private GuildBankGui() {
    }

    public static GuildBankGui getInstance() {
        return INSTANCE;
    }

    public Inventory createGui(Player player, Integer id) {
        String title = ConfigUtil.BANK_CONFIG.getString("title");
        title = PlaceholderApiUtil.set(player, title);
        int size = ConfigUtil.BANK_CONFIG.getInt("size", 27);
        HandyInventory handyInventory = new HandyInventory(GuiTypeEnum.GUILD_BANK.getType(), title, size);
        handyInventory.setPlayer(player);
        handyInventory.setId(id);
        this.setInventoryDate(handyInventory);
        return handyInventory.getInventory();
    }

    public void setInventoryDate(HandyInventory handyInventory) {
        handyInventory.setGuiType(GuiTypeEnum.GUILD_BANK.getType());
        this.setFunctionMenu(handyInventory);
    }

    private void setFunctionMenu(HandyInventory handyInventory) {
        Inventory inventory = handyInventory.getInventory();
        Player player = handyInventory.getPlayer();
        Optional<GuildPlayer> guildPlayerOptional = GuildPlayerService.getInstance().findByPlayerName(player.getName());
        if (!guildPlayerOptional.isPresent()) {
            return;
        }
        GuildPlayer guildPlayer = guildPlayerOptional.get();
        Optional<GuildInfo> guildInfoOptional = GuildInfoService.getInstance().findById(guildPlayer.getGuildInfoId());
        if (!guildInfoOptional.isPresent()) {
            return;
        }
        GuildInfo guildInfo = guildInfoOptional.get();
        HandyInventoryUtil.setButton(ConfigUtil.BANK_CONFIG, inventory, "info", this.infoReplaceMap(guildInfo));
        HandyInventoryUtil.setButton(ConfigUtil.BANK_CONFIG, inventory, "small", this.replaceMap(guildPlayer, "small"));
        HandyInventoryUtil.setButton(ConfigUtil.BANK_CONFIG, inventory, "big", this.replaceMap(guildPlayer, "big"));
        HandyInventoryUtil.setButton(ConfigUtil.BANK_CONFIG, inventory, "all", this.replaceMap(guildPlayer, "all"));
        HandyInventoryUtil.setButton(ConfigUtil.BANK_CONFIG, inventory, "custom", this.replaceMap(guildPlayer, "custom"));
        HandyInventoryUtil.setButton(ConfigUtil.BANK_CONFIG, inventory, "back");
    }

    private Map<String, String> infoReplaceMap(GuildInfo guildInfo) {
        return MapUtil.of("money", guildInfo.getMoney().toString());
    }

    private Map<String, String> replaceMap(GuildPlayer guildPlayer, String type) {
        HashMap<String, String> map = MapUtil.newHashMapWithExpectedSize(3);
        String yes = ConfigUtil.BANK_CONFIG.getString("yesButton");
        String button = ConfigUtil.BANK_CONFIG.getString("noButton");
        int price = ConfigUtil.BANK_CONFIG.getInt(type + ".price", 1);
        int money = guildPlayer.getMoney();
        if (money >= price) {
            button = yes;
        }
        map.put("price", String.valueOf(price));
        map.put("money", Integer.toString(money));
        map.put("button", button);
        return map;
    }
}

