/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.inventory;

import com.handy.guild.constants.GuiTypeEnum;
import com.handy.guild.constants.GuildConstants;
import com.handy.guild.enter.GuildInfo;
import com.handy.guild.enter.GuildLogo;
import com.handy.guild.enter.GuildLogoShop;
import com.handy.guild.hook.PlaceholderApiUtil;
import com.handy.guild.lib.core.MapUtil;
import com.handy.guild.lib.db.enter.Page;
import com.handy.guild.lib.inventory.HandyInventory;
import com.handy.guild.lib.inventory.HandyInventoryUtil;
import com.handy.guild.lib.util.BaseUtil;
import com.handy.guild.lib.util.ItemStackUtil;
import com.handy.guild.service.GuildInfoService;
import com.handy.guild.service.GuildLogoService;
import com.handy.guild.service.GuildLogoShopService;
import com.handy.guild.util.ConfigUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class GuildLogoShopGui {
    private static final GuildLogoShopGui INSTANCE = new GuildLogoShopGui();

    private GuildLogoShopGui() {
    }

    public static GuildLogoShopGui getInstance() {
        return INSTANCE;
    }

    public Inventory createGui(Player player, Integer id) {
        String title = ConfigUtil.LOGO_SHOP_CONFIG.getString("title");
        title = PlaceholderApiUtil.set(player, title);
        int size = ConfigUtil.LOGO_SHOP_CONFIG.getInt("size", 54);
        HandyInventory handyInventory = new HandyInventory(GuiTypeEnum.GUILD_LOGO_SHOP.getType(), title, size);
        handyInventory.setPlayer(player);
        handyInventory.setId(id);
        this.setInventoryDate(handyInventory);
        return handyInventory.getInventory();
    }

    public void setInventoryDate(HandyInventory handyInventory) {
        handyInventory.setGuiType(GuiTypeEnum.GUILD_LOGO_SHOP.getType());
        HandyInventoryUtil.refreshInventory(handyInventory.getInventory());
        this.setDate(handyInventory);
        this.setFunctionMenu(handyInventory);
    }

    private void setDate(HandyInventory handyInventory) {
        Inventory inventory = handyInventory.getInventory();
        Integer guildId = handyInventory.getId();
        Map<Integer, Integer> map = handyInventory.getIntMap();
        handyInventory.setPageSize(GuildConstants.GUI_INDEX.size());
        Optional<GuildInfo> guildInfoOptional = GuildInfoService.getInstance().findById(guildId);
        if (!guildInfoOptional.isPresent()) {
            return;
        }
        GuildInfo guildInfo = guildInfoOptional.get();
        Integer money = guildInfo.getMoney();
        List<GuildLogo> guildLogoList = GuildLogoService.getInstance().list(guildId);
        List<Integer> guildLogoIdList = guildLogoList.stream().map(GuildLogo::getLogoId).collect(Collectors.toList());
        Page<GuildLogoShop> page = GuildLogoShopService.getInstance().page(guildLogoIdList, handyInventory.getPageNum(), handyInventory.getPageSize());
        handyInventory.setPageCount(page.getTotal());
        if (page.getTotal() < 1) {
            return;
        }
        List<GuildLogoShop> records = page.getRecords();
        int i = 0;
        List<Integer> guiIndexList = GuildConstants.GUI_INDEX;
        List loreList = ConfigUtil.LOGO_SHOP_CONFIG.getStringList("logo.guild");
        for (GuildLogoShop record : records) {
            Integer index = guiIndexList.get(i++);
            ItemStack itemStack = ItemStackUtil.itemStackDeserialize(record.getItemStack());
            List<String> newLoreList = ItemStackUtil.loreReplaceMap(loreList, this.replaceMap(money, record, guildInfo));
            ItemMeta itemMeta = ItemStackUtil.getItemMeta(itemStack);
            itemMeta.setLore(BaseUtil.replaceChatColor(newLoreList));
            ItemStackUtil.hideAttributes(itemMeta);
            ItemStackUtil.hideEnchant(itemMeta);
            itemStack.setItemMeta(itemMeta);
            inventory.setItem(index.intValue(), itemStack);
            map.put(index, record.getId());
        }
    }

    private void setFunctionMenu(HandyInventory handyInventory) {
        Inventory inventory = handyInventory.getInventory();
        Map<String, String> replacePageMap = HandyInventoryUtil.replacePageMap(handyInventory);
        HandyInventoryUtil.setButton(ConfigUtil.LOGO_SHOP_CONFIG, inventory, "nextPage", replacePageMap);
        HandyInventoryUtil.setButton(ConfigUtil.LOGO_SHOP_CONFIG, inventory, "previousPage", replacePageMap);
        HandyInventoryUtil.setButton(ConfigUtil.LOGO_SHOP_CONFIG, inventory, "back");
        HandyInventoryUtil.setButton(ConfigUtil.LOGO_SHOP_CONFIG, inventory, "pane");
    }

    private Map<String, String> replaceMap(Integer money, GuildLogoShop guildLogoShop, GuildInfo guildInfo) {
        HashMap<String, String> map = MapUtil.newHashMapWithExpectedSize(4);
        Integer price = guildLogoShop.getPrice();
        Integer level = guildLogoShop.getLevel();
        String button = ConfigUtil.LOGO_SHOP_CONFIG.getString("noButton");
        if (money >= price) {
            button = ConfigUtil.LOGO_SHOP_CONFIG.getString("yesButton");
        }
        if (level > guildInfo.getLevel()) {
            button = ConfigUtil.LOGO_SHOP_CONFIG.getString("levelButton", "${level}").replace("${level}", level.toString());
        }
        map.put("price", price.toString());
        map.put("level", level.toString());
        map.put("money", money.toString());
        map.put("button", button);
        return map;
    }
}

